/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.aesthetics.slab;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import mods.railcraft.client.particles.ParticleHelper;
import mods.railcraft.client.sounds.RailcraftSound;
import mods.railcraft.common.blocks.aesthetics.slab.EnumSlab;
import mods.railcraft.common.blocks.aesthetics.slab.ItemSlab;
import mods.railcraft.common.blocks.aesthetics.slab.TileSlab;
import mods.railcraft.common.core.Railcraft;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.core.RailcraftLanguage;
import mods.railcraft.common.plugins.forestry.ForestryPlugin;
import mods.railcraft.common.plugins.forge.CreativePlugin;
import mods.railcraft.common.plugins.forge.ItemRegistry;
import mods.railcraft.common.plugins.forge.WorldPlugin;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.sounds.IBlockSoundProvider;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.StepSound;
import net.minecraft.block.material.Material;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Facing;
import net.minecraft.util.Icon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;

public class BlockRailcraftSlab
extends BlockContainer
implements IBlockSoundProvider {
    private static BlockRailcraftSlab instance;
    private final int renderId;
    public static int currentRenderPass;
    public static EnumSlab textureSlab;

    public static BlockRailcraftSlab getBlock() {
        return instance;
    }

    public static void registerBlock() {
        int id;
        if (instance == null && (id = RailcraftConfig.getBlockId("block.slab")) > 0) {
            int renderId = Railcraft.getProxy().getRenderId();
            instance = new BlockRailcraftSlab(id, renderId);
            instance.func_71864_b("railcraft.slab");
            GameRegistry.registerBlock((Block)instance, ItemSlab.class, (String)instance.func_71917_a());
            GameRegistry.registerTileEntity(TileSlab.class, (String)"RCSlabTile");
            block6: for (EnumSlab stair : EnumSlab.VALUES) {
                switch (stair) {
                    case SNOW: {
                        MinecraftForge.setBlockHarvestLevel((Block)instance, (int)stair.ordinal(), (String)"shovel", (int)0);
                        break;
                    }
                    default: {
                        MinecraftForge.setBlockHarvestLevel((Block)instance, (int)stair.ordinal(), (String)"pickaxe", (int)0);
                    }
                }
                RailcraftLanguage.instance().registerItemName(stair.getItem(), stair.getTag());
                ItemRegistry.registerItemStack(stair.getTag(), stair.getItem());
                switch (stair) {
                    case SNOW: 
                    case ICE: {
                        continue block6;
                    }
                    default: {
                        ForestryPlugin.addBackpackItem("builder", stair.getItem());
                    }
                }
            }
        }
    }

    public static EnumSlab getTopSlab(IBlockAccess world, int x, int y, int z) {
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile instanceof TileSlab) {
            return ((TileSlab)tile).getTopSlab();
        }
        return null;
    }

    public static EnumSlab getBottomSlab(IBlockAccess world, int x, int y, int z) {
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile instanceof TileSlab) {
            return ((TileSlab)tile).getBottomSlab();
        }
        return null;
    }

    public static TileSlab getSlabTile(IBlockAccess world, int x, int y, int z) {
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile instanceof TileSlab) {
            return (TileSlab)tile;
        }
        return null;
    }

    protected BlockRailcraftSlab(int id, int renderId) {
        super(id, Material.field_76246_e);
        this.renderId = renderId;
        this.func_71884_a(RailcraftSound.getInstance());
        this.func_71849_a(CreativePlugin.TAB);
        BlockRailcraftSlab.field_71982_s[id] = true;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        EnumSlab slab;
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile instanceof TileSlab && (slab = ((TileSlab)tile).getUpmostSlab()) != null) {
            return new ItemStack((Block)this, 1, slab.ordinal());
        }
        return null;
    }

    public void func_71879_a(int id, CreativeTabs tab, List list) {
        for (EnumSlab slab : EnumSlab.creativeList) {
            if (!slab.isEnabled()) continue;
            list.add(slab.getItem());
        }
    }

    public ArrayList getBlockDropped(World world, int i, int j, int k, int meta, int fortune) {
        TileEntity tile = world.func_72796_p(i, j, k);
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        if (tile instanceof TileSlab) {
            EnumSlab top = ((TileSlab)tile).getTopSlab();
            EnumSlab bottom = ((TileSlab)tile).getBottomSlab();
            if (top != null) {
                items.add(new ItemStack((Block)this, 1, top.ordinal()));
            }
            if (bottom != null) {
                items.add(new ItemStack((Block)this, 1, bottom.ordinal()));
            }
        }
        return items;
    }

    public void func_71893_a(World world, EntityPlayer entityplayer, int i, int j, int k, int l) {
    }

    public boolean removeBlockByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        player.func_71064_a(StatList.field_75934_C[this.field_71990_ca], 1);
        player.func_71020_j(0.025f);
        if (Game.isHost(world) && !player.field_71075_bZ.field_75098_d) {
            this.func_71897_c(world, x, y, z, 0, 0);
        }
        return world.func_94571_i(x, y, z);
    }

    public boolean hasTileEntity(int metadata) {
        return true;
    }

    public float func_71934_m(World world, int x, int y, int z) {
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile instanceof TileSlab) {
            EnumSlab top = ((TileSlab)tile).getTopSlab();
            EnumSlab bottom = ((TileSlab)tile).getBottomSlab();
            float hardness = 0.0f;
            if (top != null) {
                hardness += top.getBlockHardness(world, x, y, z);
            }
            if (bottom != null) {
                hardness += bottom.getBlockHardness(world, x, y, z);
            }
            if (top != null && bottom != null) {
                hardness /= 2.0f;
            }
            return hardness;
        }
        return super.func_71934_m(world, x, y, z);
    }

    public float getExplosionResistance(Entity entity, World world, int x, int y, int z, double explosionX, double explosionY, double explosionZ) {
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile instanceof TileSlab) {
            EnumSlab top = ((TileSlab)tile).getTopSlab();
            EnumSlab bottom = ((TileSlab)tile).getBottomSlab();
            float resist = 0.0f;
            if (top != null) {
                resist += top.getExplosionResistance(entity);
            }
            if (bottom != null) {
                resist += bottom.getExplosionResistance(entity);
            }
            if (top != null && bottom != null) {
                resist /= 2.0f;
            }
            return resist;
        }
        return super.getExplosionResistance(entity, world, x, y, z, explosionX, explosionY, explosionZ);
    }

    public int func_71857_b() {
        return this.renderId;
    }

    public int func_71856_s_() {
        return 1;
    }

    public boolean canRenderInPass(int pass) {
        currentRenderPass = pass;
        return pass == 0 || pass == 1;
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_71858_a(int side, int meta) {
        return EnumSlab.fromOrdinal(meta).getTexture(side);
    }

    public Icon func_71895_b(IBlockAccess world, int x, int y, int z, int side) {
        if (textureSlab != null) {
            return textureSlab.getTexture(side);
        }
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile instanceof TileSlab) {
            return ((TileSlab)tile).getTexture(side);
        }
        return super.func_71895_b(world, x, y, z, side);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addBlockHitEffects(World worldObj, MovingObjectPosition target, EffectRenderer effectRenderer) {
        return ParticleHelper.addBlockHitEffects(worldObj, (Block)instance, target, effectRenderer, null);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addBlockDestroyEffects(World worldObj, int x, int y, int z, int meta, EffectRenderer effectRenderer) {
        return ParticleHelper.addBlockDestroyEffects(worldObj, (Block)instance, x, y, z, meta, effectRenderer, null);
    }

    @Override
    public StepSound getSound(World world, int x, int y, int z) {
        EnumSlab slab;
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile instanceof TileSlab && (slab = ((TileSlab)tile).getUpmostSlab()) != null) {
            return slab.getSound();
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister par1IconRegister) {
    }

    public void func_71902_a(IBlockAccess world, int x, int y, int z) {
        TileSlab slab = BlockRailcraftSlab.getSlabTile(world, x, y, z);
        if (slab != null) {
            if (slab.isDoubleSlab()) {
                this.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            } else if (slab.isBottomSlab()) {
                this.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f);
            } else if (slab.isTopSlab()) {
                this.func_71905_a(0.0f, 0.5f, 0.0f, 1.0f, 1.0f, 1.0f);
            }
        }
    }

    public void func_71919_f() {
        this.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f);
    }

    public void func_71871_a(World world, int x, int y, int z, AxisAlignedBB aabb, List list, Entity entity) {
        this.func_71902_a((IBlockAccess)world, x, y, z);
        super.func_71871_a(world, x, y, z, aabb, list, entity);
    }

    public boolean func_71926_d() {
        return false;
    }

    public boolean func_71886_c() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_71877_c(IBlockAccess world, int x, int y, int z, int side) {
        int i1 = x + Facing.field_71586_b[Facing.field_71588_a[side]];
        int j1 = y + Facing.field_71587_c[Facing.field_71588_a[side]];
        int k1 = z + Facing.field_71585_d[Facing.field_71588_a[side]];
        TileEntity tile = world.func_72796_p(i1, j1, k1);
        if (tile instanceof TileSlab) {
            TileSlab otherSlab;
            TileSlab slab = (TileSlab)tile;
            EnumSlab top = slab.getTopSlab();
            EnumSlab bottom = slab.getBottomSlab();
            if (slab.isDoubleSlab()) {
                return super.func_71877_c(world, x, y, z, side);
            }
            if (side != 1 && side != 0 && !super.func_71877_c(world, x, y, z, side)) {
                return false;
            }
            if (top != null) {
                if (side == 0) {
                    return true;
                }
                if (side == 1 && super.func_71877_c(world, x, y, z, side)) {
                    return true;
                }
                if (WorldPlugin.getBlock(world, x, y, z) != this) {
                    return true;
                }
                otherSlab = BlockRailcraftSlab.getSlabTile(world, x, y, z);
                if (otherSlab != null) {
                    if (slab.isDoubleSlab()) {
                        return false;
                    }
                    return otherSlab.isBottomSlab() || otherSlab.isTopSlab() && otherSlab.getTopSlab().isTransparent();
                }
            }
            if (bottom != null) {
                if (side == 1) {
                    return true;
                }
                if (side == 0 && super.func_71877_c(world, x, y, z, side)) {
                    return true;
                }
                if (WorldPlugin.getBlock(world, x, y, z) != this) {
                    return true;
                }
                otherSlab = BlockRailcraftSlab.getSlabTile(world, x, y, z);
                if (otherSlab != null) {
                    if (slab.isDoubleSlab()) {
                        return false;
                    }
                    return otherSlab.isTopSlab() || otherSlab.isBottomSlab() && otherSlab.getBottomSlab().isTransparent();
                }
            }
        }
        return false;
    }

    public boolean isBlockSolidOnSide(World world, int x, int y, int z, ForgeDirection side) {
        TileSlab tile = BlockRailcraftSlab.getSlabTile((IBlockAccess)world, x, y, z);
        if (tile != null) {
            if (tile.isDoubleSlab()) {
                return true;
            }
            if (side == ForgeDirection.DOWN && tile.isBottomSlab()) {
                return true;
            }
            if (side == ForgeDirection.UP && tile.isTopSlab()) {
                return true;
            }
        }
        return false;
    }

    public boolean canPlaceTorchOnTop(World world, int x, int y, int z) {
        TileSlab tile = BlockRailcraftSlab.getSlabTile((IBlockAccess)world, x, y, z);
        if (tile != null) {
            if (tile.isDoubleSlab()) {
                return true;
            }
            if (tile.isTopSlab()) {
                return true;
            }
        }
        return false;
    }

    public TileEntity func_72274_a(World world) {
        return new TileSlab();
    }

    static {
        textureSlab = null;
    }
}

