/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.detector;

import buildcraft.api.tools.IToolWrench;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.List;
import mods.railcraft.api.core.items.ITrackItem;
import mods.railcraft.client.util.textures.TextureAtlasSheet;
import mods.railcraft.common.blocks.detector.EnumDetector;
import mods.railcraft.common.blocks.detector.ItemDetector;
import mods.railcraft.common.blocks.detector.TileDetector;
import mods.railcraft.common.blocks.detector.old.TileDetectorAdvanced;
import mods.railcraft.common.blocks.detector.old.TileDetectorAnimal;
import mods.railcraft.common.blocks.detector.old.TileDetectorItem;
import mods.railcraft.common.blocks.detector.old.TileDetectorLocomotive;
import mods.railcraft.common.blocks.detector.old.TileDetectorSheep;
import mods.railcraft.common.blocks.detector.old.TileDetectorTank;
import mods.railcraft.common.blocks.detector.old.TileDetectorTrain;
import mods.railcraft.common.blocks.detector.old.TileDetectorVillager;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.core.RailcraftLanguage;
import mods.railcraft.common.items.IActivationBlockingItem;
import mods.railcraft.common.plugins.forge.CreativePlugin;
import mods.railcraft.common.plugins.forge.ItemRegistry;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.MiscTools;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockRail;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;

public class BlockDetector
extends BlockContainer {
    private static BlockDetector block;

    public static void registerBlock() {
        int id;
        if (block == null && (id = RailcraftConfig.getBlockId("block.detector")) > 0) {
            block = new BlockDetector(id);
            GameRegistry.registerBlock((Block)block, ItemDetector.class, (String)block.func_71917_a());
            GameRegistry.registerTileEntity(TileDetectorItem.class, (String)"RCDetectorItemTile");
            GameRegistry.registerTileEntity(TileDetectorAdvanced.class, (String)"RCDetectorAdvancedTile");
            GameRegistry.registerTileEntity(TileDetectorTank.class, (String)"RCDetectorTankTile");
            GameRegistry.registerTileEntity(TileDetectorAnimal.class, (String)"RCDetectorAnimalTile");
            GameRegistry.registerTileEntity(TileDetectorTrain.class, (String)"RCDetectorTrainTile");
            GameRegistry.registerTileEntity(TileDetectorSheep.class, (String)"RCDetectorSheepTile");
            GameRegistry.registerTileEntity(TileDetectorVillager.class, (String)"RCDetectorVillagerTile");
            GameRegistry.registerTileEntity(TileDetectorLocomotive.class, (String)"RCDetectorLocomotiveTile");
            MinecraftForge.setBlockHarvestLevel((Block)block, (String)"pickaxe", (int)2);
            MinecraftForge.setBlockHarvestLevel((Block)block, (String)"crowbar", (int)0);
            for (EnumDetector d : EnumDetector.VALUES) {
                ItemStack stack = new ItemStack((Block)block, 1, d.ordinal());
                String tag = d.getTag();
                RailcraftLanguage.instance().registerItemName(stack, tag);
                ItemRegistry.registerItemStack(tag, stack);
            }
        }
    }

    public static BlockDetector getBlock() {
        return block;
    }

    public BlockDetector(int blockID) {
        super(blockID, Material.field_76246_e);
        this.func_71864_b("railcraft.detector");
        this.func_71894_b(4.5f);
        this.func_71848_c(2.0f);
        this.func_71884_a(field_71976_h);
        this.func_71849_a(CreativePlugin.TAB);
        GameRegistry.registerTileEntity(TileDetector.class, (String)"RCDetectorTile");
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile instanceof TileDetector) {
            TileDetector detector = (TileDetector)tile;
            return detector.getDetector().getType().getItem();
        }
        return super.getPickBlock(target, world, x, y, z);
    }

    public boolean isBlockNormalCube(World world, int i, int j, int k) {
        return false;
    }

    public boolean isBlockSolidOnSide(World world, int i, int j, int k, ForgeDirection side) {
        return true;
    }

    public int func_71899_b(int meta) {
        return meta;
    }

    public ArrayList getBlockDropped(World world, int i, int j, int k, int md, int fortune) {
        TileEntity tile = world.func_72796_p(i, j, k);
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        if (tile instanceof TileDetector) {
            items.add(((TileDetector)tile).getDetector().getType().getItem());
        }
        return items;
    }

    public void func_71893_a(World world, EntityPlayer entityplayer, int i, int j, int k, int l) {
    }

    public boolean removeBlockByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        player.func_71064_a(StatList.field_75934_C[this.field_71990_ca], 1);
        player.func_71020_j(0.025f);
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile instanceof TileDetector) {
            ((TileDetector)tile).getDetector().onBlockRemoved();
        }
        if (Game.isHost(world) && !player.field_71075_bZ.field_75098_d) {
            this.func_71897_c(world, x, y, z, 0, 0);
        }
        return world.func_94571_i(x, y, z);
    }

    public TileEntity func_72274_a(World var1) {
        return null;
    }

    public TileEntity createTileEntity(World var1, int meta) {
        return new TileDetector();
    }

    public void func_71860_a(World world, int i, int j, int k, EntityLivingBase entityliving, ItemStack stack) {
        TileEntity tile = world.func_72796_p(i, j, k);
        if (tile instanceof TileDetector) {
            ((TileDetector)tile).direction = MiscTools.getSideClosestToPlayer(world, i, j, k, entityliving);
            ((TileDetector)tile).onBlockPlacedBy(entityliving);
        }
    }

    public boolean func_71903_a(World world, int x, int y, int z, EntityPlayer player, int side, float u1, float u2, float u3) {
        TileEntity tile;
        if (player.func_70093_af()) {
            return false;
        }
        ItemStack current = player.func_71045_bC();
        if (current != null) {
            Item item = current.func_77973_b();
            if (item instanceof IActivationBlockingItem) {
                return false;
            }
            if (item instanceof IToolWrench) {
                return false;
            }
            if (item.field_77779_bT < Block.field_71973_m.length && BlockRail.func_72184_d((int)item.field_77779_bT) || item instanceof ITrackItem) {
                return false;
            }
        }
        if ((tile = world.func_72796_p(x, y, z)) instanceof TileDetector) {
            return ((TileDetector)tile).blockActivated(player);
        }
        return false;
    }

    public void func_71863_a(World world, int x, int y, int z, int id) {
        super.func_71863_a(world, x, y, z, id);
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile instanceof TileDetector) {
            TileDetector detector = (TileDetector)tile;
            detector.onNeighborBlockChange(id);
        }
    }

    public boolean rotateBlock(World world, int x, int y, int z, ForgeDirection axis) {
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile instanceof TileDetector) {
            TileDetector detector = (TileDetector)tile;
            detector.direction = detector.direction == axis ? axis.getOpposite() : axis;
            world.func_72845_h(x, y, z);
            return true;
        }
        return false;
    }

    public ForgeDirection[] getValidRotations(World worldObj, int x, int y, int z) {
        return ForgeDirection.VALID_DIRECTIONS;
    }

    public void func_94332_a(IconRegister iconRegister) {
        for (EnumDetector det : EnumDetector.VALUES) {
            String name = "railcraft:" + det.getTag();
            det.textures = TextureAtlasSheet.unstitchIcons(iconRegister, name, 3);
        }
    }

    public Icon func_71895_b(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile instanceof TileDetector) {
            TileDetector detectorTile = (TileDetector)tile;
            EnumDetector det = detectorTile.getDetector().getType();
            if (detectorTile.direction.ordinal() == side) {
                if (detectorTile.powerState != 0) {
                    return det.textures[2];
                }
                return det.textures[1];
            }
            return det.textures[0];
        }
        return null;
    }

    public Icon func_71858_a(int side, int meta) {
        EnumDetector det = EnumDetector.fromOrdinal(meta);
        if (side == 3) {
            return det.textures[2];
        }
        return det.textures[0];
    }

    public float func_71934_m(World world, int x, int y, int z) {
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile instanceof TileDetector) {
            return ((TileDetector)tile).getDetector().getHardness();
        }
        return super.func_71934_m(world, x, y, z);
    }

    public boolean func_71853_i() {
        return true;
    }

    public int func_71865_a(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity t = world.func_72796_p(x, y, z);
        if (t instanceof TileDetector) {
            TileDetector tile = (TileDetector)t;
            if (tile.direction == MiscTools.getOppositeSide(side)) {
                return tile.powerState;
            }
        }
        return 0;
    }

    public int func_71855_c(IBlockAccess world, int x, int y, int z, int side) {
        return this.func_71865_a(world, x, y, z, side);
    }

    public void func_71861_g(World world, int i, int j, int k) {
        super.func_71861_g(world, i, j, k);
        world.func_72845_h(i, j, k);
        if (Game.isNotHost(world)) {
            return;
        }
        world.func_72898_h(i + 1, j, k, this.field_71990_ca);
        world.func_72898_h(i - 1, j, k, this.field_71990_ca);
        world.func_72898_h(i, j, k + 1, this.field_71990_ca);
        world.func_72898_h(i, j, k - 1, this.field_71990_ca);
        world.func_72898_h(i, j - 1, k, this.field_71990_ca);
        world.func_72898_h(i, j + 1, k, this.field_71990_ca);
    }

    public void func_71852_a(World world, int x, int y, int z, int id, int metadata) {
        super.func_71852_a(world, x, y, z, id, metadata);
        if (Game.isNotHost(world)) {
            return;
        }
        world.func_72898_h(x + 1, y, z, this.field_71990_ca);
        world.func_72898_h(x - 1, y, z, this.field_71990_ca);
        world.func_72898_h(x, y, z + 1, this.field_71990_ca);
        world.func_72898_h(x, y, z - 1, this.field_71990_ca);
        world.func_72898_h(x, y - 1, z, this.field_71990_ca);
        world.func_72898_h(x, y + 1, z, this.field_71990_ca);
    }

    public boolean canConnectRedstone(IBlockAccess world, int i, int j, int k, int dir) {
        TileEntity t = world.func_72796_p(i, j, k);
        if (t instanceof TileDetector) {
            TileDetector tile = (TileDetector)t;
            if (dir == 1 && tile.direction.ordinal() == 5) {
                return true;
            }
            if (dir == 3 && tile.direction.ordinal() == 4) {
                return true;
            }
            if (dir == 2 && tile.direction.ordinal() == 3) {
                return true;
            }
            if (dir == 0 && tile.direction.ordinal() == 2) {
                return true;
            }
        }
        return false;
    }

    public void func_71879_a(int id, CreativeTabs tab, List list) {
        for (EnumDetector detector : EnumDetector.VALUES) {
            if (!detector.isEnabled()) continue;
            list.add(detector.getItem());
        }
    }
}

