/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.alpha;

import cpw.mods.fml.common.ObfuscationReflectionHelper;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import mods.railcraft.common.blocks.machine.alpha.EntityAIDespawn;
import mods.railcraft.common.blocks.machine.alpha.EntityAISitBred;
import mods.railcraft.common.blocks.machine.alpha.EntityAISitRandom;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAISit;
import net.minecraft.entity.ai.EntityAITaskEntry;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.world.World;

public class EntityAIMateBreeding
extends EntityAIBase {
    private static final int MAX_ANIMALS = 6;
    private EntityAnimal theAnimal;
    World theWorld;
    private EntityAnimal targetMate;
    int spawnBabyDelay = 0;
    float moveSpeed;

    public EntityAIMateBreeding(EntityAnimal animal, float moveSpeed) {
        this.theAnimal = animal;
        this.theWorld = animal.field_70170_p;
        this.moveSpeed = moveSpeed;
    }

    public boolean func_75250_a() {
        if (!this.theAnimal.func_70880_s()) {
            return false;
        }
        List nearbyEntites = this.theAnimal.field_70170_p.func_72872_a(EntityAnimal.class, this.theAnimal.field_70121_D.func_72314_b(1.0, 1.0, 1.0));
        if (nearbyEntites.size() > 6) {
            return false;
        }
        this.targetMate = this.getNearbyMate();
        return this.targetMate != null;
    }

    public boolean func_75253_b() {
        return this.targetMate.func_70089_S() && this.targetMate.func_70880_s() && this.spawnBabyDelay < 60;
    }

    public void func_75251_c() {
        this.targetMate = null;
        this.spawnBabyDelay = 0;
    }

    public void func_75246_d() {
        this.theAnimal.func_70671_ap().func_75651_a((Entity)this.targetMate, 10.0f, (float)this.theAnimal.func_70646_bf());
        this.theAnimal.func_70661_as().func_75497_a((Entity)this.targetMate, (double)this.moveSpeed);
        ++this.spawnBabyDelay;
        if (this.spawnBabyDelay == 60) {
            double litterSize = 1.75;
            if (this.theAnimal instanceof EntityCow || this.theAnimal instanceof EntitySheep) {
                litterSize = 0.0;
            }
            int babies = 1;
            if (litterSize > 0.0) {
                babies += (int)Math.round(Math.abs(this.theAnimal.func_70681_au().nextGaussian()) * litterSize);
            }
            for (int i = 0; i < babies; ++i) {
                this.spawnBaby();
            }
        }
    }

    public static void modifyAI(EntityAnimal animal) {
        boolean tame = animal instanceof EntityTameable;
        int matePriority = -1;
        int sitPriority = -1;
        boolean hasDespawn = false;
        Iterator it = animal.field_70714_bg.field_75782_a.iterator();
        while (it.hasNext()) {
            EntityAITaskEntry task = (EntityAITaskEntry)it.next();
            if (tame && task.field_75733_a instanceof EntityAISit) {
                sitPriority = task.field_75731_b;
                it.remove();
                continue;
            }
            if (task.field_75733_a instanceof EntityAIMate) {
                matePriority = task.field_75731_b;
                it.remove();
                continue;
            }
            if (!(task.field_75733_a instanceof EntityAIDespawn)) continue;
            hasDespawn = true;
        }
        if (tame) {
            ((EntityTameable)animal).func_70903_f(true);
        }
        if (!hasDespawn) {
            animal.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIDespawn((EntityAgeable)animal));
        }
        if (matePriority > 0) {
            animal.field_70714_bg.func_75776_a(matePriority, (EntityAIBase)new EntityAIMateBreeding(animal, 0.25f));
            if (tame) {
                animal.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAISitRandom((EntityTameable)animal));
            }
        }
        if (sitPriority > 0) {
            EntityAISitBred aiSit = new EntityAISitBred((EntityTameable)animal);
            animal.field_70714_bg.func_75776_a(sitPriority, (EntityAIBase)aiSit);
            ObfuscationReflectionHelper.setPrivateValue(EntityTameable.class, (Object)((EntityTameable)animal), (Object)((Object)aiSit), (int)0);
        }
    }

    private EntityAnimal getNearbyMate() {
        EntityAnimal target;
        float var1 = 8.0f;
        List var2 = this.theWorld.func_72872_a(this.theAnimal.getClass(), this.theAnimal.field_70121_D.func_72314_b((double)var1, (double)var1, (double)var1));
        Iterator entity = var2.iterator();
        do {
            if (entity.hasNext()) continue;
            return null;
        } while (!this.canMateWith(this.theAnimal, target = (EntityAnimal)entity.next()));
        return target;
    }

    public boolean canMateWith(EntityAnimal animal, EntityAnimal target) {
        if (target == animal) {
            return false;
        }
        if (animal.getClass() == target.getClass()) {
            boolean isSitting = target instanceof EntityTameable && ((EntityTameable)target).func_70906_o();
            return !isSitting && animal.func_70880_s() && target.func_70880_s();
        }
        return false;
    }

    private void spawnBaby() {
        EntityAgeable baby = this.theAnimal.func_90011_a((EntityAgeable)this.targetMate);
        if (baby instanceof EntityAnimal) {
            this.theAnimal.func_70873_a(3600);
            this.targetMate.func_70873_a(3600);
            this.theAnimal.func_70875_t();
            this.targetMate.func_70875_t();
            baby.func_70873_a(-12000);
            EntityAIMateBreeding.modifyAI((EntityAnimal)baby);
            Random rand = this.theAnimal.func_70681_au();
            if (baby instanceof EntityOcelot) {
                EntityOcelot cat = (EntityOcelot)baby;
                if (rand.nextInt(10) == 0) {
                    cat.func_70912_b(baby.field_70170_p.field_73012_v.nextInt(4));
                }
            }
            double x = rand.nextGaussian() * 0.2;
            double z = rand.nextGaussian() * 0.2;
            baby.func_70012_b(this.theAnimal.field_70165_t + x, this.theAnimal.field_70163_u, this.theAnimal.field_70161_v + z, 0.0f, 0.0f);
            this.theWorld.func_72838_d((Entity)baby);
            for (int i = 0; i < 7; ++i) {
                double px = rand.nextGaussian() * 0.02;
                double py = rand.nextGaussian() * 0.02;
                double pz = rand.nextGaussian() * 0.02;
                this.theWorld.func_72869_a("heart", this.theAnimal.field_70165_t + (double)(rand.nextFloat() * this.theAnimal.field_70130_N * 2.0f) - (double)this.theAnimal.field_70130_N, this.theAnimal.field_70163_u + 0.5 + (double)(rand.nextFloat() * this.theAnimal.field_70131_O), this.theAnimal.field_70161_v + (double)(rand.nextFloat() * this.theAnimal.field_70130_N * 2.0f) - (double)this.theAnimal.field_70130_N, px, py, pz);
            }
        }
    }
}

