/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.alpha;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import mods.railcraft.client.util.textures.TextureAtlasSheet;
import mods.railcraft.common.blocks.RailcraftBlocks;
import mods.railcraft.common.blocks.machine.IEnumMachine;
import mods.railcraft.common.blocks.machine.TileMachineBase;
import mods.railcraft.common.blocks.machine.alpha.TileAnchorAdmin;
import mods.railcraft.common.blocks.machine.alpha.TileAnchorPersonal;
import mods.railcraft.common.blocks.machine.alpha.TileAnchorWorld;
import mods.railcraft.common.blocks.machine.alpha.TileBlastFurnace;
import mods.railcraft.common.blocks.machine.alpha.TileCokeOven;
import mods.railcraft.common.blocks.machine.alpha.TileEngravingBench;
import mods.railcraft.common.blocks.machine.alpha.TileFeedStation;
import mods.railcraft.common.blocks.machine.alpha.TileRockCrusher;
import mods.railcraft.common.blocks.machine.alpha.TileRollingMachine;
import mods.railcraft.common.blocks.machine.alpha.TileSmoker;
import mods.railcraft.common.blocks.machine.alpha.TileSteamOven;
import mods.railcraft.common.blocks.machine.alpha.TileSteamTrapAuto;
import mods.railcraft.common.blocks.machine.alpha.TileSteamTrapManual;
import mods.railcraft.common.blocks.machine.alpha.TileSteamTurbine;
import mods.railcraft.common.blocks.machine.alpha.TileTankWater;
import mods.railcraft.common.carts.ItemCartAnchor;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.core.RailcraftLanguage;
import mods.railcraft.common.gui.tooltips.ToolTip;
import mods.railcraft.common.modules.ModuleManager;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;

public enum EnumMachineAlpha implements IEnumMachine
{
    WORLD_ANCHOR(ModuleManager.Module.CHUNK_LOADING, "anchor.world", TileAnchorWorld.class, new int[]{3, 1, 0, 0, 1, 1, 1, 1, 2}),
    TURBINE(ModuleManager.Module.IC2, "turbine", TileSteamTurbine.class, new int[]{3, 3, 2, 2, 2, 2, 6, 2, 0, 1, 3, 4, 5, 7}),
    PERSONAL_ANCHOR(ModuleManager.Module.CHUNK_LOADING, "anchor.personal", TileAnchorPersonal.class, new int[]{3, 1, 0, 0, 1, 1, 1, 1, 2}),
    STEAM_OVEN(ModuleManager.Module.FACTORY, "steam.oven", TileSteamOven.class, new int[]{4, 2, 2, 2, 3, 3, 6, 3, 0, 1, 4, 5}),
    ADMIN_ANCHOR(ModuleManager.Module.CHUNK_LOADING, "anchor.admin", TileAnchorAdmin.class, new int[]{3, 1, 0, 0, 1, 1, 1, 1, 2}),
    SMOKER(ModuleManager.Module.STRUCTURES, "smoker", TileSmoker.class, new int[]{3, 1, 0, 1, 2, 2, 2, 2}),
    UNUSED(null, "engraving.bench", TileEngravingBench.class, new int[]{4, 1, 0, 1, 3, 3, 3, 3, 2}),
    COKE_OVEN(ModuleManager.Module.FACTORY, "coke.oven", TileCokeOven.class, new int[]{3, 1, 0, 0, 0, 0, 1, 0, 1, 2}),
    ROLLING_MACHINE(ModuleManager.Module.FACTORY, "rolling.machine", TileRollingMachine.class, new int[]{3, 1, 0, 1, 2, 2, 2, 2}),
    STEAM_TRAP_MANUAL(ModuleManager.Module.EXTRAS, "steam.trap", TileSteamTrapManual.class, new int[]{3, 1, 0, 2, 1, 1, 1, 1, 0, 1, 2}),
    STEAM_TRAP_AUTO(ModuleManager.Module.EXTRAS, "steam.trap.auto", TileSteamTrapAuto.class, new int[]{4, 1, 0, 2, 1, 1, 1, 1, 0, 1, 2, 3}),
    FEED_STATION(ModuleManager.Module.AUTOMATION, "feed.station", TileFeedStation.class, new int[]{2, 1, 0, 0, 1, 1, 1, 1}),
    BLAST_FURNACE(ModuleManager.Module.FACTORY, "blast.furnace", TileBlastFurnace.class, new int[]{3, 1, 0, 0, 0, 0, 1, 0, 1, 2}),
    ENGRAVING_BENCH(ModuleManager.Module.EMBLEM, "engraving.bench", TileEngravingBench.class, new int[]{4, 1, 0, 1, 3, 3, 3, 3, 2}),
    TANK_WATER(ModuleManager.Module.TRANSPORT, "tank.water", TileTankWater.class, new int[]{2, 1, 0, 0, 1, 1, 1, 1}),
    ROCK_CRUSHER(ModuleManager.Module.FACTORY, "rock.crusher", TileRockCrusher.class, new int[]{4, 3, 3, 11, 3, 3, 7, 3, 7, 0, 1, 2, 4, 6, 8, 9, 10});

    private final ModuleManager.Module module;
    private final String tag;
    private final Class tile;
    private final int[] textureInfo;
    private Icon[] texture = new Icon[12];
    private static final List creativeList;
    private static final EnumMachineAlpha[] VALUES;
    private ToolTip tip;

    /*
     * WARNING - Possible parameter corruption
     * WARNING - void declaration
     */
    private EnumMachineAlpha(Class module3, int ... tag) {
        void textureInfo;
        void tile;
        this.module = module3;
        this.tile = tile;
        this.tag = tag;
        this.textureInfo = textureInfo;
    }

    @Override
    public boolean isDepreciated() {
        return this.module == null;
    }

    @Override
    public Icon getTexture(int index) {
        if (index < 0 || index >= this.texture.length) {
            index = 0;
        }
        return this.texture[index];
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerIcons(IconRegister iconRegister) {
        for (EnumMachineAlpha machine : VALUES) {
            if (machine.isDepreciated()) continue;
            machine.texture = new Icon[machine.textureInfo.length - 2];
            int columns = machine.textureInfo[0];
            int rows = machine.textureInfo[1];
            Icon[] icons = TextureAtlasSheet.unstitchIcons(iconRegister, "railcraft:" + machine.tag, columns, rows);
            for (int i = 0; i < machine.texture.length; ++i) {
                machine.texture[i] = icons[machine.textureInfo[i + 2]];
            }
        }
    }

    public static EnumMachineAlpha fromId(int id) {
        if (id < 0 || id >= VALUES.length) {
            id = 0;
        }
        return VALUES[id];
    }

    public static List getCreativeList() {
        return creativeList;
    }

    @Override
    public String getTag() {
        return "railcraft.machine.alpha." + this.tag;
    }

    @Override
    public Class getTileClass() {
        return this.tile;
    }

    public TileMachineBase getTileEntity() {
        try {
            return (TileMachineBase)this.tile.newInstance();
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public ItemStack getItem() {
        return this.getItem(1);
    }

    @Override
    public ItemStack getItem(int qty) {
        Block block = this.getBlock();
        if (block == null) {
            return null;
        }
        return new ItemStack(block, qty, this.ordinal());
    }

    public ModuleManager.Module getModule() {
        return this.module;
    }

    @Override
    public Block getBlock() {
        return RailcraftBlocks.getBlockMachineAlpha();
    }

    @Override
    public int getBlockId() {
        Block block = this.getBlock();
        if (block != null) {
            return block.field_71990_ca;
        }
        return 0;
    }

    public boolean isEnabled() {
        return ModuleManager.isModuleLoaded(this.getModule()) && RailcraftConfig.isSubBlockEnabled(this.getTag());
    }

    @Override
    public boolean isAvaliable() {
        return this.getBlock() != null && this.isEnabled();
    }

    public ToolTip getToolTip(ItemStack stack, EntityPlayer player, boolean adv) {
        if (this.tip != null) {
            return this.tip;
        }
        switch (this) {
            case WORLD_ANCHOR: {
                if (RailcraftConfig.anchorRefuel() <= 0) break;
                return this.addAnchorInfo(stack);
            }
            case PERSONAL_ANCHOR: {
                if (RailcraftConfig.anchorRefuelPersonal() <= 0) break;
                return this.addAnchorInfo(stack);
            }
            default: {
                String tipTag = "gui.tip." + this.tag;
                if (!RailcraftLanguage.hasTag(tipTag)) break;
                this.tip = ToolTip.buildToolTip(tipTag, new String[0]);
            }
        }
        return this.tip;
    }

    private ToolTip addAnchorInfo(ItemStack stack) {
        ToolTip toolTip = new ToolTip();
        long fuel = ItemCartAnchor.getFuel(stack);
        double hours = (double)fuel / 72000.0;
        String format = RailcraftLanguage.translate("gui.anchor.fuel.remaining");
        toolTip.add(String.format(format, hours));
        return toolTip;
    }

    public boolean register() {
        if (RailcraftConfig.isSubBlockEnabled(this.getTag())) {
            RailcraftBlocks.registerBlockMachineAlpha();
            if (this.getBlock() != null) {
                ItemStack stack = this.getItem();
                RailcraftLanguage.instance().registerItemName(stack, this.getTag());
                return true;
            }
        }
        return false;
    }

    static {
        creativeList = new ArrayList();
        VALUES = EnumMachineAlpha.values();
        creativeList.add(COKE_OVEN);
        creativeList.add(BLAST_FURNACE);
        creativeList.add(STEAM_OVEN);
        creativeList.add(TANK_WATER);
        creativeList.add(ROLLING_MACHINE);
        creativeList.add(ENGRAVING_BENCH);
        creativeList.add(ROCK_CRUSHER);
        creativeList.add(FEED_STATION);
        creativeList.add(WORLD_ANCHOR);
        creativeList.add(PERSONAL_ANCHOR);
        creativeList.add(ADMIN_ANCHOR);
        creativeList.add(TURBINE);
        creativeList.add(SMOKER);
        creativeList.add(STEAM_TRAP_MANUAL);
        creativeList.add(STEAM_TRAP_AUTO);
    }
}

