/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.alpha;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import mods.railcraft.api.core.WorldCoordinate;
import mods.railcraft.api.core.items.IToolCrowbar;
import mods.railcraft.common.blocks.machine.IEnumMachine;
import mods.railcraft.common.blocks.machine.TileMachineItem;
import mods.railcraft.common.blocks.machine.alpha.EnumMachineAlpha;
import mods.railcraft.common.blocks.machine.beta.EnumMachineBeta;
import mods.railcraft.common.blocks.machine.beta.TileSentinel;
import mods.railcraft.common.carts.ItemCartAnchor;
import mods.railcraft.common.core.Railcraft;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.core.RailcraftLanguage;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.plugins.forge.PowerPlugin;
import mods.railcraft.common.util.effects.EffectManager;
import mods.railcraft.common.util.misc.ChunkManager;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.IAnchor;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;

public class TileAnchorWorld
extends TileMachineItem
implements IAnchor,
ISidedInventory {
    public static final Map pairingMap = Collections.synchronizedMap(new HashMap());
    private static final int SENTINEL_CHECK = 128;
    private static final byte MAX_CHUNKS = 25;
    private static final byte FUEL_CYCLE = 9;
    private static final byte ANCHOR_RADIUS = 1;
    private static final int[] SLOTS = new int[]{0};
    private static final int[] SLOTS_NOACCESS = new int[0];
    private int xSentinel = -1;
    private int ySentinel = -1;
    private int zSentinel = -1;
    protected ForgeChunkManager.Ticket ticket;
    private Set chunks;
    private long fuel;
    private int fuelCycle;
    private boolean hasTicket;
    private boolean refreshTicket;
    private boolean powered;

    public TileAnchorWorld() {
        super(1);
    }

    @Override
    public int func_70302_i_() {
        return this.getRefuelTime() > 0 ? 1 : 0;
    }

    @Override
    public IEnumMachine getMachineType() {
        return EnumMachineAlpha.WORLD_ANCHOR;
    }

    @Override
    public Icon getIcon(int side) {
        if (!this.hasTicket && side < 2) {
            return this.getMachineType().getTexture(6);
        }
        return this.getMachineType().getTexture(side);
    }

    @Override
    public boolean blockActivated(EntityPlayer player, int side) {
        WorldCoordinate sentinel;
        IToolCrowbar crowbar;
        ItemStack current = player.func_71045_bC();
        if (current != null && current.func_77973_b() instanceof IToolCrowbar && (crowbar = (IToolCrowbar)current.func_77973_b()).canWhack(player, current, this.field_70329_l, this.field_70330_m, this.field_70327_n) && (sentinel = (WorldCoordinate)pairingMap.get(player)) != null) {
            if (this.field_70331_k.field_73011_w.field_76574_g == sentinel.dimension) {
                this.setSentinel(player, sentinel.x, sentinel.y, sentinel.z);
                crowbar.onWhack(player, current, this.field_70329_l, this.field_70330_m, this.field_70327_n);
            }
            return true;
        }
        return super.blockActivated(player, side);
    }

    @Override
    public boolean openGui(EntityPlayer player) {
        if (this.getRefuelTime() > 0) {
            GuiHandler.openGui(EnumGui.WORLD_ANCHOR, player, this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
            return true;
        }
        return false;
    }

    public int getMaxSentinelChunks() {
        if (this.ticket == null) {
            return 25;
        }
        return Math.min(this.ticket.getMaxChunkListDepth(), 25);
    }

    public void setSentinel(EntityPlayer player, int x, int y, int z) {
        TileEntity tile = this.field_70331_k.func_72796_p(x, y, z);
        if (tile instanceof TileSentinel) {
            int xChunk = this.field_70329_l >> 4;
            int zChunk = this.field_70327_n >> 4;
            int xSentinelChunk = tile.field_70329_l >> 4;
            int zSentinelChunk = tile.field_70327_n >> 4;
            if (xChunk != xSentinelChunk && zChunk != zSentinelChunk) {
                if (Game.isNotHost(this.field_70331_k)) {
                    String message = RailcraftLanguage.translate("gui.anchor.pair.fail.alignment");
                    player.func_71035_c(String.format(message, this.func_70303_b(), RailcraftLanguage.translate(EnumMachineBeta.SENTINEL.getTag())));
                }
                return;
            }
            int max = this.getMaxSentinelChunks();
            if (Math.abs(xChunk - xSentinelChunk) >= max || Math.abs(zChunk - zSentinelChunk) >= max) {
                if (Game.isNotHost(this.field_70331_k)) {
                    String message = RailcraftLanguage.translate("gui.anchor.pair.fail.distance");
                    player.func_71035_c(String.format(message, this.func_70303_b(), RailcraftLanguage.translate(EnumMachineBeta.SENTINEL.getTag())));
                }
                return;
            }
            this.xSentinel = tile.field_70329_l;
            this.ySentinel = tile.field_70330_m;
            this.zSentinel = tile.field_70327_n;
            if (Game.isHost(this.field_70331_k)) {
                this.requestTicket();
                this.sendUpdateToClient();
            } else {
                String message = RailcraftLanguage.translate("gui.anchor.pair.success");
                player.func_71035_c(String.format(message, this.func_70303_b()));
            }
        }
    }

    public void clearSentinel() {
        if (!this.hasSentinel()) {
            return;
        }
        this.xSentinel = -1;
        this.ySentinel = -1;
        this.zSentinel = -1;
        this.requestTicket();
        this.sendUpdateToClient();
    }

    public boolean hasSentinel() {
        return this.ySentinel != -1;
    }

    public boolean hasFuel() {
        return this.fuel > 0L;
    }

    @Override
    public ArrayList getBlockDropped(int fortune) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        ItemStack drop = this.getMachineType().getItem();
        if (this.getRefuelTime() > 0 && this.hasFuel()) {
            NBTTagCompound nbt = new NBTTagCompound("tag");
            nbt.func_74772_a("fuel", this.fuel);
            drop.func_77982_d(nbt);
        }
        items.add(drop);
        return items;
    }

    @Override
    public void initFromItem(ItemStack stack) {
        super.initFromItem(stack);
        if (this.getRefuelTime() > 0) {
            this.fuel = ItemCartAnchor.getFuel(stack);
        }
    }

    @Override
    public void func_70316_g() {
        TileEntity tile;
        int hoursPerFeeding;
        super.func_70316_g();
        if (Game.isNotHost(this.field_70331_k)) {
            if (this.chunks != null) {
                EffectManager.instance.chunkLoaderEffect(this.field_70331_k, this, this.chunks);
            }
            return;
        }
        if (RailcraftConfig.deleteAnchors()) {
            this.releaseTicket();
            this.field_70331_k.func_94575_c(this.field_70329_l, this.field_70330_m, this.field_70327_n, Block.field_72089_ap.field_71990_ca);
            return;
        }
        if (this.ticket != null && (this.refreshTicket || this.powered)) {
            this.releaseTicket();
        }
        if ((hoursPerFeeding = this.getRefuelTime()) > 0) {
            ++this.fuelCycle;
            if (this.fuelCycle >= 9) {
                this.fuelCycle = 0;
                if (this.chunks != null && this.ticket != null && this.fuel > 0L) {
                    this.fuel -= (long)this.chunks.size();
                }
                if (this.fuel <= 0L) {
                    ItemStack stack = this.func_70301_a(0);
                    if (stack == null || stack.field_77994_a <= 0) {
                        this.func_70299_a(0, null);
                        this.releaseTicket();
                    } else if (RailcraftConfig.isAnchorFuel(stack)) {
                        this.func_70298_a(0, 1);
                        this.fuel = (long)hoursPerFeeding * 72000L;
                    }
                }
            }
        }
        if (this.clock % 128 == 0 && this.hasSentinel() && !((tile = this.field_70331_k.func_72796_p(this.xSentinel, this.ySentinel, this.zSentinel)) instanceof TileSentinel)) {
            this.clearSentinel();
        }
        if (this.ticket == null) {
            this.requestTicket();
        }
    }

    @Override
    public void onBlockRemoval() {
        super.onBlockRemoval();
        this.releaseTicket();
    }

    @Override
    public void func_70313_j() {
        super.func_70313_j();
        this.refreshTicket = true;
    }

    @Override
    public void func_70312_q() {
        super.func_70312_q();
        this.refreshTicket = true;
    }

    protected void releaseTicket() {
        this.refreshTicket = false;
        this.setTicket(null);
    }

    protected void requestTicket() {
        ForgeChunkManager.Ticket chunkTicket;
        if (this.meetsTicketRequirements() && (chunkTicket = this.getTicketFromForge()) != null) {
            this.setTicketData(chunkTicket);
            this.forceChunkLoading(chunkTicket);
        }
    }

    protected int getRefuelTime() {
        return RailcraftConfig.anchorRefuel();
    }

    protected boolean meetsTicketRequirements() {
        return !this.powered && (this.hasFuel() || this.getRefuelTime() <= 0);
    }

    protected ForgeChunkManager.Ticket getTicketFromForge() {
        return ForgeChunkManager.requestTicket((Object)Railcraft.getMod(), (World)this.field_70331_k, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
    }

    protected void setTicketData(ForgeChunkManager.Ticket chunkTicket) {
        chunkTicket.getModData().func_74768_a("xCoord", this.field_70329_l);
        chunkTicket.getModData().func_74768_a("yCoord", this.field_70330_m);
        chunkTicket.getModData().func_74768_a("zCoord", this.field_70327_n);
    }

    public void setTicket(ForgeChunkManager.Ticket ticket) {
        boolean changed = false;
        if (this.ticket != ticket) {
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.ticket);
            changed = true;
        }
        this.ticket = ticket;
        boolean bl = this.hasTicket = ticket != null;
        if (changed) {
            this.sendUpdateToClient();
        }
    }

    public void forceChunkLoading(ForgeChunkManager.Ticket ticket) {
        this.setTicket(ticket);
        this.setupChunks();
        if (this.chunks != null) {
            for (ChunkCoordIntPair chunk : this.chunks) {
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkCoordIntPair)chunk);
            }
        }
    }

    public void setupChunks() {
        this.chunks = !this.hasTicket ? null : (this.hasSentinel() ? ChunkManager.getInstance().getChunksBetween(this.field_70329_l >> 4, this.field_70327_n >> 4, this.xSentinel >> 4, this.zSentinel >> 4, this.getMaxSentinelChunks()) : ChunkManager.getInstance().getChunksAround(this.field_70329_l >> 4, this.field_70327_n >> 4, 1));
    }

    public boolean isPowered() {
        return this.powered;
    }

    public void setPowered(boolean power) {
        this.powered = power;
    }

    @Override
    public void onNeighborBlockChange(int id) {
        super.onNeighborBlockChange(id);
        if (Game.isNotHost(this.getWorld())) {
            return;
        }
        boolean newPower = PowerPlugin.isBlockBeingPowered(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
        if (this.powered != newPower) {
            this.powered = newPower;
        }
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeBoolean(this.hasTicket);
        data.writeInt(this.xSentinel);
        data.writeInt(this.ySentinel);
        data.writeInt(this.zSentinel);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        boolean tick = data.readBoolean();
        if (this.hasTicket != tick) {
            this.hasTicket = tick;
            this.markBlockForUpdate();
        }
        this.xSentinel = data.readInt();
        this.ySentinel = data.readInt();
        this.zSentinel = data.readInt();
        this.setupChunks();
    }

    @Override
    public void func_70310_b(NBTTagCompound data) {
        super.func_70310_b(data);
        data.func_74772_a("fuel", this.fuel);
        data.func_74757_a("powered", this.powered);
        data.func_74768_a("xSentinel", this.xSentinel);
        data.func_74768_a("ySentinel", this.ySentinel);
        data.func_74768_a("zSentinel", this.zSentinel);
    }

    @Override
    public void func_70307_a(NBTTagCompound data) {
        super.func_70307_a(data);
        if (this.getRefuelTime() > 0) {
            this.fuel = data.func_74763_f("fuel");
        }
        this.powered = data.func_74767_n("powered");
        this.xSentinel = data.func_74762_e("xSentinel");
        this.ySentinel = data.func_74762_e("ySentinel");
        this.zSentinel = data.func_74762_e("zSentinel");
    }

    @Override
    public float getResistance(Entity exploder) {
        return 60.0f;
    }

    @Override
    public float getHardness() {
        return 20.0f;
    }

    @Override
    public long getAnchorFuel() {
        return this.fuel;
    }

    public int[] func_94128_d(int var1) {
        if (RailcraftConfig.anchorsCanInteractWithPipes()) {
            return SLOTS;
        }
        return SLOTS_NOACCESS;
    }

    public boolean func_102007_a(int i, ItemStack itemstack, int j) {
        return RailcraftConfig.anchorsCanInteractWithPipes();
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return false;
    }
}

