/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.alpha;

import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.logging.Level;
import mods.railcraft.api.core.items.IStackFilter;
import mods.railcraft.common.blocks.machine.IEnumMachine;
import mods.railcraft.common.blocks.machine.TileMachineItem;
import mods.railcraft.common.blocks.machine.alpha.EntityAIMateBreeding;
import mods.railcraft.common.blocks.machine.alpha.EnumMachineAlpha;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.plugins.forge.PowerPlugin;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.inventory.filters.StackFilter;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.MiscTools;
import mods.railcraft.common.util.network.ITileExtraDataHandler;
import mods.railcraft.common.util.network.PacketTileExtraData;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Icon;

public class TileFeedStation
extends TileMachineItem
implements ITileExtraDataHandler {
    private static final int AREA = 3;
    private static final int MIN_FEED_INTERVAL = 128;
    private static final int FEED_VARIANCE = 256;
    private static final byte ANIMALS_PER_FOOD = 2;
    private static final Random rand = MiscTools.getRand();
    private int feedTime;
    private byte feedCounter;
    private boolean powered;

    public TileFeedStation() {
        super(1);
    }

    @Override
    public IEnumMachine getMachineType() {
        return EnumMachineAlpha.FEED_STATION;
    }

    @Override
    public boolean openGui(EntityPlayer player) {
        GuiHandler.openGui(EnumGui.FEED_STATION, player, this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
        return true;
    }

    @Override
    public Icon getIcon(int side) {
        return this.getMachineType().getTexture(side);
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        if (Game.isNotHost(this.getWorld())) {
            return;
        }
        ItemStack feed = this.func_70301_a(0);
        if (this.clock % 32 == 0 && (feed == null || feed.field_77994_a < feed.func_77976_d())) {
            IInventory inv;
            List chests = InvTools.getAdjacentInventories(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
            Iterator i$ = chests.iterator();
            while (i$.hasNext() && InvTools.moveOneItem(inv = (IInventory)i$.next(), (IInventory)this, (IStackFilter)StackFilter.FEED) == null) {
            }
        }
        feed = this.func_70301_a(0);
        --this.feedTime;
        if (!this.powered && feed != null && feed.field_77994_a > 0 && this.feedTime <= 0) {
            this.feedTime = 128 + rand.nextInt(256);
            AxisAlignedBB box = AxisAlignedBB.func_72332_a().func_72299_a((double)this.field_70329_l, (double)(this.field_70330_m - 1), (double)this.field_70327_n, (double)(this.field_70329_l + 1), (double)(this.field_70330_m + 3), (double)(this.field_70327_n + 1));
            box = box.func_72314_b(3.0, 0.0, 3.0);
            List animals = this.field_70331_k.func_72872_a(EntityAnimal.class, box);
            for (EntityAnimal target : animals) {
                if (!target.func_70877_b(this.func_70301_a(0)) || !this.feedAnimal(target)) continue;
                if (this.feedCounter <= 0) {
                    this.func_70299_a(0, InvTools.depleteItem(feed));
                    this.feedCounter = (byte)2;
                }
                this.feedCounter = (byte)(this.feedCounter - 1);
                this.sendFeedPacket(target);
                break;
            }
        }
    }

    public void sendFeedPacket(EntityAnimal animal) {
        try {
            PacketTileExtraData pkt = new PacketTileExtraData(this);
            DataOutputStream data = pkt.getDataStream();
            data.writeInt(animal.field_70157_k);
            PacketDispatcher.sendPacketToAllAround((double)this.field_70329_l, (double)this.field_70330_m, (double)this.field_70327_n, (double)80.0, (int)this.field_70331_k.field_73011_w.field_76574_g, (Packet)pkt.getPacket());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onUpdatePacket(DataInputStream data) throws IOException {
        Entity e = this.field_70331_k.func_73045_a(data.readInt());
        if (e instanceof EntityAnimal) {
            this.feedAnimal((EntityAnimal)e);
        }
    }

    private boolean feedAnimal(EntityAnimal animal) {
        if (animal == null) {
            return false;
        }
        try {
            if (animal.func_70874_b() == 0 && !animal.func_70880_s()) {
                if (Game.isHost(this.field_70331_k)) {
                    EntityAIMateBreeding.modifyAI(animal);
                }
                animal.field_70881_d = 600;
                animal.func_70784_b(null);
                for (int i = 0; i < 7; ++i) {
                    double d = rand.nextGaussian() * 0.02;
                    double d1 = rand.nextGaussian() * 0.02;
                    double d2 = rand.nextGaussian() * 0.02;
                    this.field_70331_k.func_72869_a("heart", animal.field_70165_t + (double)(rand.nextFloat() * animal.field_70130_N * 2.0f) - (double)animal.field_70130_N, animal.field_70163_u + 0.5 + (double)(rand.nextFloat() * animal.field_70131_O), animal.field_70161_v + (double)(rand.nextFloat() * animal.field_70130_N * 2.0f) - (double)animal.field_70130_N, d, d1, d2);
                }
                return true;
            }
        }
        catch (Throwable ex) {
            Game.log(Level.SEVERE, "Feed Station encountered error, {0}", ex);
        }
        return false;
    }

    @Override
    public void onNeighborBlockChange(int id) {
        super.onNeighborBlockChange(id);
        this.powered = PowerPlugin.isBlockBeingPowered(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    @Override
    public void func_70307_a(NBTTagCompound data) {
        super.func_70307_a(data);
        this.powered = data.func_74767_n("powered");
        this.feedCounter = data.func_74771_c("feedCounter");
    }

    @Override
    public void func_70310_b(NBTTagCompound data) {
        super.func_70310_b(data);
        data.func_74757_a("powered", this.powered);
        data.func_74774_a("feedCounter", this.feedCounter);
    }
}

