/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.gamma;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.api.carts.CartTools;
import mods.railcraft.common.blocks.machine.IEnumMachine;
import mods.railcraft.common.blocks.machine.gamma.EnumMachineGamma;
import mods.railcraft.common.blocks.machine.gamma.TileLoaderLiquidBase;
import mods.railcraft.common.carts.CartUtils;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.core.RailcraftLanguage;
import mods.railcraft.common.fluids.FluidHelper;
import mods.railcraft.common.fluids.Fluids;
import mods.railcraft.common.fluids.TankManager;
import mods.railcraft.common.fluids.TankToolkit;
import mods.railcraft.common.fluids.tanks.StandardTank;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.gui.buttons.IButtonTextureSet;
import mods.railcraft.common.gui.buttons.IMultiButtonState;
import mods.railcraft.common.gui.buttons.MultiButtonController;
import mods.railcraft.common.gui.buttons.StandardButtonTextureSets;
import mods.railcraft.common.gui.tooltips.ToolTip;
import mods.railcraft.common.util.inventory.PhantomInventory;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.network.IGuiReturnHandler;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Icon;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;

public class TileLiquidUnloader
extends TileLoaderLiquidBase
implements IGuiReturnHandler {
    private static final int CAPACITY = 32000;
    private static final int TRANSFER_RATE = 80;
    private final StandardTank tank = new StandardTank(32000, this);
    private final PhantomInventory invFilter = new PhantomInventory(1);
    private MultiButtonController stateController = new MultiButtonController(ButtonState.EMPTY_COMPLETELY.ordinal(), ButtonState.values());

    public TileLiquidUnloader() {
        this.tankManager.add(this.tank);
    }

    @Override
    public IEnumMachine getMachineType() {
        return EnumMachineGamma.LIQUID_UNLOADER;
    }

    public PhantomInventory getLiquidFilter() {
        return this.invFilter;
    }

    public MultiButtonController getStateController() {
        return this.stateController;
    }

    @Override
    public Icon getIcon(int side) {
        if (side > 1) {
            return this.getMachineType().getTexture(6);
        }
        return this.getMachineType().getTexture(side);
    }

    public Fluid getFilterFluid() {
        if (this.invFilter.func_70301_a(0) != null) {
            FluidStack fluidStack = FluidHelper.getFluidStackInContainer(this.invFilter.func_70301_a(0));
            return fluidStack != null ? fluidStack.getFluid() : null;
        }
        return null;
    }

    @Override
    public boolean blockActivated(EntityPlayer player, int side) {
        return super.blockActivated(player, side);
    }

    @Override
    public void func_70316_g() {
        ItemStack bottomSlot;
        super.func_70316_g();
        if (Game.isNotHost(this.getWorld())) {
            return;
        }
        ItemStack topSlot = this.func_70301_a(0);
        if (topSlot != null && !FluidHelper.isContainer(topSlot)) {
            this.func_70299_a(0, null);
            this.dropItem(topSlot);
        }
        if ((bottomSlot = this.func_70301_a(1)) != null && !FluidHelper.isContainer(bottomSlot)) {
            this.func_70299_a(1, null);
            this.dropItem(bottomSlot);
        }
        if (this.clock % 8 == 0) {
            FluidHelper.fillContainers(this.tankManager, this, 0, 1, this.tank.getFluidType());
        }
        this.tankManager.outputLiquid(this.tileCache, TankManager.TANK_FILTER, ForgeDirection.VALID_DIRECTIONS, 0, 80);
        EntityMinecart cart = CartTools.getMinecartOnSide(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, 0.1f, ForgeDirection.UP);
        if (cart != this.currentCart) {
            this.setPowered(false);
            this.currentCart = cart;
            this.cartWasSent();
        }
        if (cart == null) {
            return;
        }
        if (!(cart instanceof IFluidHandler)) {
            if (CartTools.cartVelocityIsLessThan(cart, 0.02f)) {
                this.setPowered(true);
            }
            return;
        }
        if (this.isSendCartGateAction()) {
            if (CartTools.cartVelocityIsLessThan(cart, 0.02f)) {
                this.setPowered(true);
            }
            return;
        }
        ItemStack minecartSlot1 = this.getCartFilters().func_70301_a(0);
        ItemStack minecartSlot2 = this.getCartFilters().func_70301_a(1);
        if (!(minecartSlot1 == null && minecartSlot2 == null || CartUtils.doesCartMatchFilter(minecartSlot1, cart) || CartUtils.doesCartMatchFilter(minecartSlot2, cart))) {
            if (CartTools.cartVelocityIsLessThan(cart, 0.02f)) {
                this.setPowered(true);
            }
            return;
        }
        if (this.isPaused()) {
            return;
        }
        TankToolkit tankCart = new TankToolkit((IFluidHandler)cart);
        this.flow = 0;
        FluidStack drained = tankCart.drain(ForgeDirection.DOWN, RailcraftConfig.getTankCartFillRate(), false);
        if (this.getFilterFluid() == null || Fluids.areEqual(this.getFilterFluid(), drained)) {
            this.flow = this.tankManager.get(0).fill(drained, true);
            tankCart.drain(ForgeDirection.DOWN, this.flow, true);
        }
        if (this.flow > 0) {
            this.setPowered(false);
        }
        if (this.stateController.getButtonState() != ButtonState.MANUAL && this.flow <= 0 && !this.isPowered() && this.shouldSendCart(cart, tankCart)) {
            this.setPowered(true);
        }
    }

    private boolean shouldSendCart(EntityMinecart cart, TankToolkit tankCart) {
        if (!CartTools.cartVelocityIsLessThan(cart, 0.02f)) {
            return false;
        }
        if (this.stateController.getButtonState() != ButtonState.EMPTY_COMPLETELY) {
            return true;
        }
        if (this.getFilterFluid() != null && tankCart.isTankEmpty(this.getFilterFluid())) {
            return true;
        }
        return tankCart.areTanksEmpty();
    }

    @Override
    protected void setPowered(boolean p) {
        if (this.stateController.getButtonState() == ButtonState.MANUAL) {
            p = false;
        }
        super.setPowered(p);
    }

    @Override
    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return 0;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    @Override
    public void func_70310_b(NBTTagCompound data) {
        super.func_70310_b(data);
        this.stateController.writeToNBT(data, "state");
        this.getLiquidFilter().writeToNBT("invFilter", data);
    }

    @Override
    public void func_70307_a(NBTTagCompound data) {
        super.func_70307_a(data);
        this.stateController.readFromNBT(data, "state");
        if (data.func_74764_b("filter")) {
            NBTTagCompound filter = data.func_74775_l("filter");
            this.getLiquidFilter().readFromNBT("Items", filter);
        } else {
            this.getLiquidFilter().readFromNBT("invFilter", data);
        }
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeByte(this.stateController.getCurrentState());
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.stateController.setCurrentState(data.readByte());
    }

    @Override
    public void writeGuiData(DataOutputStream data) throws IOException {
        data.writeByte(this.stateController.getCurrentState());
    }

    @Override
    public void readGuiData(DataInputStream data, EntityPlayer sender) throws IOException {
        this.stateController.setCurrentState(data.readByte());
    }

    public ForgeDirection getOrientation() {
        return ForgeDirection.UP;
    }

    @Override
    public boolean openGui(EntityPlayer player) {
        GuiHandler.openGui(EnumGui.UNLOADER_LIQUID, player, this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
        return true;
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        switch (slot) {
            case 0: {
                return FluidHelper.isEmptyContainer(stack);
            }
        }
        return false;
    }

    public static enum ButtonState implements IMultiButtonState
    {
        EMPTY_COMPLETELY("gui.liquid.unloader.empty"),
        IMMEDIATE("gui.liquid.unloader.immediate"),
        MANUAL("gui.liquid.unloader.manual");

        private String label;
        private final ToolTip tip;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        private ButtonState() {
            void label;
            this.label = label;
            this.tip = ToolTip.buildToolTip((String)label + ".tip", new String[0]);
        }

        @Override
        public String getLabel() {
            return RailcraftLanguage.translate(this.label);
        }

        @Override
        public IButtonTextureSet getTextureSet() {
            return StandardButtonTextureSets.SMALL_BUTTON;
        }

        @Override
        public ToolTip getToolTip() {
            return this.tip;
        }
    }
}

