/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.signals;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.api.signals.IControllerTile;
import mods.railcraft.api.signals.SignalAspect;
import mods.railcraft.api.signals.SimpleSignalController;
import mods.railcraft.common.blocks.signals.EnumSignal;
import mods.railcraft.common.blocks.signals.ISignalBlockTile;
import mods.railcraft.common.blocks.signals.ISignalTile;
import mods.railcraft.common.blocks.signals.SignalBlock;
import mods.railcraft.common.blocks.signals.SignalBlockSimple;
import mods.railcraft.common.blocks.signals.TileSignalBase;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.nbt.NBTTagCompound;

public class TileSignalBlockSignal
extends TileSignalBase
implements IControllerTile,
ISignalTile,
ISignalBlockTile {
    private final SimpleSignalController controller = new SimpleSignalController(this.func_70303_b(), this);
    private final SignalBlock signalBlock = new SignalBlockSimple(this);

    @Override
    public EnumSignal getSignalType() {
        return EnumSignal.BLOCK_SIGNAL;
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        if (Game.isNotHost(this.field_70331_k)) {
            this.controller.tickClient();
            this.signalBlock.tickClient();
            return;
        }
        this.controller.tickServer();
        this.signalBlock.tickServer();
        SignalAspect prevAspect = this.controller.getAspect();
        if (this.controller.isBeingPaired()) {
            this.controller.setAspect(SignalAspect.BLINK_YELLOW);
        } else {
            this.controller.setAspect(this.signalBlock.getSignalAspect());
        }
        if (prevAspect != this.controller.getAspect()) {
            this.sendUpdateToClient();
        }
    }

    @Override
    public SignalAspect getSignalAspect() {
        return this.controller.getAspect();
    }

    @Override
    public void func_70310_b(NBTTagCompound data) {
        super.func_70310_b(data);
        this.signalBlock.writeToNBT(data);
        this.controller.writeToNBT(data);
    }

    @Override
    public void func_70307_a(NBTTagCompound data) {
        int z;
        int y;
        int x;
        super.func_70307_a(data);
        this.signalBlock.readFromNBT(data);
        if (data.func_74764_b("BlockPairX")) {
            x = data.func_74762_e("BlockPairX");
            y = data.func_74762_e("BlockPairY");
            z = data.func_74762_e("BlockPairZ");
            this.signalBlock.registerLegacyBlock(x, y, z);
        }
        this.controller.readFromNBT(data);
        if (data.func_74764_b("ReceiverX")) {
            x = data.func_74762_e("ReceiverX");
            y = data.func_74762_e("ReceiverY");
            z = data.func_74762_e("ReceiverZ");
            this.controller.registerLegacyReceiver(x, y, z);
        }
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        this.controller.writePacketData(data);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.controller.readPacketData(data);
    }

    @Override
    public SimpleSignalController getController() {
        return this.controller;
    }

    @Override
    public SignalBlock getSignalBlock() {
        return this.signalBlock;
    }
}

