/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.signals;

import java.util.List;
import mods.railcraft.api.tracks.ITrackInstance;
import mods.railcraft.api.tracks.ITrackSwitch;
import mods.railcraft.common.blocks.signals.EnumSignal;
import mods.railcraft.common.blocks.signals.IRouter;
import mods.railcraft.common.blocks.signals.IRoutingTile;
import mods.railcraft.common.blocks.signals.RoutingLogic;
import mods.railcraft.common.blocks.signals.TileSwitchSecured;
import mods.railcraft.common.blocks.tracks.TileTrack;
import mods.railcraft.common.carts.CartUtils;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.gui.buttons.MultiButtonController;
import mods.railcraft.common.items.ItemRoutingTable;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.inventory.StandaloneInventory;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.ForgeDirection;

public class TileSwitchRouting
extends TileSwitchSecured
implements IRouter,
IRoutingTile {
    private RoutingLogic logic;
    private StandaloneInventory inv = new StandaloneInventory(1, this);
    private MultiButtonController routingController = new MultiButtonController(0, IRouter.RoutingButtonState.values());

    @Override
    public MultiButtonController getRoutingController() {
        return this.routingController;
    }

    @Override
    public EnumSignal getSignalType() {
        return EnumSignal.SWITCH_ROUTING;
    }

    @Override
    public boolean blockActivated(int side, EntityPlayer player) {
        if (Game.isHost(this.field_70331_k)) {
            GuiHandler.openGui(EnumGui.ROUTING, player, this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
        }
        return true;
    }

    @Override
    public void onBlockRemoval() {
        super.onBlockRemoval();
        InvTools.dropInventory(this.inv, this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        if (Game.isNotHost(this.field_70331_k)) {
            return;
        }
        this.refreshLogic();
        boolean shouldSwitch = false;
        for (int side = 2; side < 6; side = (int)((byte)(side + 1))) {
            TileEntity tile = this.tileCache.getTileOnSide(ForgeDirection.getOrientation((int)side));
            if (tile instanceof TileTrack) {
                ITrackInstance track = ((TileTrack)tile).getTrackInstance();
                shouldSwitch |= track instanceof ITrackSwitch && this.isRoutedCartApproaching((ITrackSwitch)track);
                continue;
            }
            shouldSwitch |= tile instanceof ITrackSwitch && this.isRoutedCartApproaching((ITrackSwitch)tile);
        }
        this.switchTrack(shouldSwitch);
    }

    private boolean isRoutedCartApproaching(ITrackSwitch track) {
        if (this.logic == null || !this.logic.isValid()) {
            return false;
        }
        AxisAlignedBB searchBox = track.getRoutingSearchBox();
        List carts = CartUtils.getMinecartsIn(this.field_70331_k, searchBox);
        for (EntityMinecart cart : carts) {
            if (!this.logic.matches(this, cart)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void onNeighborBlockChange(int blockId) {
        super.onNeighborBlockChange(blockId);
        boolean power = this.isBeingPoweredByRedstone();
        if (this.isPowered() != power) {
            this.setPowered(power);
        }
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.resetLogic();
    }

    @Override
    public RoutingLogic getLogic() {
        this.refreshLogic();
        return this.logic;
    }

    @Override
    public void resetLogic() {
        this.logic = null;
    }

    private void refreshLogic() {
        if (this.logic == null && this.inv.func_70301_a(0) != null) {
            this.logic = ItemRoutingTable.getLogic(this.inv.func_70301_a(0));
        }
    }

    @Override
    public void func_70310_b(NBTTagCompound data) {
        super.func_70310_b(data);
        this.inv.writeToNBT("inv", data);
        this.routingController.writeToNBT(data, "railwayType");
    }

    @Override
    public void func_70307_a(NBTTagCompound data) {
        super.func_70307_a(data);
        this.inv.readFromNBT("inv", data);
        this.routingController.readFromNBT(data, "railwayType");
    }

    @Override
    public IInventory getInventory() {
        return this.inv;
    }
}

