/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.tracks;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.api.core.items.IToolCrowbar;
import mods.railcraft.api.tracks.ITrackPowered;
import mods.railcraft.common.blocks.tracks.EnumTrack;
import mods.railcraft.common.blocks.tracks.EnumTrackMeta;
import mods.railcraft.common.blocks.tracks.TrackBaseRailcraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet39AttachEntity;
import net.minecraft.util.Icon;

public class TrackDisembark
extends TrackBaseRailcraft
implements ITrackPowered {
    private static final int TIME_TILL_NEXT_MOUNT = 40;
    private boolean powered = false;
    private boolean mirrored = false;

    @Override
    public EnumTrack getTrackType() {
        return EnumTrack.DISEMBARK;
    }

    @Override
    public Icon getIcon() {
        if (this.mirrored) {
            if (this.isPowered()) {
                return this.getIcon(2);
            }
            return this.getIcon(3);
        }
        if (this.isPowered()) {
            return this.getIcon(0);
        }
        return this.getIcon(1);
    }

    @Override
    public void onMinecartPass(EntityMinecart cart) {
        if (this.powered && cart.canBeRidden() && cart.field_70153_n != null) {
            double x = this.getX();
            double z = this.getZ();
            double offset = 1.5;
            if (EnumTrackMeta.fromMeta(this.getTile().func_70322_n()).isNorthSouthTrack()) {
                x = this.mirrored ? (x += offset) : (x -= offset);
            } else {
                z = this.mirrored ? (z += offset) : (z -= offset);
            }
            Entity rider = cart.field_70153_n;
            rider.field_70154_o = null;
            cart.field_70153_n = null;
            if (rider instanceof EntityPlayerMP) {
                EntityPlayerMP player = (EntityPlayerMP)rider;
                player.field_71135_a.func_72567_b((Packet)new Packet39AttachEntity(0, rider, null));
                player.func_70634_a(x + 0.5, (double)(this.getY() + 1), z + 0.5);
            } else {
                rider.func_70012_b(x + 0.5, (double)(this.getY() + 1), z + 0.5, rider.field_70177_z, rider.field_70125_A);
            }
            cart.getEntityData().func_74768_a("MountPrevention", 40);
        }
    }

    @Override
    public boolean blockActivated(EntityPlayer player) {
        IToolCrowbar crowbar;
        ItemStack current = player.func_71045_bC();
        if (current != null && current.func_77973_b() instanceof IToolCrowbar && (crowbar = (IToolCrowbar)current.func_77973_b()).canWhack(player, current, this.getX(), this.getY(), this.getZ())) {
            this.mirror();
            crowbar.onWhack(player, current, this.getX(), this.getY(), this.getZ());
            this.sendUpdateToClient();
            return true;
        }
        return false;
    }

    @Override
    public boolean isPowered() {
        return this.powered;
    }

    @Override
    public void setPowered(boolean powered) {
        this.powered = powered;
    }

    public boolean isMirrored() {
        return this.powered;
    }

    public void mirror() {
        this.mirrored = !this.mirrored;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.func_74757_a("powered", this.powered);
        nbttagcompound.func_74757_a("mirrored", this.mirrored);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.powered = nbttagcompound.func_74767_n("powered");
        this.mirrored = nbttagcompound.func_74767_n("mirrored");
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeBoolean(this.powered);
        data.writeBoolean(this.mirrored);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.powered = data.readBoolean();
        this.mirrored = data.readBoolean();
        this.markBlockNeedsUpdate();
    }
}

