/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.tracks;

import mods.railcraft.api.tracks.ITrackCustomPlaced;
import mods.railcraft.common.blocks.RailcraftBlocks;
import mods.railcraft.common.blocks.tracks.BlockTrack;
import mods.railcraft.common.blocks.tracks.EnumTrack;
import mods.railcraft.common.blocks.tracks.EnumTrackMeta;
import mods.railcraft.common.blocks.tracks.TrackBaseRailcraft;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.block.BlockRail;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class TrackSuspended
extends TrackBaseRailcraft
implements ITrackCustomPlaced {
    @Override
    public EnumTrack getTrackType() {
        return EnumTrack.SUSPENDED;
    }

    @Override
    public boolean canMakeSlopes() {
        return false;
    }

    @Override
    public void onBlockPlaced() {
        super.onBlockPlaced();
        if (!this.isSupported()) {
            this.breakRail();
        }
    }

    @Override
    public void onNeighborBlockChange(int id) {
        World world = this.getWorld();
        int i = this.tileEntity.field_70329_l;
        int j = this.tileEntity.field_70330_m;
        int k = this.tileEntity.field_70327_n;
        if (this.isSupported()) {
            int myId = RailcraftBlocks.getBlockTrack().field_71990_ca;
            if (id != myId) {
                world.func_72898_h(i + 1, j, k, myId);
                world.func_72898_h(i - 1, j, k, myId);
                world.func_72898_h(i, j, k + 1, myId);
                world.func_72898_h(i, j, k - 1, myId);
            }
        } else {
            this.breakRail();
        }
    }

    public void breakRail() {
        if (Game.isHost(this.getWorld())) {
            BlockTrack block = (BlockTrack)RailcraftBlocks.getBlockTrack();
            this.getWorld().func_94578_a(this.tileEntity.field_70329_l, this.tileEntity.field_70330_m, this.tileEntity.field_70327_n, true);
        }
    }

    public boolean isSupportedRail(World world, int i, int j, int k, int meta) {
        if (!BlockRail.func_72180_d_((World)world, (int)i, (int)j, (int)k)) {
            return false;
        }
        if (this.isSupportedBelow(world, i, j, k)) {
            return true;
        }
        if (meta == EnumTrackMeta.NORTH_SOUTH.ordinal()) {
            if (this.isSupportedBelow(world, i, j, k + 1)) {
                return true;
            }
            return this.isSupportedBelow(world, i, j, k - 1);
        }
        if (meta == EnumTrackMeta.EAST_WEST.ordinal()) {
            if (this.isSupportedBelow(world, i + 1, j, k)) {
                return true;
            }
            return this.isSupportedBelow(world, i - 1, j, k);
        }
        return false;
    }

    public boolean isSupportedBelow(World world, int i, int j, int k) {
        if (!world.func_72899_e(i, j, k)) {
            return true;
        }
        if (BlockRail.func_72180_d_((World)world, (int)i, (int)j, (int)k)) {
            return world.isBlockSolidOnSide(i, j - 1, k, ForgeDirection.UP);
        }
        return false;
    }

    public boolean isSupported() {
        int meta = this.tileEntity.func_70322_n();
        return this.isSupported(this.getWorld(), this.tileEntity.field_70329_l, this.tileEntity.field_70330_m, this.tileEntity.field_70327_n, meta);
    }

    public boolean isSupported(World world, int i, int j, int k, int meta) {
        if (this.isSupportedRail(world, i, j, k, meta)) {
            return true;
        }
        if (meta == EnumTrackMeta.NORTH_SOUTH.ordinal()) {
            return this.isSupportedRail(world, i, j, k + 1, meta) || this.isSupportedRail(world, i, j, k - 1, meta);
        }
        if (meta == EnumTrackMeta.EAST_WEST.ordinal()) {
            return this.isSupportedRail(world, i + 1, j, k, meta) || this.isSupportedRail(world, i - 1, j, k, meta);
        }
        return false;
    }

    @Override
    public boolean canPlaceRailAt(World world, int i, int j, int k) {
        if (this.isSupported(world, i, j, k, 0) || this.isSupported(world, i, j, k, 1)) {
            return true;
        }
        return world.isBlockSolidOnSide(i, j - 1, k, ForgeDirection.UP);
    }
}

