/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.tracks;

import mods.railcraft.api.tracks.ITrackInstance;
import mods.railcraft.common.blocks.tracks.TileTrack;
import mods.railcraft.common.blocks.tracks.TrackBaseRailcraft;
import mods.railcraft.common.blocks.tracks.speedcontroller.SpeedControllerHighSpeed;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRailBase;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class TrackTools {
    public static final int TRAIN_LOCKDOWN_DELAY = 100;

    public static boolean isRailBlockAt(World world, int x, int y, int z) {
        return BlockRailBase.func_72180_d_((World)world, (int)x, (int)y, (int)z);
    }

    public static boolean isRailBlock(int blockId) {
        return BlockRailBase.func_72184_d((int)blockId);
    }

    public static int getTrackMeta(World world, EntityMinecart cart, int x, int y, int z) {
        return TrackTools.getTrackMeta(world, world.func_72798_a(x, y, z), cart, x, y, z);
    }

    public static int getTrackMeta(World world, int blockId, EntityMinecart cart, int x, int y, int z) {
        return ((BlockRailBase)Block.field_71973_m[blockId]).getBasicRailMetadata((IBlockAccess)world, cart, x, y, z);
    }

    public static ITrackInstance getTrackInstanceAt(World world, int x, int y, int z) {
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile instanceof TileTrack) {
            return ((TileTrack)tile).getTrackInstance();
        }
        return null;
    }

    public static boolean isHighSpeedTrackAt(World world, int x, int y, int z) {
        ITrackInstance track = TrackTools.getTrackInstanceAt(world, x, y, z);
        if (track instanceof TrackBaseRailcraft) {
            return ((TrackBaseRailcraft)track).speedController instanceof SpeedControllerHighSpeed;
        }
        return false;
    }

    public static boolean areTracksConnectedAlongAxis(World world, int x1, int y1, int z1, int x2, int y2, int z2) {
        block13: {
            int yy;
            int max;
            int min;
            block12: {
                int yy2;
                int max2;
                int min2;
                if (y1 < 0 || y2 < 0) {
                    return false;
                }
                if (x1 != x2 && z1 != z2) {
                    return false;
                }
                if (x1 == x2) break block12;
                if (x1 < x2) {
                    min2 = x1;
                    max2 = x2;
                    yy2 = y1;
                } else {
                    min2 = x2;
                    max2 = x1;
                    yy2 = y2;
                }
                for (int xx = min2; xx <= max2; ++xx) {
                    if (BlockRailBase.func_72180_d_((World)world, (int)xx, (int)yy2, (int)z1)) continue;
                    if (BlockRailBase.func_72180_d_((World)world, (int)xx, (int)(yy2 - 1), (int)z1)) {
                        --yy2;
                        continue;
                    }
                    if (BlockRailBase.func_72180_d_((World)world, (int)xx, (int)(yy2 + 1), (int)z1)) {
                        ++yy2;
                        continue;
                    }
                    return false;
                }
                break block13;
            }
            if (z1 == z2) break block13;
            if (z1 < z2) {
                min = z1;
                max = z2;
                yy = y1;
            } else {
                min = z2;
                max = z1;
                yy = y2;
            }
            for (int zz = min; zz <= max; ++zz) {
                if (BlockRailBase.func_72180_d_((World)world, (int)x1, (int)yy, (int)zz)) continue;
                if (BlockRailBase.func_72180_d_((World)world, (int)x1, (int)(yy - 1), (int)zz)) {
                    --yy;
                    continue;
                }
                if (BlockRailBase.func_72180_d_((World)world, (int)x1, (int)(yy + 1), (int)zz)) {
                    ++yy;
                    continue;
                }
                return false;
            }
        }
        return true;
    }
}

