/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.carts;

import com.google.common.collect.MapMaker;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import mods.railcraft.api.carts.CartTools;
import mods.railcraft.api.carts.ILinkableCart;
import mods.railcraft.api.carts.ILinkageManager;
import mods.railcraft.common.carts.Train;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;

public class LinkageManager
implements ILinkageManager {
    private final Map carts = new MapMaker().weakValues().makeMap();
    private final Map trains = new HashMap();
    public static final String LINK_A_HIGH = "rcLinkAHigh";
    public static final String LINK_A_LOW = "rcLinkALow";
    public static final String LINK_B_HIGH = "rcLinkBHigh";
    public static final String LINK_B_LOW = "rcLinkBLow";
    public static final String TRAIN_HIGH = "rcTrainHigh";
    public static final String TRAIN_LOW = "rcTrainLow";

    private LinkageManager() {
    }

    public static LinkageManager instance() {
        return (LinkageManager)CartTools.linkageManager;
    }

    public static void printDebug(String msg, Object ... args) {
        if (RailcraftConfig.printLinkingDebug()) {
            Game.log(Level.FINEST, msg, args);
        }
    }

    public static void reset() {
        CartTools.linkageManager = new LinkageManager();
    }

    public void removeLinkageId(EntityMinecart cart) {
        this.carts.remove(this.getLinkageId(cart));
    }

    public UUID getLinkageId(EntityMinecart cart) {
        UUID id = cart.getPersistentID();
        if (!cart.field_70128_L) {
            this.carts.put(id, cart);
        }
        return id;
    }

    public EntityMinecart getCartFromLinkageId(UUID id) {
        EntityMinecart cart = (EntityMinecart)this.carts.get(id);
        if (cart != null && cart.field_70128_L) {
            this.carts.remove(id);
            return null;
        }
        return (EntityMinecart)this.carts.get(id);
    }

    private float getLinkageDistanceSq(EntityMinecart cart1, EntityMinecart cart2) {
        float dist = 0.0f;
        dist = cart1 instanceof ILinkableCart ? (dist += ((ILinkableCart)cart1).getLinkageDistance(cart2)) : (dist += 1.25f);
        dist = cart2 instanceof ILinkableCart ? (dist += ((ILinkableCart)cart2).getLinkageDistance(cart1)) : (dist += 1.25f);
        return dist * dist;
    }

    private boolean canLinkCarts(EntityMinecart cart1, EntityMinecart cart2) {
        ILinkableCart link;
        if (cart1 == null || cart2 == null) {
            return false;
        }
        if (cart1 == cart2) {
            return false;
        }
        if (!(!(cart1 instanceof ILinkableCart) || (link = (ILinkableCart)cart1).isLinkable() && link.canLinkWithCart(cart2))) {
            return false;
        }
        if (!(!(cart2 instanceof ILinkableCart) || (link = (ILinkableCart)cart2).isLinkable() && link.canLinkWithCart(cart1))) {
            return false;
        }
        if (this.areLinked(cart1, cart2)) {
            return false;
        }
        if (cart1.func_70068_e((Entity)cart2) > (double)this.getLinkageDistanceSq(cart1, cart2)) {
            return false;
        }
        return this.hasFreeLink(cart1) && this.hasFreeLink(cart2);
    }

    @Override
    public boolean createLink(EntityMinecart cart1, EntityMinecart cart2) {
        if (this.canLinkCarts(cart1, cart2)) {
            this.setLink(cart1, cart2);
            this.setLink(cart2, cart1);
            if (cart1 instanceof ILinkableCart) {
                ((ILinkableCart)cart1).onLinkCreated(cart2);
            }
            if (cart2 instanceof ILinkableCart) {
                ((ILinkableCart)cart2).onLinkCreated(cart1);
            }
            return true;
        }
        return false;
    }

    private boolean hasFreeLink(EntityMinecart cart) {
        return this.getLinkedCartA(cart) == null || this.hasLinkB(cart) && this.getLinkedCartB(cart) == null;
    }

    private boolean hasLinkB(EntityMinecart cart) {
        if (cart instanceof ILinkableCart) {
            return ((ILinkableCart)cart).hasTwoLinks();
        }
        return true;
    }

    private void setLink(EntityMinecart cart1, EntityMinecart cart2) {
        if (this.getLinkedCartA(cart1) == null) {
            this.setLinkA(cart1, cart2);
        } else if (this.hasLinkB(cart1) && this.getLinkedCartB(cart1) == null) {
            this.setLinkB(cart1, cart2);
        }
    }

    public UUID getLinkA(EntityMinecart cart) {
        long high = cart.getEntityData().func_74763_f(LINK_A_HIGH);
        long low = cart.getEntityData().func_74763_f(LINK_A_LOW);
        return new UUID(high, low);
    }

    private void setLinkA(EntityMinecart cart1, EntityMinecart cart2) {
        this.resetTrain(cart1);
        this.resetTrain(cart2);
        UUID id = this.getLinkageId(cart2);
        cart1.getEntityData().func_74772_a(LINK_A_HIGH, id.getMostSignificantBits());
        cart1.getEntityData().func_74772_a(LINK_A_LOW, id.getLeastSignificantBits());
    }

    @Override
    public EntityMinecart getLinkedCartA(EntityMinecart cart) {
        return this.getCartFromLinkageId(this.getLinkA(cart));
    }

    public UUID getLinkB(EntityMinecart cart) {
        long high = cart.getEntityData().func_74763_f(LINK_B_HIGH);
        long low = cart.getEntityData().func_74763_f(LINK_B_LOW);
        return new UUID(high, low);
    }

    private void setLinkB(EntityMinecart cart1, EntityMinecart cart2) {
        if (!this.hasLinkB(cart1)) {
            return;
        }
        this.resetTrain(cart1);
        this.resetTrain(cart2);
        UUID id = this.getLinkageId(cart2);
        cart1.getEntityData().func_74772_a(LINK_B_HIGH, id.getMostSignificantBits());
        cart1.getEntityData().func_74772_a(LINK_B_LOW, id.getLeastSignificantBits());
    }

    @Override
    public EntityMinecart getLinkedCartB(EntityMinecart cart) {
        return this.getCartFromLinkageId(this.getLinkB(cart));
    }

    public Train getTrain(EntityMinecart cart) {
        if (cart == null) {
            return null;
        }
        Train train = (Train)this.trains.get(this.getTrainUUID(cart));
        if (train != null && !train.containsCart(cart)) {
            train.releaseTrain();
            this.trains.remove(train.getUUID());
            train = null;
        }
        if (train == null) {
            train = new Train(cart);
            this.trains.put(train.getUUID(), train);
        }
        return train;
    }

    public UUID getTrainUUID(EntityMinecart cart) {
        long high = cart.getEntityData().func_74763_f(TRAIN_HIGH);
        long low = cart.getEntityData().func_74763_f(TRAIN_LOW);
        return new UUID(high, low);
    }

    private void resetTrain(EntityMinecart cart) {
        Train train = (Train)this.trains.remove(this.getTrainUUID(cart));
        if (train != null) {
            train.releaseTrain();
        }
    }

    public boolean areInSameTrain(EntityMinecart cart1, EntityMinecart cart2) {
        if (cart1 == null || cart2 == null) {
            return false;
        }
        if (cart1 == cart2) {
            return true;
        }
        return this.getTrain(cart1) == this.getTrain(cart2);
    }

    @Override
    public boolean areLinked(EntityMinecart cart1, EntityMinecart cart2) {
        if (cart1 == null || cart2 == null) {
            return false;
        }
        if (cart1 == cart2) {
            return false;
        }
        boolean cart1Linked = false;
        UUID id1 = this.getLinkageId(cart1);
        UUID id2 = this.getLinkageId(cart2);
        if (id2.equals(this.getLinkA(cart1)) || id2.equals(this.getLinkB(cart1))) {
            cart1Linked = true;
        }
        boolean cart2Linked = false;
        if (id1.equals(this.getLinkA(cart2)) || id1.equals(this.getLinkB(cart2))) {
            cart2Linked = true;
        }
        return cart1Linked && cart2Linked;
    }

    @Override
    public void breakLink(EntityMinecart cart1, EntityMinecart cart2) {
        UUID link = this.getLinkageId(cart2);
        if (link.equals(this.getLinkA(cart1))) {
            this.breakLinkA(cart1);
        }
        if (link.equals(this.getLinkB(cart1))) {
            this.breakLinkB(cart1);
        }
    }

    @Override
    public void breakLinks(EntityMinecart cart) {
        this.breakLinkA(cart);
        this.breakLinkB(cart);
    }

    @Override
    public void breakLinkA(EntityMinecart cart) {
        this.resetTrain(cart);
        UUID link = this.getLinkA(cart);
        cart.getEntityData().func_74772_a(LINK_A_HIGH, 0L);
        cart.getEntityData().func_74772_a(LINK_A_LOW, 0L);
        EntityMinecart other = this.getCartFromLinkageId(link);
        if (other != null) {
            this.breakLink(other, cart);
        }
        if (cart instanceof ILinkableCart) {
            ((ILinkableCart)cart).onLinkBroken(other);
        }
        LinkageManager.printDebug("Carts {0}({1}) and {2}({3}) unlinked (A).", this.getLinkageId(cart), cart.func_70023_ak(), link, other != null ? other.func_70023_ak() : "null");
    }

    @Override
    public void breakLinkB(EntityMinecart cart) {
        this.resetTrain(cart);
        UUID link = this.getLinkB(cart);
        cart.getEntityData().func_74772_a(LINK_B_HIGH, 0L);
        cart.getEntityData().func_74772_a(LINK_B_LOW, 0L);
        EntityMinecart other = this.getCartFromLinkageId(link);
        if (other != null) {
            this.breakLink(other, cart);
        }
        if (cart instanceof ILinkableCart) {
            ((ILinkableCart)cart).onLinkBroken(other);
        }
        LinkageManager.printDebug("Carts {0}({1}) and {2}({3}) unlinked (B).", this.getLinkageId(cart), cart.func_70023_ak(), link, other != null ? other.func_70023_ak() : "null");
    }

    @Override
    public int countCartsInTrain(EntityMinecart cart) {
        Train train = this.getTrain(cart);
        return train.size();
    }
}

