/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.carts;

import java.util.List;
import java.util.Random;
import mods.railcraft.api.carts.CartTools;
import mods.railcraft.api.tracks.RailTools;
import mods.railcraft.common.blocks.RailcraftBlocks;
import mods.railcraft.common.blocks.tracks.TrackSpeed;
import mods.railcraft.common.carts.CartUtils;
import mods.railcraft.common.carts.EntityTunnelBore;
import mods.railcraft.common.carts.LinkageManager;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.MiscTools;
import mods.railcraft.common.util.misc.Vec2D;
import net.minecraft.block.BlockRail;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.IMinecartCollisionHandler;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.entity.minecart.MinecartCollisionEvent;
import net.minecraftforge.event.entity.minecart.MinecartInteractEvent;
import net.minecraftforge.event.entity.minecart.MinecartUpdateEvent;

public final class MinecartHooks
implements IMinecartCollisionHandler {
    protected static float DRAG_FACTOR_GROUND = 0.5f;
    protected static float DRAG_FACTOR_AIR = 0.99999f;
    protected static float OPTIMAL_DISTANCE = 1.28f;
    protected static float COEF_SPRING = 0.2f;
    protected static float COEF_SPRING_PLAYER = 0.5f;
    protected static float COEF_RESTITUTION = 0.2f;
    protected static float COEF_DAMPING = 0.4f;
    protected static float ENTITY_REDUCTION = 0.25f;
    protected static float CART_LENGTH = 1.22f;
    protected static float CART_WIDTH = 0.98f;
    protected static float COLLISION_EXPANSION = 0.2f;
    protected static int MAX_INTERACT_DIST_SQ = 25;
    private Random rand = new Random();
    private static MinecartHooks instance;

    private MinecartHooks() {
    }

    public static MinecartHooks getInstance() {
        if (instance == null) {
            instance = new MinecartHooks();
        }
        return instance;
    }

    public void onEntityCollision(EntityMinecart cart, Entity other) {
        int mountPrevention;
        if (Game.isNotHost(cart.field_70170_p) || other == cart.field_70153_n || other.field_70128_L || cart.field_70128_L) {
            return;
        }
        LinkageManager lm = LinkageManager.instance();
        EntityMinecart link = lm.getLinkedCartA(cart);
        if (link != null && (link == other || other == link.field_70153_n)) {
            return;
        }
        link = lm.getLinkedCartB(cart);
        if (link != null && (link == other || other == link.field_70153_n)) {
            return;
        }
        boolean isLiving = other instanceof EntityLivingBase;
        boolean isPlayer = other instanceof EntityPlayer;
        if (isLiving && !isPlayer && cart.canBeRidden() && !(other instanceof EntityIronGolem) && cart.field_70159_w * cart.field_70159_w + cart.field_70179_y * cart.field_70179_y > 0.001 && cart.field_70153_n == null && other.field_70154_o == null && (mountPrevention = cart.getEntityData().func_74762_e("MountPrevention")) <= 0) {
            other.func_70078_a((Entity)cart);
        }
        int i = MathHelper.func_76128_c((double)cart.field_70165_t);
        int j = MathHelper.func_76128_c((double)cart.field_70163_u);
        int k = MathHelper.func_76128_c((double)cart.field_70161_v);
        int id = cart.field_70170_p.func_72798_a(i, j, k);
        if (isLiving && RailcraftBlocks.getBlockElevator() != null && id == RailcraftBlocks.getBlockElevator().field_71990_ca) {
            return;
        }
        Vec2D cartPos = new Vec2D(cart.field_70165_t, cart.field_70161_v);
        Vec2D otherPos = new Vec2D(other.field_70165_t, other.field_70161_v);
        Vec2D unit = Vec2D.subtract(otherPos, cartPos);
        unit.normalize();
        double distance = cart.func_70032_d(other);
        double depth = distance - (double)OPTIMAL_DISTANCE;
        double forceX = 0.0;
        double forceZ = 0.0;
        if (depth < 0.0) {
            double spring = isPlayer ? (double)COEF_SPRING_PLAYER : (double)COEF_SPRING;
            double penaltyX = spring * depth * unit.getX();
            double penaltyZ = spring * depth * unit.getY();
            forceX += penaltyX;
            forceZ += penaltyZ;
            if (!isPlayer) {
                double impulseX = unit.getX();
                double impulseZ = unit.getY();
                impulseX *= -(1.0 + (double)COEF_RESTITUTION);
                impulseZ *= -(1.0 + (double)COEF_RESTITUTION);
                Vec2D cartVel = new Vec2D(cart.field_70159_w, cart.field_70179_y);
                Vec2D otherVel = new Vec2D(other.field_70159_w, other.field_70179_y);
                double dot = Vec2D.subtract(otherVel, cartVel).dotProduct(unit);
                impulseX *= dot;
                impulseZ *= dot;
                forceX -= (impulseX *= 0.5);
                forceZ -= (impulseZ *= 0.5);
            }
        }
        if (other instanceof EntityMinecart) {
            EntityMinecart otherCart = (EntityMinecart)other;
            if (!(cart.isPoweredCart() && !otherCart.isPoweredCart() || RailTools.isCartLockedDown(cart))) {
                cart.func_70024_g(forceX, 0.0, forceZ);
            }
            if (!(otherCart.isPoweredCart() && !cart.isPoweredCart() || RailTools.isCartLockedDown(otherCart))) {
                other.func_70024_g(-forceX, 0.0, -forceZ);
            }
        } else {
            Vec2D cartVel = new Vec2D(cart.field_70159_w + forceX, cart.field_70179_y + forceZ);
            Vec2D otherVel = new Vec2D(other.field_70159_w - forceX, other.field_70179_y - forceZ);
            double dot = Vec2D.subtract(otherVel, cartVel).dotProduct(unit);
            double dampX = (double)COEF_DAMPING * dot * unit.getX();
            double dampZ = (double)COEF_DAMPING * dot * unit.getY();
            forceX += dampX;
            forceZ += dampZ;
            if (!isPlayer) {
                other.func_70024_g(-forceX, 0.0, -forceZ);
            }
            if (!RailTools.isCartLockedDown(cart)) {
                cart.func_70024_g(forceX, 0.0, forceZ);
            }
        }
    }

    public AxisAlignedBB getCollisionBox(EntityMinecart cart, Entity other) {
        if (other instanceof EntityItem && RailcraftConfig.doCartsCollideWithItems()) {
            return other.field_70121_D;
        }
        if (other instanceof EntityPlayer) {
            return other.func_70104_M() ? other.field_70121_D : null;
        }
        return null;
    }

    public AxisAlignedBB getMinecartCollisionBox(EntityMinecart cart) {
        return this.getMinecartCollisionBox(cart, COLLISION_EXPANSION);
    }

    private AxisAlignedBB getMinecartCollisionBox(EntityMinecart cart, float expand) {
        double yaw = Math.toRadians(cart.field_70177_z);
        double diff = (double)(CART_LENGTH - CART_WIDTH) / 2.0 + (double)expand;
        double x = diff * Math.abs(Math.cos(yaw));
        double z = diff * Math.abs(Math.sin(yaw));
        return cart.field_70121_D.func_72314_b(x, (double)expand, z);
    }

    public AxisAlignedBB getBoundingBox(EntityMinecart cart) {
        if (cart == null || cart.field_70128_L) {
            return null;
        }
        if (RailcraftConfig.areCartsSolid()) {
            return cart.field_70121_D;
        }
        return null;
    }

    private void land(EntityMinecart cart) {
        cart.getEntityData().func_74768_a("Launched", 0);
        cart.setMaxSpeedAirLateral(EntityMinecart.defaultMaxSpeedAirLateral);
        cart.setMaxSpeedAirVertical(EntityMinecart.defaultMaxSpeedAirVertical);
        cart.setDragAir(EntityMinecart.defaultDragAir);
    }

    @ForgeSubscribe
    public void onMinecartUpdate(MinecartUpdateEvent event) {
        byte elevator;
        int mountPrevention;
        EntityMinecart cart = event.minecart;
        NBTTagCompound data = cart.getEntityData();
        int x = (int)event.x;
        int y = (int)event.y;
        int z = (int)event.z;
        int id = cart.field_70170_p.func_72798_a(x, y, z);
        int launched = data.func_74762_e("Launched");
        if (BlockRail.func_72184_d((int)id)) {
            cart.field_70143_R = 0.0f;
            if (cart.field_70153_n != null) {
                cart.field_70153_n.field_70143_R = 0.0f;
            }
            if (launched > 1) {
                this.land(cart);
            }
        } else if (launched == 1) {
            data.func_74768_a("Launched", 2);
            cart.setCanUseRail(true);
        } else if (launched > 1 && (cart.field_70122_E || cart.func_70055_a(Material.field_76265_p))) {
            this.land(cart);
        }
        if ((mountPrevention = data.func_74762_e("MountPrevention")) > 0) {
            data.func_74768_a("MountPrevention", --mountPrevention);
        }
        if ((elevator = data.func_74771_c("elevator")) > 0) {
            elevator = (byte)(elevator - 1);
            data.func_74774_a("elevator", elevator);
        }
        if (data.func_74767_n("explode")) {
            cart.getEntityData().func_74757_a("explode", false);
            CartUtils.explodeCart(cart);
        }
        if (data.func_74767_n("HighSpeed")) {
            if (CartUtils.cartVelocityIsLessThan(cart, 0.39f)) {
                data.func_74757_a("HighSpeed", false);
            } else if (!TrackSpeed.isTrackHighSpeedCapable(cart.field_70170_p, x, y, z)) {
                CartUtils.explodeCart(cart);
            }
        }
        cart.field_70159_w = Math.copySign(Math.min(Math.abs(cart.field_70159_w), 9.5), cart.field_70159_w);
        cart.field_70181_x = Math.copySign(Math.min(Math.abs(cart.field_70181_x), 9.5), cart.field_70181_x);
        cart.field_70179_y = Math.copySign(Math.min(Math.abs(cart.field_70179_y), 9.5), cart.field_70179_y);
    }

    @ForgeSubscribe
    public void onMinecartEntityCollision(MinecartCollisionEvent event) {
        List carts;
        EntityMinecart cart = event.minecart;
        Entity other = event.collider;
        if (other == cart.field_70153_n) {
            return;
        }
        this.testHighSpeedCollision(cart, other);
        int i = MathHelper.func_76128_c((double)cart.field_70165_t);
        int j = MathHelper.func_76128_c((double)cart.field_70163_u);
        int k = MathHelper.func_76128_c((double)cart.field_70161_v);
        if (EntityMinecart.getCollisionHandler() != this && other instanceof EntityLivingBase && RailcraftBlocks.getBlockElevator() != null && cart.field_70170_p.func_72798_a(i, j, k) == RailcraftBlocks.getBlockElevator().field_71990_ca && other.field_70121_D.field_72338_b < cart.field_70121_D.field_72337_e) {
            other.func_70091_d(0.0, cart.field_70121_D.field_72337_e - other.field_70121_D.field_72338_b, 0.0);
            other.field_70122_E = true;
        }
        if (MiscTools.getRand().nextFloat() < 0.001f && (carts = CartTools.getMinecartsAt(cart.field_70170_p, i, j, k, 0.0f)).size() >= 12) {
            this.primeToExplode(cart);
        }
    }

    private void testHighSpeedCollision(EntityMinecart cart, Entity other) {
        boolean highSpeed = cart.getEntityData().func_74767_n("HighSpeed");
        if (highSpeed) {
            LinkageManager lm = LinkageManager.instance();
            if (other instanceof EntityMinecart && lm.areLinked(cart, (EntityMinecart)other)) {
                return;
            }
            EntityMinecart link = lm.getLinkedCartA(cart);
            if (link != null && other == link.field_70153_n) {
                return;
            }
            link = lm.getLinkedCartB(cart);
            if (link != null && other == link.field_70153_n) {
                return;
            }
            if (other instanceof EntityMinecart) {
                boolean otherHighSpeed = other.getEntityData().func_74767_n("HighSpeed");
                if (!otherHighSpeed || cart.field_70159_w > 0.0 ^ other.field_70159_w > 0.0 || cart.field_70179_y > 0.0 ^ other.field_70179_y > 0.0) {
                    this.primeToExplode(cart);
                }
            } else {
                this.primeToExplode(cart);
            }
        }
    }

    private void primeToExplode(EntityMinecart cart) {
        cart.getEntityData().func_74757_a("explode", true);
    }

    @ForgeSubscribe
    public void onMinecartInteract(MinecartInteractEvent event) {
        EntityMinecart cart = event.minecart;
        EntityPlayer player = event.player;
        if (!CartTools.doesCartHaveOwner(cart)) {
            CartTools.setCartOwner(cart, player);
        }
        if (!(cart instanceof EntityTunnelBore) && player.func_70068_e((Entity)cart) > (double)MAX_INTERACT_DIST_SQ) {
            event.setCanceled(true);
            return;
        }
        if (cart.field_70128_L) {
            event.setCanceled(true);
            return;
        }
        if (cart.canBeRidden()) {
            if (cart.field_70153_n != null && player.field_70154_o != cart) {
                event.setCanceled(true);
                return;
            }
            if (player.field_70154_o != null && player.field_70154_o != cart) {
                event.setCanceled(true);
                return;
            }
            if (player.field_70154_o != cart && player.func_70617_f_()) {
                event.setCanceled(true);
                return;
            }
        }
        if (!player.func_70685_l((Entity)cart)) {
            event.setCanceled(true);
            return;
        }
    }
}

