/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.core;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import mods.railcraft.common.blocks.aesthetics.cube.EnumCube;
import mods.railcraft.common.blocks.aesthetics.lamp.EnumStoneLamp;
import mods.railcraft.common.blocks.aesthetics.slab.EnumSlab;
import mods.railcraft.common.blocks.aesthetics.stairs.EnumStair;
import mods.railcraft.common.blocks.aesthetics.wall.EnumWallAlpha;
import mods.railcraft.common.blocks.aesthetics.wall.EnumWallBeta;
import mods.railcraft.common.blocks.machine.alpha.EnumMachineAlpha;
import mods.railcraft.common.blocks.machine.beta.EnumMachineBeta;
import mods.railcraft.common.blocks.machine.delta.EnumMachineDelta;
import mods.railcraft.common.blocks.machine.gamma.EnumMachineGamma;
import mods.railcraft.common.blocks.ore.EnumOre;
import mods.railcraft.common.blocks.signals.EnumSignal;
import mods.railcraft.common.blocks.tracks.EnumTrack;
import mods.railcraft.common.carts.EntityTunnelBore;
import mods.railcraft.common.core.Railcraft;
import mods.railcraft.common.modules.ModuleManager;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.MiscTools;
import mods.railcraft.common.util.misc.RailcraftInstallationException;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.ConfigCategory;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.Property;

public class RailcraftConfig {
    private static final String COMMENT_PREFIX = "\n";
    private static final String COMMENT_SUFFIX = "\n";
    private static final String CAT_ANCHORS = "anchors";
    private static final String CAT_AURAS = "auras";
    private static final String CAT_LOOT = "loot";
    private static final String CAT_WORLD_GEN = "worldgen";
    private static final String CAT_FLUIDS = "fluids";
    private static final String CAT_RECIPES = "recipes";
    private static final String CAT_CARTS = "carts";
    private static final String CAT_SUBBLOCKS = "subblocks";
    private static final String CAT_TWEAKS = "tweaks";
    private static final String CAT_TWEAKS_CARTS = "tweaks.carts";
    private static final String CAT_TWEAKS_TRACKS = "tweaks.tracks";
    private static final String CAT_TWEAKS_BLOCKS = "tweaks.blocks";
    private static final String CAT_TWEAKS_ROUTING = "tweaks.routing";
    private static int nextItemId = 7500;
    private static boolean needsInit = true;
    private static Map itemIDs = new HashMap();
    private static Set newItemIDs = new TreeSet();
    private static Map blockIDs = new HashMap();
    private static Map carts = new HashMap();
    private static Map enabledSubBlocks = new HashMap();
    private static Map worldGen = new HashMap();
    private static Map fluids = new HashMap();
    private static Map recipes = new HashMap();
    private static final Map lootChances = new HashMap();
    private static float maxHighSpeed = 1.1f;
    private static boolean boreDestroysBlocks;
    private static boolean boreMinesAllBlocks;
    private static boolean locomotiveDamageMobs;
    private static boolean printSignalDebug;
    private static boolean printLinkingDebug;
    private static boolean deleteAnchors;
    private static boolean anchorCrafting;
    private static boolean anchorCraftingPersonal;
    private static boolean anchorsCanInteractWithPipes;
    private static boolean printAnchors;
    private static boolean minecartsBreakOnDrop;
    private static boolean adjustBasicCartDrag;
    private static boolean chestAllowLiquids;
    private static boolean minecartsCollideWithItems;
    private static boolean registerCollisionHandler;
    private static boolean cartsAreSolid;
    private static boolean playSounds;
    private static boolean doUpdateCheck;
    private static boolean routingOpsOnly;
    private static boolean machinesRequirePower;
    private static int minecartTankCapacity;
    private static int minecartTankFillRate;
    private static int launchRailMaxForce;
    private static int cartDispenserDelay;
    private static int minecartStackSize;
    private static int signalUpdateInterval;
    private static int maxTankSize;
    private static int anchorRefuel;
    private static int anchorRefuelPersonal;
    private static int anchorFuelItemID;
    private static int anchorFuelItemMeta;
    private static int steelCookTime;
    private static int locomotiveHorsepower;
    private static int creosoteTorchOutput;
    private static float boreMiningSpeedMultiplier;
    private static float biolerMultiplierFuel;
    private static float biolerMultiplierBiofuel;
    private static float fuelPerSteamMultiplier;
    private static boolean allowTankStacking;
    private static Configuration config;

    private static void checkInit() {
        if (needsInit) {
            Locale locale = Locale.getDefault();
            Locale.setDefault(Locale.ENGLISH);
            config = new Configuration(new File(Railcraft.getMod().getConfigFolder(), "railcraft.cfg"));
            config.load();
            doUpdateCheck = RailcraftConfig.get("check.version.online", true, "change to '{t}=false' to disable latest version checking");
            playSounds = RailcraftConfig.get("play.sounds", true, "change to '{t}=false' to prevent all mod sounds from playing");
            config.addCustomCategoryComment(CAT_TWEAKS, "Here you can change the behavior of various things");
            RailcraftConfig.loadAnchorSettings();
            RailcraftConfig.loadBlockTweaks();
            RailcraftConfig.loadTrackTweaks();
            RailcraftConfig.loadRoutingTweaks();
            RailcraftConfig.loadCartTweaks();
            RailcraftConfig.loadRecipeOption();
            RailcraftConfig.loadCarts();
            RailcraftConfig.loadBlocks();
            RailcraftConfig.loadItems();
            RailcraftConfig.loadBoreMineableBlocks();
            RailcraftConfig.loadLoot();
            RailcraftConfig.loadWorldGen();
            RailcraftConfig.loadFluids();
            if (config.hasChanged()) {
                config.save();
            }
            Locale.setDefault(locale);
        }
        needsInit = false;
    }

    private static void loadAnchorSettings() {
        deleteAnchors = RailcraftConfig.get(CAT_ANCHORS, "delete.anchors", false, true, "change to '{t}=true' to delete every World Anchor or Anchor Cart in the world.\nValue resets to false after each session.\nTo disable Anchors completely, disable the ChunkLoading Module from 'modules.cfg'");
        anchorRefuel = RailcraftConfig.get(CAT_ANCHORS, "refuel", -1, 12, 480, "the number of hours that a single Ender Pearl will power a World Anchor or Anchor Cart\nthis is an approximation only, actual duration is affected by number of chunks loaded and tick rate\nset it to -1 to disable the fuel requirement, default = 12, max = 480");
        anchorRefuelPersonal = RailcraftConfig.get(CAT_ANCHORS, "personal.refuel", -1, 12, 480, "the number of hours that a single Ender Pearl will power a Personal Anchor or Personal Anchor Cart\nthis is an approximation only, actual duration is affected by number of chunks loaded and tick rate\nset it to -1 to disable the fuel requirement, default = 12, max = 480");
        anchorCrafting = RailcraftConfig.get(CAT_ANCHORS, "craftable", true, "change to {t}=false to disable World Anchor crafting, they will still be available via Creative");
        anchorCraftingPersonal = RailcraftConfig.get(CAT_ANCHORS, "personal.craftable", true, "change to {t}=false to disable Personal Anchor crafting, they will still be available via Creative");
        printAnchors = RailcraftConfig.get(CAT_ANCHORS, "print.locations", true, "change to {t}=true to print Anchor locations to the log on startup");
        anchorFuelItemID = RailcraftConfig.get(CAT_ANCHORS, "fuel.itemID", 368, "this is the itemID of the item to be used as Anchor Fuel, defaults to Ender Pearls");
        anchorFuelItemMeta = RailcraftConfig.get(CAT_ANCHORS, "fuel.itemMeta", 0, "this is the itemID of the item to be used as Anchor Fuel, defaults to 0");
        anchorsCanInteractWithPipes = RailcraftConfig.get(CAT_ANCHORS, "interact.with.pipes", true, "change to {t}=false to prevent pipes, tubes, or various other things from interacting with Anchors");
    }

    private static void loadBlockTweaks() {
        cartDispenserDelay = RailcraftConfig.get("tweaks.blocks.cartdispenser", "delay", 0, 0, Integer.MAX_VALUE, "set the minimum number of seconds between cart dispensing, default=0");
        maxTankSize = RailcraftConfig.get("tweaks.blocks.irontank", "maxsize", 3, 9, 9, "Allows you to set the max Iron Tank base dimension, valid values are 3, 5, 7, and 9");
        allowTankStacking = RailcraftConfig.get("tweaks.blocks.irontank", "allow.stacking", true, "Change to '{t}=false' to disable the stacking of Iron Tanks");
        printSignalDebug = RailcraftConfig.get("tweaks.blocks.signals", "printDebug", false, "change to '{t}=true' to log debug info for Signal Blocks");
        signalUpdateInterval = RailcraftConfig.get("tweaks.blocks.signals", "update.interval", 4, "measured in tick, smaller numbers update more often, resulting in more sensitive signals, but cost more cpu power, default = 4");
        machinesRequirePower = RailcraftConfig.get("tweaks.blocks.machines", "requirePower", true, "change to '{t}=false' to disable the Power Requirements for most machines");
        biolerMultiplierFuel = RailcraftConfig.get("tweaks.blocks.boiler", "fuelMultiplier", 0.0f, 1.0f, 10.0f, "adjust the heat value of Fuel in a Boiler");
        biolerMultiplierBiofuel = RailcraftConfig.get("tweaks.blocks.boiler", "biofuelMultiplier", 0.0f, 1.0f, 10.0f, "adjust the heat value of BioFuel in a Boiler");
        fuelPerSteamMultiplier = RailcraftConfig.get("tweaks.steam", "fuelPerSteamMultiplier", 0.2f, 1.0f, 6.0f, "adjust the amount of fuel used to create Steam, min=0.2, default=1.0, max=6.0");
    }

    private static void loadTrackTweaks() {
        maxHighSpeed = RailcraftConfig.get("tweaks.tracks.speed", "max.speed", 0.6f, 0.8f, 1.2f, "change '{t}' to limit max speed on high speed rails, useful if your computer can't keep up with chunk loading, min=0.6, default=0.8, max=1.2");
        launchRailMaxForce = RailcraftConfig.get("tweaks.tracks.launch", "force.max", 5, 30, 50, "change the value to your desired max launch rail force, min=5, default=30, max=50");
    }

    private static void loadRoutingTweaks() {
        routingOpsOnly = RailcraftConfig.get(CAT_TWEAKS_ROUTING, "ops.only", false, "change to '{t}=true' to limit the editing of Golden Tickets to server admins only");
    }

    private static void loadCartTweaks() {
        registerCollisionHandler = RailcraftConfig.get("tweaks.carts.general", "register.collision.handler", true, "change to '{t}=false' to use a minecart collision handler from a different mod or vanilla behavior");
        cartsAreSolid = RailcraftConfig.get("tweaks.carts.general", "solid.carts", true, "change to '{t}=false' to return minecarts to vanilla player vs cart collision behavior\nin vanilla minecarts are ghost like can be walked through\nbut making carts solid also makes them hard to push by hand\nthis setting is ignored if aren't using the Railcraft Collision Handler");
        minecartStackSize = RailcraftConfig.get("tweaks.carts.general", "maxStackSize", 1, 3, 64, "change the value to your desired minecart stack size, vanilla=1, default=3, max=64");
        minecartsBreakOnDrop = RailcraftConfig.get("tweaks.carts.general", "breakOnDrop", false, "change to '{t}=true' to restore vanilla behavior");
        minecartsCollideWithItems = RailcraftConfig.get("tweaks.carts.general", "collideWithItems", false, "change to '{t}=true' to restore minecart collisions with dropped items, ignored if 'register.handler.collision=false'");
        printLinkingDebug = RailcraftConfig.get("tweaks.carts.general", "printLinkingDebug", false, "change to '{t}=true' to log debug info for Cart Linking");
        adjustBasicCartDrag = RailcraftConfig.get("tweaks.carts.basic", "adjustDrag", true, "change to '{t}=false' to give basic carts the original vanilla drag values, after changing you may need to replace the carts to see any change in game");
        chestAllowLiquids = RailcraftConfig.get("tweaks.carts.chest", "allowLiquids", false, "change to '{t}=true' to allow you put cans/capsules in Chest Carts");
        boreDestroysBlocks = RailcraftConfig.get("tweaks.carts.bore", "destroyBlocks", false, "change to '{t}=true' to cause the Bore to destroy the blocks it mines instead of dropping them");
        boreMinesAllBlocks = RailcraftConfig.get("tweaks.carts.bore", "mineAllBlocks", true, "change to '{t}=false' to enable mining checks, use true setting with caution, especially on servers");
        boreMiningSpeedMultiplier = RailcraftConfig.get("tweaks.carts.bore", "miningSpeed", 0.1f, 1.0f, 50.0f, "adjust the speed at which the Bore mines blocks, min=0.1, default=1.0, max=50.0");
        locomotiveDamageMobs = RailcraftConfig.get("tweaks.carts.locomotive", "damageMobs", true, "change to '{t}=false' to disable Locomotive damage on mobs, they will still knockback mobs");
        locomotiveHorsepower = RailcraftConfig.get("tweaks.carts.locomotive", "horsepower", 15, 15, 45, "controls how much power locomotives have and how many carts they can pull\nbe warned, longer trains have a greater chance for glitches\nas such it HIGHLY recommended you do not change this");
        boolean minecartTankCustomize = RailcraftConfig.get("tweaks.carts.tank", "useCustomValues", false, "change to '{t}=true' to adjust the Tank Cart's capacity and fill rate");
        int capacity = RailcraftConfig.get("tweaks.carts.tank", "capacity", 4, 32, 64, "change the value to your desired Tank Cart capacity in buckets, min=4, default=32, max=64, ignored if 'tweaks.minecarts.tank.useCustomValues=false'");
        if (minecartTankCustomize) {
            minecartTankCapacity = capacity;
        }
        int fillrate = RailcraftConfig.get("tweaks.carts.tank", "fillrate", 4, 32, 64, "change the value to your desired Tank Cart fill rate in milli-buckets per tick, min=4, default=32, max=64\nthere are 1000 milli-buckets in a bucket, ignored if 'tweaks.minecarts.tank.useCustomValues=false'");
        if (minecartTankCustomize) {
            minecartTankFillRate = fillrate;
        }
    }

    private static void loadRecipeOption() {
        config.addCustomCategoryComment(CAT_RECIPES, "You can add or remove various recipes here");
        ConfigCategory cat = config.getCategory(CAT_RECIPES);
        Iterator keys = cat.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            if (!key.startsWith("recipe")) continue;
            keys.remove();
        }
        RailcraftConfig.loadRecipeProperty("minecraft.furnace", "creosote", false, "change to '{t}=true' to add smelting recipes for Creosote Oil to the vanilla furnace");
        RailcraftConfig.loadRecipeProperty("railcraft.track", "useAltRecipes", false, "change to '{t}=true' to use track recipes more similar to vanilla minecraft");
        RailcraftConfig.loadRecipeProperty("railcraft.rockCrusher", "ores", true, "change to '{t}=false' to prevent the game from crushing ores into dusts (only available if IC2 installed)");
        RailcraftConfig.loadRecipeProperty("railcraft.misc", "gunpowder", true, "change to '{t}=false' to disable the sulfur, saltpeter, charcoal dust recipe for gunpowder");
        creosoteTorchOutput = RailcraftConfig.get("recipes.railcraft.misc", "creosote.torches", 0, 6, 16, "set the output of the creosote and woool recipe for torches, setting to 0 will disable'\nmin=0, default=6, max=16");
        RailcraftConfig.loadRecipeProperty("railcraft.cart", "bronze", true, "change to '{t}=false' to disable the bronze recipe for minecarts");
        RailcraftConfig.loadRecipeProperty("railcraft.cart", "steel", true, "change to '{t}=false' to disable the steel recipe for minecarts");
        RailcraftConfig.loadRecipeProperty("railcraft.cart", "furnace", false, "change to '{t}=true' to enable the Furnace Minecart recipe");
        RailcraftConfig.loadRecipeProperty("ic2.macerator", "obsidian", false, "change to '{t}=false' to disable the IC2 Macerator recipes for Cushed Obsidian and Obsidian Dust");
        RailcraftConfig.loadRecipeProperty("ic2.macerator", "charcoal", true, "change to '{t}=false' to disable the IC2 Macerator recipe for Charcoal Dust");
        RailcraftConfig.loadRecipeProperty("ic2.macerator", "ores", true, "change to '{t}=false' to disable the IC2 Macerator recipes for Ore Dusts");
        RailcraftConfig.loadRecipeProperty("ic2.macerator", "bones", true, "change to '{t}=false' to disable the IC2 Macerator recipe for Bonemeal");
        RailcraftConfig.loadRecipeProperty("ic2.macerator", "blaze", true, "change to '{t}=false' to disable the IC2 Macerator recipe for Blaze Powder");
        RailcraftConfig.loadRecipeProperty("ic2.macerator", "cobble", true, "change to '{t}=false' to disable the IC2 Macerator recipes for Cobblestone");
        RailcraftConfig.loadRecipeProperty("ic2.macerator", "dirt", true, "change to '{t}=false' to disable the IC2 Macerator recipe for Dirt");
        RailcraftConfig.loadRecipeProperty("ic2.refinedIron", "useSteel", false, "change to '{t}=true' to enable the use of Steel in any IC2 recipe that requires Refined Iron");
        RailcraftConfig.loadRecipeProperty("ic2.refinedIron", "disable", false, "change to '{t}=true' to prevent Refined Iron from being used in any IC2 recipe. Use in combination with 'useSteel'");
        steelCookTime = RailcraftConfig.get("recipes.ic2.refinedIron", "steelCookTime", 320, 1280, 5120, "change to adjust the time in ticks it takes to make Steel. Ignored if other two options are false'\nmin=320, default=1280, max=5120");
        RailcraftConfig.loadRecipeProperty("forestry.misc", "fertilizer", true, "change to '{t}=false' to disable the saltpeter recipe for Forestry Fertilizer");
        RailcraftConfig.loadRecipeProperty("forestry.carpenter", "ties", true, "change to '{t}=false' to disable the Carptenter Tie recipe");
        RailcraftConfig.loadRecipeProperty("forestry.carpenter", "torches", true, "change to '{t}=false' to disable the Carptenter Creosote Torch recipe");
        RailcraftConfig.loadRecipeProperty("forestry.carpenter", "creosote.block", true, "change to '{t}=false' to disable the Carptenter Creosote Block recipe");
    }

    private static void loadWorldGen() {
        config.addCustomCategoryComment("worldgen.generate", "You can control which Ores/Features generate in the world here.\nIf wish to disable world gen entirely it is recommended\nthat you disable the World Module in 'modules.cfg' instead.");
        worldGen.put("sulfur", RailcraftConfig.get(config, "worldgen.generate", "sulfur", true));
        worldGen.put("saltpeter", RailcraftConfig.get(config, "worldgen.generate", "saltpeter", true));
        worldGen.put("firestone", RailcraftConfig.get(config, "worldgen.generate", "firestone", true));
        worldGen.put("abyssal", RailcraftConfig.get(config, "worldgen.generate", "abyssal", true));
        worldGen.put("quarried", RailcraftConfig.get(config, "worldgen.generate", "quarried", true));
    }

    private static void loadFluids() {
        config.addCustomCategoryComment(CAT_FLUIDS, "You can control whether Railcraft defines specific Fluids here.\nHowever, be aware that if you disable a Fluid that is not defined by another mod,you may suffer errors and unexpected behaivor.");
        fluids.put("steam", RailcraftConfig.get(config, CAT_FLUIDS, "steam", true));
        fluids.put("creosote", RailcraftConfig.get(config, CAT_FLUIDS, "creosote", true));
    }

    private static void loadLoot() {
        config.addCustomCategoryComment(CAT_LOOT, "Loot chances are defined here.\nSmaller values are rarer.\nExample Loot:\n   Bread = 100\n   Redstone = 50\n   Record = 5\n   Golden Apple = 1");
        RailcraftConfig.loadLootProperty("tie.wood", 20);
        RailcraftConfig.loadLootProperty("cart.basic", 10);
        RailcraftConfig.loadLootProperty("cart.chest", 10);
        RailcraftConfig.loadLootProperty("cart.tnt", 5);
        RailcraftConfig.loadLootProperty("cart.tnt.wood", 5);
        RailcraftConfig.loadLootProperty("cart.work", 8);
        RailcraftConfig.loadLootProperty("fuel.coke", 20);
        RailcraftConfig.loadLootProperty("creosote.bottle", 20);
        RailcraftConfig.loadLootProperty("track.basic", 30);
        RailcraftConfig.loadLootProperty("steel.ingot", 10);
        RailcraftConfig.loadLootProperty("steel.block", 5);
        RailcraftConfig.loadLootProperty("tool.crowbar", 10);
        RailcraftConfig.loadLootProperty("tool.steel.shears", 5);
        RailcraftConfig.loadLootProperty("tool.steel.sword", 5);
        RailcraftConfig.loadLootProperty("tool.steel.shovel", 5);
        RailcraftConfig.loadLootProperty("tool.steel.pickaxe", 5);
        RailcraftConfig.loadLootProperty("tool.steel.axe", 5);
        RailcraftConfig.loadLootProperty("armor.steel.helmet", 5);
        RailcraftConfig.loadLootProperty("armor.steel.plate", 5);
        RailcraftConfig.loadLootProperty("armor.steel.legs", 5);
        RailcraftConfig.loadLootProperty("armor.steel.boots", 5);
    }

    private static void loadCarts() {
        config.addCustomCategoryComment(CAT_CARTS, "Disable individual carts here.");
        RailcraftConfig.loadCartProperty("cart.tnt");
        RailcraftConfig.loadCartProperty("cart.tnt.wood");
        RailcraftConfig.loadCartProperty("cart.pumpkin");
        RailcraftConfig.loadCartProperty("cart.gift");
        RailcraftConfig.loadCartProperty("cart.tank");
        RailcraftConfig.loadCartProperty("cart.bore");
        RailcraftConfig.loadCartProperty("cart.energy.batbox");
        RailcraftConfig.loadCartProperty("cart.energy.mfe");
        RailcraftConfig.loadCartProperty("cart.energy.cesu");
        RailcraftConfig.loadCartProperty("cart.energy.mfsu");
        RailcraftConfig.loadCartProperty("cart.anchor");
        RailcraftConfig.loadCartProperty("cart.anchor.personal");
        RailcraftConfig.loadCartProperty("cart.anchor.admin");
        RailcraftConfig.loadCartProperty("cart.work");
        RailcraftConfig.loadCartProperty("cart.track.relayer");
        RailcraftConfig.loadCartProperty("cart.undercutter");
        RailcraftConfig.loadCartProperty("cart.loco.steam");
    }

    private static void loadBlocks() {
        config.addCustomCategoryComment("block", "This is were block IDs are defined.\nChanging these will have adverse effects on existing worlds.\nFor the list of which sub-blocks are on each ID see the sub-block section below.");
        RailcraftConfig.loadBlockProperty("block.detector", 450);
        RailcraftConfig.loadBlockProperty("block.machine.alpha", 451);
        RailcraftConfig.loadBlockProperty("block.machine.beta", 452);
        RailcraftConfig.loadBlockProperty("block.machine.gamma", 453);
        RailcraftConfig.loadBlockProperty("block.machine.delta", 476);
        RailcraftConfig.loadBlockProperty("block.track", 454);
        RailcraftConfig.loadBlockProperty("block.elevator", 455);
        RailcraftConfig.loadBlockProperty("block.signal", 456);
        RailcraftConfig.loadBlockProperty("block.cube", 457);
        RailcraftConfig.loadBlockProperty("block.ore", 458);
        RailcraftConfig.loadBlockProperty("block.post", 459);
        RailcraftConfig.loadBlockProperty("block.post.metal", 460);
        RailcraftConfig.loadBlockProperty("block.post.metal.platform", 480);
        RailcraftConfig.changeBlockProperty("block.wall", "block.wall.alpha", 461);
        RailcraftConfig.loadBlockProperty("block.worldlogic", 462);
        RailcraftConfig.loadBlockProperty("block.wall.beta", 463);
        RailcraftConfig.loadBlockProperty("block.stair", 464);
        RailcraftConfig.loadBlockProperty("block.slab", 465);
        RailcraftConfig.loadBlockProperty("block.brick.abyssal", 466);
        RailcraftConfig.loadBlockProperty("block.brick.infernal", 467);
        RailcraftConfig.loadBlockProperty("block.brick.bloodstained", 468);
        RailcraftConfig.loadBlockProperty("block.brick.sandy", 469);
        RailcraftConfig.loadBlockProperty("block.brick.bleachedbone", 470);
        RailcraftConfig.loadBlockProperty("block.brick.quarried", 471);
        RailcraftConfig.loadBlockProperty("block.brick.frostbound", 472);
        RailcraftConfig.loadBlockProperty("block.brick.nether", 475);
        RailcraftConfig.loadBlockProperty("block.hidden", 473);
        RailcraftConfig.loadBlockProperty("block.glass", 474);
        RailcraftConfig.loadBlockProperty("block.firestone.recharge", 477);
        RailcraftConfig.loadBlockProperty("block.anvil", 478);
        RailcraftConfig.loadBlockProperty("block.stonelamp", 479);
        RailcraftConfig.loadBlockProperty("block.fluid.creosote", 490);
        RailcraftConfig.loadBlockProperty("block.fluid.steam", 491);
        config.addCustomCategoryComment(CAT_SUBBLOCKS, "Here is were you can enable/disable various sub-blocks.\nRailcraft will attemtpt to compensate for any missing component by providing alternatives (usually).");
        for (EnumTrack enumTrack : EnumTrack.VALUES) {
            if (enumTrack.isDepreciated()) continue;
            RailcraftConfig.loadBlockFeature(enumTrack.getTag());
        }
        for (Enum enum_ : EnumCube.VALUES) {
            RailcraftConfig.loadBlockFeature(((EnumCube)enum_).getTag());
        }
        for (Enum enum_ : EnumWallAlpha.VALUES) {
            RailcraftConfig.loadBlockFeature(((EnumWallAlpha)enum_).getTag());
        }
        for (Enum enum_ : EnumWallBeta.VALUES) {
            RailcraftConfig.loadBlockFeature(((EnumWallBeta)enum_).getTag());
        }
        for (Enum enum_ : EnumStair.VALUES) {
            RailcraftConfig.loadBlockFeature(((EnumStair)enum_).getTag());
        }
        for (Enum enum_ : EnumSlab.VALUES) {
            RailcraftConfig.loadBlockFeature(((EnumSlab)enum_).getTag());
        }
        for (Enum enum_ : EnumStoneLamp.VALUES) {
            RailcraftConfig.loadBlockFeature(((EnumStoneLamp)enum_).getTag());
        }
        for (Enum enum_ : EnumOre.values()) {
            RailcraftConfig.loadBlockFeature(((EnumOre)enum_).getTag());
        }
        for (Enum enum_ : EnumMachineAlpha.values()) {
            RailcraftConfig.loadBlockFeature(((EnumMachineAlpha)enum_).getTag());
        }
        for (Enum enum_ : EnumMachineBeta.values()) {
            RailcraftConfig.loadBlockFeature(((EnumMachineBeta)enum_).getTag());
        }
        for (Enum enum_ : EnumMachineGamma.values()) {
            RailcraftConfig.loadBlockFeature(((EnumMachineGamma)enum_).getTag());
        }
        for (Enum enum_ : EnumMachineDelta.values()) {
            RailcraftConfig.loadBlockFeature(((EnumMachineDelta)enum_).getTag());
        }
        for (Enum enum_ : EnumSignal.values()) {
            if (((EnumSignal)enum_).getModule() == null) continue;
            RailcraftConfig.loadBlockFeature(((EnumSignal)enum_).getTag());
        }
    }

    private static void loadBlockFeature(String tag) {
        tag = MiscTools.cleanTag(tag);
        Property prop = config.get(CAT_SUBBLOCKS, tag, true);
        enabledSubBlocks.put(tag, prop.getBoolean(true));
    }

    private static void loadItems() {
        config.addCustomCategoryComment("item", "Generally, many items can be disabled by setting the id to zero.\nThis is not true for all item, so some experimentation may be needed.\nSome disabled items will cause a substitute to be used in crafting recipes.");
        RailcraftConfig.loadItemProperty("tool.crowbar");
        RailcraftConfig.loadItemProperty("tool.crowbar.reinforced");
        RailcraftConfig.loadItemProperty("tool.crowbar.magic");
        RailcraftConfig.loadItemProperty("tool.magnifying.glass");
        RailcraftConfig.loadItemProperty("tool.surveyor");
        RailcraftConfig.loadItemProperty("tool.signal.tuner");
        RailcraftConfig.loadItemProperty("tool.whistle.tuner");
        RailcraftConfig.loadItemProperty("backpack.trackman.t1");
        RailcraftConfig.loadItemProperty("backpack.trackman.t2");
        RailcraftConfig.loadItemProperty("backpack.iceman.t1");
        RailcraftConfig.loadItemProperty("backpack.iceman.t2");
        RailcraftConfig.loadItemProperty("fluid.steam.bottle");
        RailcraftConfig.changeItemProperty("liquid.creosote.bottle", "fluid.creosote.cell");
        RailcraftConfig.changeItemProperty("liquid.creosote.bottle", "fluid.creosote.bottle");
        RailcraftConfig.changeItemProperty("liquid.creosote.can", "fluid.creosote.can");
        RailcraftConfig.changeItemProperty("liquid.creosote.wax", "fluid.creosote.wax");
        RailcraftConfig.changeItemProperty("liquid.creosote.refactory", "fluid.creosote.refactory");
        RailcraftConfig.changeItemProperty("liquid.creosote.bucket", "fluid.creosote.bucket");
        RailcraftConfig.loadItemProperty("part.signal.lamp");
        RailcraftConfig.loadItemProperty("part.circuit");
        RailcraftConfig.changeItemProperty("item.coke", "fuel.coke");
        RailcraftConfig.loadItemProperty("firestone.cut");
        RailcraftConfig.loadItemProperty("firestone.raw");
        RailcraftConfig.loadItemProperty("firestone.refined");
        RailcraftConfig.loadItemProperty("firestone.cracked");
        RailcraftConfig.loadItemProperty("part.rebar");
        RailcraftConfig.loadItemProperty("part.rail");
        RailcraftConfig.loadItemProperty("part.plate");
        RailcraftConfig.loadItemProperty("part.gear");
        RailcraftConfig.loadItemProperty("part.tie");
        RailcraftConfig.loadItemProperty("part.railbed");
        RailcraftConfig.loadItemProperty("part.turbine.blade");
        RailcraftConfig.loadItemProperty("part.turbine.disk");
        RailcraftConfig.loadItemProperty("part.turbine.rotor");
        RailcraftConfig.loadItemProperty("tool.steel.shears");
        RailcraftConfig.loadItemProperty("tool.steel.sword");
        RailcraftConfig.loadItemProperty("tool.steel.shovel");
        RailcraftConfig.loadItemProperty("tool.steel.pickaxe");
        RailcraftConfig.loadItemProperty("tool.steel.axe");
        RailcraftConfig.loadItemProperty("tool.steel.hoe");
        RailcraftConfig.loadItemProperty("armor.goggles");
        RailcraftConfig.loadItemProperty("armor.overalls");
        RailcraftConfig.loadItemProperty("armor.steel.helmet");
        RailcraftConfig.loadItemProperty("armor.steel.plate");
        RailcraftConfig.loadItemProperty("armor.steel.legs");
        RailcraftConfig.loadItemProperty("armor.steel.boots");
        RailcraftConfig.changeItemProperty("part.ingot.steel", "ingot");
        RailcraftConfig.loadItemProperty("dust");
        RailcraftConfig.loadItemProperty("nugget");
        RailcraftConfig.loadItemProperty("routing.table");
        RailcraftConfig.loadItemProperty("routing.ticket.gold");
        RailcraftConfig.loadItemProperty("routing.ticket");
        RailcraftConfig.changeItemProperty("item.ic2.upgrade.lapotron", "ic2.upgrade.lapotron");
        RailcraftConfig.loadItemProperty("tool.bore.head.diamond");
        RailcraftConfig.loadItemProperty("tool.bore.head.iron");
        RailcraftConfig.loadItemProperty("tool.bore.head.steel");
        RailcraftConfig.changeItemProperty("item.cart.tnt", "cart.tnt");
        RailcraftConfig.loadItemProperty("cart.tnt.wood");
        RailcraftConfig.changeItemProperty("item.cart.pumpkin", "cart.pumpkin");
        RailcraftConfig.changeItemProperty("item.cart.gift", "cart.gift");
        RailcraftConfig.changeItemProperty("item.cart.tank", "cart.tank");
        RailcraftConfig.changeItemProperty("item.cart.bore", "cart.bore");
        RailcraftConfig.loadItemProperty("cart.energy.batbox");
        RailcraftConfig.loadItemProperty("cart.energy.cesu");
        RailcraftConfig.loadItemProperty("cart.energy.mfe");
        RailcraftConfig.loadItemProperty("cart.energy.mfsu");
        RailcraftConfig.changeItemProperty("item.cart.anchor", "cart.anchor");
        RailcraftConfig.changeItemProperty("item.cart.anchor.personal", "cart.anchor.personal");
        RailcraftConfig.changeItemProperty("item.cart.anchor.admin", "cart.anchor.admin");
        RailcraftConfig.changeItemProperty("item.cart.work", "cart.work");
        RailcraftConfig.changeItemProperty("item.cart.track.relayer", "cart.track.relayer");
        RailcraftConfig.changeItemProperty("item.cart.undercutter", "cart.undercutter");
        RailcraftConfig.changeItemProperty("item.cart.loco.steam", "cart.loco.steam");
        RailcraftConfig.loadItemProperty("emblem");
        RailcraftConfig.loadNewItems();
    }

    public static void loadBoreMineableBlocks() {
        String tag = "mineableBlocks";
        Property prop = RailcraftConfig.get("tweaks.carts.bore", tag, "{}", "add block ids to '{t}' in a common seperated list to define non-vanilla blocks mineable by the tunnel bore \nignored if 'tweaks.carts.bore.mineAllBlocks=true' \nmetadata sensative entries can be defined in the form 'blockid:metadata' \ninclusive ranges can be defined in the form 'startID-endID' \nExample:{t}= { 123, 134:3, 450-500 }");
        try {
            for (String segment : prop.getString().replaceAll("[{} ]", "").split(",")) {
                if (segment.equals("")) continue;
                if (segment.contains("-")) {
                    String[] sequence = segment.split("-");
                    int start = Integer.valueOf(sequence[0]);
                    int end = Integer.valueOf(sequence[1]);
                    Game.log(Level.FINEST, "Tunnel Bore: Adding block range to mineable list: {0}-{1}", start, end);
                    for (int block = start; block <= end; ++block) {
                        EntityTunnelBore.addMineableBlock(block);
                    }
                    continue;
                }
                String[] entry = segment.split(":");
                int block = Integer.valueOf(entry[0]);
                if (block <= 0 || block >= Block.field_71973_m.length) {
                    throw new Exception("Invalid Block ID = " + block);
                }
                int meta = entry.length > 1 ? Integer.valueOf(entry[1]) : -1;
                Game.log(Level.FINEST, "Tunnel Bore: Adding block to mineable list: {0}:{1}", block, meta);
                EntityTunnelBore.addMineableBlock(block, meta);
            }
        }
        catch (Exception ex) {
            Game.log(Level.SEVERE, "Error in railcraft.cfg with {0}", tag);
            throw new RailcraftInstallationException("Railcraft: Configuration Error!\n************************************************************************************\n In railcraft.cfg there was an error with " + tag + "." + "\n " + ex.getMessage() + "\n************************************************************************************" + "\n");
        }
    }

    public static boolean getRecipeConfig(String tag) {
        RailcraftConfig.checkInit();
        Boolean recipe = (Boolean)recipes.get(tag);
        if (recipe == null) {
            throw new RuntimeException("Railcraft Recipe Config Entry does not exist: " + tag);
        }
        return recipe;
    }

    public static boolean useOldRecipes() {
        return RailcraftConfig.getRecipeConfig("railcraft.track.useAltRecipes");
    }

    public static boolean canCrushOres() {
        return RailcraftConfig.getRecipeConfig("railcraft.rockCrusher.ores");
    }

    public static boolean addObsidianRecipesToMacerator() {
        return RailcraftConfig.getRecipeConfig("ic2.macerator.obsidian");
    }

    public static boolean useCreosoteFurnaceRecipes() {
        return RailcraftConfig.getRecipeConfig("minecraft.furnace.creosote");
    }

    public static int getSteelCookTime() {
        RailcraftConfig.checkInit();
        return steelCookTime;
    }

    public static int creosoteTorchOutput() {
        RailcraftConfig.checkInit();
        return creosoteTorchOutput;
    }

    public static boolean doUpdateCheck() {
        RailcraftConfig.checkInit();
        return doUpdateCheck;
    }

    public static boolean isRoutingOpsOnly() {
        RailcraftConfig.checkInit();
        return routingOpsOnly;
    }

    public static boolean boreDestroysBlocks() {
        RailcraftConfig.checkInit();
        return boreDestroysBlocks;
    }

    public static boolean boreMinesAllBlocks() {
        RailcraftConfig.checkInit();
        return boreMinesAllBlocks;
    }

    public static float boreMiningSpeedMultiplier() {
        RailcraftConfig.checkInit();
        return boreMiningSpeedMultiplier;
    }

    public static boolean locomotiveDamageMobs() {
        RailcraftConfig.checkInit();
        return locomotiveDamageMobs;
    }

    public static int locomotiveHorsepower() {
        RailcraftConfig.checkInit();
        return locomotiveHorsepower;
    }

    public static boolean printSignalDebug() {
        RailcraftConfig.checkInit();
        return printSignalDebug;
    }

    public static boolean printLinkingDebug() {
        RailcraftConfig.checkInit();
        return printLinkingDebug;
    }

    public static boolean anchorsCanInteractWithPipes() {
        RailcraftConfig.checkInit();
        return anchorsCanInteractWithPipes;
    }

    public static int anchorRefuel() {
        RailcraftConfig.checkInit();
        return anchorRefuel;
    }

    public static int anchorRefuelPersonal() {
        RailcraftConfig.checkInit();
        return anchorRefuelPersonal;
    }

    public static boolean isAnchorFuel(ItemStack stack) {
        RailcraftConfig.checkInit();
        if (stack == null) {
            return false;
        }
        if (stack.field_77993_c != anchorFuelItemID) {
            return false;
        }
        if (anchorFuelItemMeta == -1) {
            return true;
        }
        return anchorFuelItemMeta == stack.func_77960_j();
    }

    public static ItemStack getAnchorFuel() {
        RailcraftConfig.checkInit();
        return new ItemStack(anchorFuelItemID, 1, anchorFuelItemMeta == -1 ? Short.MAX_VALUE : anchorFuelItemMeta);
    }

    public static boolean deleteAnchors() {
        RailcraftConfig.checkInit();
        return deleteAnchors || !ModuleManager.isModuleLoaded(ModuleManager.Module.CHUNK_LOADING);
    }

    public static boolean canCraftAnchors() {
        RailcraftConfig.checkInit();
        return anchorCrafting;
    }

    public static boolean canCraftPersonalAnchors() {
        RailcraftConfig.checkInit();
        return anchorCraftingPersonal;
    }

    public static boolean printAnchorLocations() {
        RailcraftConfig.checkInit();
        return printAnchors;
    }

    public static boolean doCartsBreakOnDrop() {
        RailcraftConfig.checkInit();
        return minecartsBreakOnDrop;
    }

    public static boolean adjustBasicCartDrag() {
        RailcraftConfig.checkInit();
        return adjustBasicCartDrag;
    }

    public static boolean chestAllowLiquids() {
        RailcraftConfig.checkInit();
        return chestAllowLiquids;
    }

    public static boolean doCartsCollideWithItems() {
        RailcraftConfig.checkInit();
        return minecartsCollideWithItems;
    }

    public static boolean useCollisionHandler() {
        RailcraftConfig.checkInit();
        return registerCollisionHandler;
    }

    public static boolean areCartsSolid() {
        return cartsAreSolid;
    }

    public static boolean playSounds() {
        RailcraftConfig.checkInit();
        return playSounds;
    }

    public static float getMaxHighSpeed() {
        RailcraftConfig.checkInit();
        return maxHighSpeed;
    }

    public static int getMinecartStackSize() {
        RailcraftConfig.checkInit();
        return minecartStackSize;
    }

    public static int getLaunchRailMaxForce() {
        RailcraftConfig.checkInit();
        return launchRailMaxForce;
    }

    public static int getCartDispenserMinDelay() {
        RailcraftConfig.checkInit();
        return cartDispenserDelay;
    }

    public static int getTankCartFillRate() {
        RailcraftConfig.checkInit();
        return minecartTankFillRate;
    }

    public static int getTankCartCapacity() {
        RailcraftConfig.checkInit();
        return minecartTankCapacity * 1000;
    }

    public static int getMaxTankSize() {
        RailcraftConfig.checkInit();
        return maxTankSize;
    }

    public static boolean allowTankStacking() {
        RailcraftConfig.checkInit();
        return allowTankStacking;
    }

    public static boolean machinesRequirePower() {
        RailcraftConfig.checkInit();
        return machinesRequirePower;
    }

    public static float boilerFuelMultiplier() {
        RailcraftConfig.checkInit();
        return biolerMultiplierFuel;
    }

    public static float boilerBiofuelMultiplier() {
        RailcraftConfig.checkInit();
        return biolerMultiplierBiofuel;
    }

    public static float fuelPerSteamMultiplier() {
        RailcraftConfig.checkInit();
        return fuelPerSteamMultiplier;
    }

    public static int getSignalUpdateInterval() {
        RailcraftConfig.checkInit();
        return signalUpdateInterval;
    }

    private static void changeItemProperty(String oldTag, String newTag) {
        ConfigCategory items = config.getCategory("item");
        Property prop = (Property)items.remove(oldTag);
        if (prop != null) {
            prop.setName(newTag);
            items.put(newTag, prop);
        }
        RailcraftConfig.loadItemProperty(newTag);
    }

    private static void loadItemProperty(String tag) {
        tag = MiscTools.cleanTag(tag);
        ConfigCategory items = config.getCategory("item");
        Property prop = (Property)items.get(tag);
        if (prop == null) {
            newItemIDs.add(tag);
            return;
        }
        itemIDs.put(tag, prop.getInt());
    }

    private static void loadNewItems() {
        for (String tag : newItemIDs) {
            while (Item.field_77698_e[nextItemId + Item.field_77695_f.field_77779_bT] != null || itemIDs.values().contains(nextItemId)) {
                ++nextItemId;
            }
            Property prop = config.getItem(tag, nextItemId);
            itemIDs.put(tag, prop.getInt());
            ++nextItemId;
        }
    }

    private static void loadBlockProperty(String tag, int defaultValue) {
        Property prop = config.getBlock(tag, defaultValue);
        blockIDs.put(tag, prop.getInt());
    }

    private static void changeBlockProperty(String oldTag, String newTag, int defaultValue) {
        ConfigCategory items = config.getCategory("block");
        Property prop = (Property)items.remove(oldTag);
        if (prop != null) {
            prop.setName(newTag);
            items.put(newTag, prop);
        }
        RailcraftConfig.loadBlockProperty(newTag, defaultValue);
    }

    public static int getItemId(String tag) {
        RailcraftConfig.checkInit();
        tag = MiscTools.cleanTag(tag);
        Integer id = (Integer)itemIDs.get(tag);
        if (id == null) {
            throw new IllegalArgumentException("RailcraftConfig: item tag not found: " + tag);
        }
        return id;
    }

    public static int getBlockId(String tag) {
        RailcraftConfig.checkInit();
        tag = MiscTools.cleanTag(tag);
        Integer id = (Integer)blockIDs.get(tag);
        if (id == null) {
            return 0;
        }
        return id;
    }

    public static boolean isSubBlockEnabled(String tag) {
        RailcraftConfig.checkInit();
        tag = MiscTools.cleanTag(tag);
        Boolean b = (Boolean)enabledSubBlocks.get(tag);
        if (b == null) {
            return false;
        }
        return b;
    }

    public static boolean isCartEnabled(String tag) {
        RailcraftConfig.checkInit();
        tag = MiscTools.cleanTag(tag);
        Boolean enabled = (Boolean)carts.get(tag);
        if (enabled == null) {
            return false;
        }
        return enabled;
    }

    public static int getLootChance(String tag) {
        RailcraftConfig.checkInit();
        tag = MiscTools.cleanTag(tag);
        Integer chance = (Integer)lootChances.get(tag);
        if (chance == null) {
            throw new RuntimeException("Railcraft Loot Chance Entry does not exist: " + tag);
        }
        return chance;
    }

    public static boolean isWorldGenEnabled(String tag) {
        RailcraftConfig.checkInit();
        tag = MiscTools.cleanTag(tag);
        Boolean gen = (Boolean)worldGen.get(tag);
        if (gen == null) {
            throw new RuntimeException("Railcraft World Gen Entry does not exist: " + tag);
        }
        return gen;
    }

    public static boolean isFluidEnabled(String tag) {
        RailcraftConfig.checkInit();
        tag = MiscTools.cleanTag(tag);
        Boolean gen = (Boolean)fluids.get(tag);
        if (gen == null) {
            throw new RuntimeException("Railcraft Fluid Entry does not exist: " + tag);
        }
        return gen;
    }

    private static List getIntegerList(String cat, String tag, int maxEntries) {
        Property prop = config.get(cat, tag, "");
        String value = prop.getString();
        if (value.equals("")) {
            return Collections.EMPTY_LIST;
        }
        String[] tokens = value.split(",");
        ArrayList<Integer> list = new ArrayList<Integer>(maxEntries);
        int count = 0;
        for (String token : tokens) {
            list.add(Integer.valueOf(token));
            if (++count >= maxEntries) break;
        }
        return list;
    }

    private static boolean get(String tag, boolean defaultValue, String comment) {
        return RailcraftConfig.get("general", tag, defaultValue, comment);
    }

    private static void loadRecipeProperty(String subcat, String tag, boolean defaultValue, String comment) {
        comment = "\n" + comment.replace("{t}", tag) + "\n";
        Property prop = config.get("recipes." + subcat, tag, defaultValue);
        prop.comment = comment;
        recipes.put(subcat + "." + tag, prop.getBoolean(defaultValue));
    }

    private static boolean get(String cat, String tag, boolean defaultValue, String comment) {
        return RailcraftConfig.get(cat, tag, defaultValue, false, comment);
    }

    private static boolean get(String cat, String tag, boolean defaultValue, boolean reset, String comment) {
        comment = "\n" + comment.replace("{t}", tag) + "\n";
        Property prop = config.get(cat, tag, defaultValue);
        prop.comment = comment;
        boolean ret = prop.getBoolean(defaultValue);
        if (reset) {
            prop.set(defaultValue);
        }
        return ret;
    }

    private static boolean get(Configuration config, String cat, String tag, boolean defaultValue) {
        Property prop = config.get(cat, tag, defaultValue);
        return prop.getBoolean(defaultValue);
    }

    private static int get(String tag, int defaultValue, String comment) {
        return RailcraftConfig.get("general", tag, defaultValue, comment);
    }

    private static int get(String cat, String tag, int defaultValue, String comment) {
        comment = "\n" + comment.replace("{t}", tag) + "\n";
        Property prop = config.get(cat, tag, defaultValue);
        prop.comment = comment;
        return RailcraftConfig.parseInteger(prop, defaultValue);
    }

    private static int get(String cat, String tag, int min, int defaultValue, int max, String comment) {
        comment = "\n" + comment.replace("{t}", tag) + "\n";
        Property prop = config.get(cat, tag, defaultValue);
        prop.comment = comment;
        int parsed = RailcraftConfig.parseInteger(prop, defaultValue);
        int clamped = Math.max(parsed, min);
        if ((clamped = Math.min(clamped, max)) != parsed) {
            prop.set(clamped);
        }
        return clamped;
    }

    private static float get(String cat, String tag, float min, float defaultValue, float max, String comment) {
        comment = "\n" + comment.replace("{t}", tag) + "\n";
        Property prop = config.get(cat, tag, (double)defaultValue);
        prop.comment = comment;
        double parsed = RailcraftConfig.parseDouble(prop, defaultValue);
        double clamped = Math.max(parsed, (double)min);
        if ((clamped = Math.min(clamped, (double)max)) != parsed) {
            prop.set(clamped);
        }
        return (float)clamped;
    }

    private static int parseInteger(Property prop, int defaultValue) {
        int parsed;
        String value = prop.getString();
        try {
            parsed = Integer.parseInt(value);
        }
        catch (NumberFormatException ex) {
            Game.logError(Level.WARNING, "Failed to parse config tag, reseting to default: " + prop.getName(), ex);
            prop.set(defaultValue);
            return defaultValue;
        }
        return parsed;
    }

    private static double parseDouble(Property prop, double defaultValue) {
        double parsed;
        String value = prop.getString();
        try {
            parsed = Double.parseDouble(value);
        }
        catch (NumberFormatException ex) {
            Game.logError(Level.WARNING, "Failed to parse config tag, reseting to default: " + prop.getName(), ex);
            prop.set(defaultValue);
            return defaultValue;
        }
        return parsed;
    }

    private static Property get(String tag, String defaultValue, String comment) {
        return RailcraftConfig.get("general", tag, defaultValue, comment);
    }

    private static Property get(String cat, String tag, String defaultValue, String comment) {
        comment = "\n" + comment.replace("{t}", tag) + "\n";
        Property prop = config.get(cat, tag, defaultValue);
        prop.comment = comment;
        return prop;
    }

    private static void loadLootProperty(String tag, int defaultValue) {
        Property prop = config.get(CAT_LOOT, tag, defaultValue);
        int chance = RailcraftConfig.parseInteger(prop, defaultValue);
        lootChances.put(tag, chance);
    }

    private static void loadCartProperty(String tag) {
        Property prop = config.get(CAT_CARTS, tag, true);
        carts.put(tag, prop.getBoolean(true));
    }

    static {
        minecartTankCapacity = 32;
        minecartTankFillRate = 32;
        boreMiningSpeedMultiplier = 1.0f;
        biolerMultiplierFuel = 1.0f;
        biolerMultiplierBiofuel = 1.0f;
        fuelPerSteamMultiplier = 8.0f;
    }
}

