/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.fluids;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mods.railcraft.common.plugins.forge.CreativePlugin;
import mods.railcraft.common.util.misc.MiscTools;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumMovingObjectType;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.BlockFluidFinite;
import net.minecraftforge.fluids.Fluid;

public class ItemBucketRailcraft
extends Item {
    private final Fluid fluid;
    private String iconName;
    private ItemStack container = new ItemStack(Item.field_77788_aw);

    public ItemBucketRailcraft(int id, Fluid fluid) {
        super(id);
        this.fluid = fluid;
        this.func_77625_d(1);
        this.func_77642_a(Item.field_77788_aw);
        this.func_77637_a(CreativePlugin.TAB);
    }

    public Item func_77655_b(String name) {
        this.iconName = MiscTools.cleanTag(name);
        return super.func_77655_b(name);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IconRegister par1IconRegister) {
        this.field_77791_bV = par1IconRegister.func_94245_a("railcraft:" + this.iconName);
    }

    public ItemBucketRailcraft setContainerItemStack(ItemStack stack) {
        this.container = stack;
        return this;
    }

    public ItemStack getContainerItemStack(ItemStack stack) {
        return this.container.func_77946_l();
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        MovingObjectPosition mop = this.func_77621_a(world, player, false);
        if (mop != null && mop.field_72313_a == EnumMovingObjectType.TILE) {
            int x = mop.field_72311_b;
            int y = mop.field_72312_c;
            int z = mop.field_72309_d;
            if (!world.func_72962_a(player, x, y, z)) {
                return stack;
            }
            ForgeDirection sideHit = ForgeDirection.getOrientation((int)mop.field_72310_e);
            if (!player.func_82247_a(x += sideHit.offsetX, y += sideHit.offsetY, z += sideHit.offsetZ, mop.field_72310_e, stack)) {
                return stack;
            }
            if (this.tryPlaceContainedLiquid(world, x, y, z) && !player.field_71075_bZ.field_75098_d) {
                return this.getContainerItemStack(stack);
            }
        }
        return stack;
    }

    private boolean tryPlaceContainedLiquid(World world, int x, int y, int z) {
        if (this.fluid.getBlockID() <= 0) {
            return false;
        }
        Material material = world.func_72803_f(x, y, z);
        if (!world.func_72799_c(x, y, z) && material.func_76220_a()) {
            return false;
        }
        if (!(world.field_72995_K || material.func_76220_a() || material.func_76224_d())) {
            world.func_94578_a(x, y, z, true);
        }
        Block block = Block.field_71973_m[this.fluid.getBlockID()];
        world.func_72832_d(x, y, z, block.field_71990_ca, block instanceof BlockFluidFinite ? 15 : 0, 3);
        return true;
    }
}

