/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.fluids;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.core.RailcraftLanguage;
import mods.railcraft.common.fluids.BlockRailcraftFluid;
import mods.railcraft.common.fluids.BlockRailcraftFluidFinite;
import mods.railcraft.common.fluids.FluidContainers;
import mods.railcraft.common.fluids.Fluids;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialLiquid;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class RailcraftFluids {
    public static final RailcraftFluids INSTANCE = new RailcraftFluids();
    private static Fluid railcraftCreosote;
    private static Fluid railcraftSteam;
    private static Block blockCreosote;
    private static Block blockSteam;

    private RailcraftFluids() {
    }

    public static void preInit() {
        RailcraftFluids.initCreosote();
        RailcraftFluids.initSteam();
    }

    public static void postInit() {
        RailcraftFluids.initCreosoteBlock();
        RailcraftFluids.initSteamBlock();
        if (Fluids.CREOSOTE.get() == null) {
            throw new MissingFluidException("Fluid 'creosote' was not found. Please check your configs.");
        }
        if (Fluids.STEAM.get() == null) {
            throw new MissingFluidException("Fluid 'steam' was not found. Please check your configs.");
        }
    }

    public static void initCreosote() {
        if (railcraftCreosote == null && RailcraftConfig.isFluidEnabled("creosote")) {
            railcraftCreosote = new Fluid("creosote").setDensity(800).setViscosity(1500);
            FluidRegistry.registerFluid((Fluid)railcraftCreosote);
            Fluid fluidCreosote = Fluids.CREOSOTE.get();
            if (fluidCreosote == railcraftCreosote) {
                RailcraftLanguage.instance().pushTagToMinecraft("fluid.creosote");
            }
            RailcraftFluids.initCreosoteBlock();
        }
    }

    public static void initCreosoteBlock() {
        if (blockCreosote != null) {
            return;
        }
        Fluid fluidCreosote = Fluids.CREOSOTE.get();
        if (fluidCreosote == null) {
            return;
        }
        if (fluidCreosote.getBlockID() == -1) {
            int blockId = RailcraftConfig.getBlockId("block.fluid.creosote");
            if (blockId > 0) {
                blockCreosote = new BlockRailcraftFluid(blockId, fluidCreosote, Material.field_76244_g).setFlammable(true).setFlammability(10);
                blockCreosote.func_71864_b("railcraft.block.fluid.creosote");
                GameRegistry.registerBlock((Block)blockCreosote, (String)blockCreosote.func_71917_a());
                RailcraftLanguage.instance().registerItemName(new ItemStack(blockCreosote), "block.fluid.creosote");
                fluidCreosote.setBlockID(blockCreosote);
            }
        } else {
            blockCreosote = Block.field_71973_m[fluidCreosote.getBlockID()];
        }
        FluidContainers.getCreosoteOilBucket();
    }

    private static void initSteam() {
        if (railcraftSteam == null && RailcraftConfig.isFluidEnabled("steam")) {
            railcraftSteam = new Fluid("steam").setDensity(-1000).setViscosity(500);
            FluidRegistry.registerFluid((Fluid)railcraftSteam);
            Fluid fluidSteam = Fluids.STEAM.get();
            if (fluidSteam == railcraftSteam) {
                RailcraftLanguage.instance().pushTagToMinecraft("fluid.steam");
            }
            RailcraftFluids.initSteamBlock();
        }
    }

    private static void initSteamBlock() {
        if (blockSteam != null) {
            return;
        }
        Fluid fluidSteam = Fluids.STEAM.get();
        if (fluidSteam == null) {
            return;
        }
        if (fluidSteam.getBlockID() == -1) {
            int blockId = RailcraftConfig.getBlockId("block.fluid.steam");
            if (blockId > 0) {
                blockSteam = new BlockRailcraftFluidFinite(blockId, fluidSteam, (Material)new MaterialLiquid(MapColor.field_76279_b)).setNoFlow();
                blockSteam.func_71864_b("railcraft.block.fluid.steam");
                GameRegistry.registerBlock((Block)blockSteam, (String)blockSteam.func_71917_a());
                RailcraftLanguage.instance().registerItemName(new ItemStack(blockSteam), "block.fluid.steam");
                fluidSteam.setBlockID(blockSteam);
            }
        } else {
            blockSteam = Block.field_71973_m[fluidSteam.getBlockID()];
        }
        FluidContainers.getSteamBottle();
    }

    @ForgeSubscribe
    @SideOnly(value=Side.CLIENT)
    public void textureHook(TextureStitchEvent.Post event) {
        if (event.map.field_94255_a == 0) {
            railcraftCreosote.setIcons(blockCreosote.func_71851_a(1), blockCreosote.func_71851_a(2));
            railcraftSteam.setIcons(blockSteam.func_71851_a(1), blockSteam.func_71851_a(2));
        }
    }

    public static class MissingFluidException
    extends RuntimeException {
        public MissingFluidException(String msg) {
            super(msg);
        }
    }
}

