/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.items;

import com.google.common.collect.MapMaker;
import java.util.Map;
import mods.railcraft.api.carts.ILinkableCart;
import mods.railcraft.api.core.items.IToolCrowbar;
import mods.railcraft.common.carts.EntityTunnelBore;
import mods.railcraft.common.carts.IDirectionalCart;
import mods.railcraft.common.carts.LinkageManager;
import mods.railcraft.common.modules.ModuleManager;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.entity.player.EntityInteractEvent;

public class CrowbarHandler {
    public static final float SMACK_VELOCITY = 0.07f;
    private static Map linkMap = new MapMaker().weakKeys().weakValues().makeMap();
    private static CrowbarHandler instance;

    public static CrowbarHandler instance() {
        if (instance == null) {
            instance = new CrowbarHandler();
        }
        return instance;
    }

    @ForgeSubscribe
    public void onEntityInteract(EntityInteractEvent event) {
        EntityPlayer thePlayer = event.entityPlayer;
        Entity entity = event.target;
        ItemStack stack = thePlayer.func_71045_bC();
        if (stack != null && stack.func_77973_b() instanceof IToolCrowbar) {
            thePlayer.func_71038_i();
        }
        if (Game.isNotHost(thePlayer.field_70170_p)) {
            return;
        }
        if (!ModuleManager.isModuleLoaded(ModuleManager.Module.TRAIN)) {
            return;
        }
        boolean used = false;
        if (stack != null && stack.func_77973_b() instanceof IToolCrowbar) {
            IToolCrowbar crowbar = (IToolCrowbar)stack.func_77973_b();
            if (entity instanceof EntityMinecart) {
                EntityMinecart cart = (EntityMinecart)entity;
                if (crowbar.canLink(thePlayer, stack, cart)) {
                    boolean linkable = cart instanceof ILinkableCart;
                    if (!linkable || linkable && ((ILinkableCart)cart).isLinkable()) {
                        if (linkMap.containsKey(thePlayer)) {
                            EntityMinecart last;
                            LinkageManager lm = LinkageManager.instance();
                            if (lm.areLinked(cart, last = (EntityMinecart)linkMap.remove(thePlayer))) {
                                lm.breakLink(cart, last);
                                used = true;
                                thePlayer.func_71035_c("Link Broken");
                                LinkageManager.printDebug("Reason For Broken Link: User removed link.", new Object[0]);
                            } else {
                                used = lm.createLink((EntityMinecart)entity, last);
                                if (used) {
                                    thePlayer.func_71035_c("Link Created");
                                }
                            }
                            if (!used) {
                                thePlayer.func_71035_c("Link Failed");
                            }
                        } else {
                            linkMap.put(thePlayer, (EntityMinecart)entity);
                            thePlayer.func_71035_c("Link Started");
                        }
                    }
                    if (used) {
                        crowbar.onLink(thePlayer, stack, cart);
                    }
                } else if (crowbar.canBoost(thePlayer, stack, cart)) {
                    thePlayer.func_71020_j(1.0f);
                    if (thePlayer.field_70154_o == null && !(cart instanceof EntityTunnelBore)) {
                        if (cart instanceof IDirectionalCart) {
                            ((IDirectionalCart)cart).reverse();
                        } else {
                            cart.field_70159_w = cart.field_70165_t < thePlayer.field_70165_t ? (cart.field_70159_w -= (double)0.07f) : (cart.field_70159_w += (double)0.07f);
                            cart.field_70179_y = cart.field_70161_v < thePlayer.field_70161_v ? (cart.field_70179_y -= (double)0.07f) : (cart.field_70179_y += (double)0.07f);
                        }
                    }
                    crowbar.onBoost(thePlayer, stack, cart);
                }
            }
        }
        if (used) {
            event.setCanceled(true);
        }
    }
}

