/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mods.railcraft.api.core.items.IStackFilter;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.core.RailcraftLanguage;
import mods.railcraft.common.items.ItemTicket;
import mods.railcraft.common.plugins.forge.CraftingPlugin;
import mods.railcraft.common.plugins.forge.ItemRegistry;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.network.IEditableItem;
import mods.railcraft.common.util.network.PacketBuilder;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class ItemTicketGold
extends ItemTicket
implements IEditableItem {
    public static final IStackFilter FILTER = new IStackFilter(){

        @Override
        public boolean matches(ItemStack stack) {
            return stack != null && stack.func_77973_b() instanceof ItemTicketGold;
        }
    };
    public static ItemTicketGold item;

    public static void registerItem() {
        String tag;
        int id;
        if (item == null && (id = RailcraftConfig.getItemId(tag = "railcraft.routing.ticket.gold")) > 0) {
            item = new ItemTicketGold(id);
            item.func_77655_b(tag);
            item.setRarity(1);
            RailcraftLanguage.instance().registerItemName(item, tag);
            ItemRegistry.registerItem(item);
            CraftingPlugin.addShapelessRecipe(new ItemStack((Item)item), Item.field_77759_aK, Item.field_77733_bq);
            ItemRegistry.registerItemStack(tag, new ItemStack((Item)item));
        }
    }

    public static ItemStack getTicket() {
        if (item == null) {
            return null;
        }
        return new ItemStack((Item)item);
    }

    public ItemTicketGold(int id) {
        super(id);
    }

    public boolean func_77630_h(ItemStack stack) {
        return false;
    }

    public boolean func_77634_r() {
        return true;
    }

    public ItemStack getContainerItemStack(ItemStack stack) {
        stack = stack.func_77946_l();
        stack.field_77994_a = 1;
        return stack;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a("railcraft:ticket.gold");
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (Game.isHost(world) && this.canPlayerEdit(player, stack)) {
            PacketBuilder.instance().sendGoldenTicketGuiPacket(player);
        }
        return stack;
    }

    @Override
    public boolean canPlayerEdit(EntityPlayer player, ItemStack stack) {
        boolean canEdit = Game.isPlayerOp(player.field_71092_bJ);
        if (!canEdit && !RailcraftConfig.isRoutingOpsOnly()) {
            String owner = ItemTicketGold.getOwner(stack);
            canEdit |= owner.equals("") || owner.equals(player.field_71092_bJ);
        }
        return canEdit;
    }
}

