/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.items.firestone;

import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.List;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.core.RailcraftLanguage;
import mods.railcraft.common.gui.tooltips.ToolTip;
import mods.railcraft.common.items.firestone.EntityItemFirestone;
import mods.railcraft.common.items.firestone.ItemFirestoneBase;
import mods.railcraft.common.items.firestone.ItemFirestoneCracked;
import mods.railcraft.common.plugins.forge.ItemRegistry;
import mods.railcraft.common.plugins.forge.WorldPlugin;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.misc.MiscTools;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ItemFirestoneRefined
extends ItemFirestoneBase {
    private static int HEAT = 250;
    public static Item item;

    public static void registerItem() {
        String tag;
        int id;
        if (item == null && (id = RailcraftConfig.getItemId(tag = "railcraft.firestone.refined")) > 0) {
            item = new ItemFirestoneRefined(id).func_77655_b(tag);
            GameRegistry.registerItem((Item)item, (String)tag);
            RailcraftLanguage.instance().registerItemName(item, tag);
            ItemRegistry.registerItemStack(tag, new ItemStack(item));
        }
    }

    public static ItemStack getItemCharged() {
        return new ItemStack(item);
    }

    public static ItemStack getItemEmpty() {
        return new ItemStack(item, 1, item.func_77612_l() - 1);
    }

    public ItemFirestoneRefined(int id) {
        super(id);
        this.func_77625_d(1);
        this.func_77656_e(5000);
    }

    public void func_77633_a(int id, CreativeTabs tab, List list) {
        list.add(new ItemStack((Item)this, 1, this.func_77612_l()));
        list.add(new ItemStack((Item)this, 1, 0));
    }

    public boolean func_77634_r() {
        return true;
    }

    public ItemStack getContainerItemStack(ItemStack stack) {
        double damageLevel = (double)stack.func_77960_j() / (double)stack.func_77958_k();
        ItemStack newStack = MiscTools.RANDOM.nextDouble() < damageLevel * 1.0E-4 ? ItemFirestoneCracked.getItemEmpty() : stack.func_77946_l();
        newStack.field_77994_a = 1;
        newStack = InvTools.damageItem(newStack, 1);
        return newStack;
    }

    @Override
    public int getHeatValue(ItemStack stack) {
        if (stack.func_77960_j() < this.func_77612_l()) {
            return HEAT;
        }
        return 0;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List info, boolean adv) {
        ToolTip tip;
        String tipTag = "firestone.refined.tip.charged";
        if (stack.func_77960_j() >= stack.func_77958_k() - 5) {
            tipTag = "firestone.refined.tip.empty";
        }
        if ((tip = ToolTip.buildToolTip(tipTag, new String[0])) != null) {
            info.addAll(tip.convertToStrings());
        }
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        ItemStack cooked;
        ArrayList drops;
        Block block;
        if (player.func_82247_a(x, y, z, side, stack) && (block = WorldPlugin.getBlock((IBlockAccess)world, x, y, z)) != null && block != Block.field_71981_t && (drops = block.getBlockDropped(world, x, y, z, world.func_72805_g(x, y, z), 0)).size() == 1 && drops.get(0) != null && ((ItemStack)drops.get(0)).func_77973_b() instanceof ItemBlock && (cooked = FurnaceRecipes.func_77602_a().getSmeltingResult((ItemStack)drops.get(0))) != null && cooked.func_77973_b() instanceof ItemBlock) {
            int meta = !cooked.func_77973_b().func_77614_k() ? 0 : cooked.func_77973_b().func_77647_b(cooked.func_77960_j());
            world.func_72832_d(x, y, z, cooked.field_77993_c, meta, 3);
            world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "fire.ignite", 1.0f, field_77697_d.nextFloat() * 0.4f + 0.8f);
            stack.func_77972_a(1, (EntityLivingBase)player);
            return true;
        }
        if (side == 0) {
            --y;
        }
        if (side == 1) {
            ++y;
        }
        if (side == 2) {
            --z;
        }
        if (side == 3) {
            ++z;
        }
        if (side == 4) {
            --x;
        }
        if (side == 5) {
            ++x;
        }
        if (player.func_82247_a(x, y, z, side, stack) && world.func_72799_c(x, y, z)) {
            world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "fire.ignite", 1.0f, field_77697_d.nextFloat() * 0.4f + 0.8f);
            world.func_94575_c(x, y, z, Block.field_72067_ar.field_71990_ca);
            stack.func_77972_a(1, (EntityLivingBase)player);
            return true;
        }
        return false;
    }

    @Override
    public Entity createEntity(World world, Entity location, ItemStack stack) {
        EntityItemFirestone entity = new EntityItemFirestone(world, location.field_70165_t, location.field_70163_u, location.field_70161_v, stack);
        entity.field_70159_w = location.field_70159_w;
        entity.field_70181_x = location.field_70181_x;
        entity.field_70179_y = location.field_70179_y;
        entity.field_70293_c = 10;
        return entity;
    }
}

