/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.plugins.forestry;

import mods.railcraft.common.blocks.aesthetics.stairs.EnumStair;
import mods.railcraft.common.blocks.aesthetics.wall.EnumWallAlpha;
import mods.railcraft.common.core.RailcraftLanguage;
import mods.railcraft.common.plugins.forestry.BaseBackpack;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.inventory.StandaloneInventory;
import net.minecraft.block.Block;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class IcemanBackpack
extends BaseBackpack {
    private static IcemanBackpack instance;
    private static final ItemStack SNOWBALL;
    private static final ItemStack SNOWBLOCK;
    private static final String INV_TAG = "Items";

    public static IcemanBackpack getInstance() {
        if (instance == null) {
            instance = new IcemanBackpack();
        }
        return instance;
    }

    protected IcemanBackpack() {
    }

    public void setup() {
        this.addValidItem(Block.field_72037_aS);
        this.addValidItem(Block.field_72039_aU);
        this.addValidItem(Block.field_72036_aT);
        this.addValidItem(EnumWallAlpha.SNOW.getItem());
        this.addValidItem(EnumWallAlpha.ICE.getItem());
        this.addValidItem(EnumStair.SNOW.getItem());
        this.addValidItem(EnumStair.ICE.getItem());
        this.addValidItem(Item.field_77768_aD);
    }

    public void compactInventory(ItemStack backpack) {
        StandaloneInventory inv = new StandaloneInventory(45);
        NBTTagCompound data = backpack.func_77978_p();
        if (data == null) {
            return;
        }
        InvTools.readInvFromNBT(inv, INV_TAG, data);
        int numSnowballs = InvTools.countItems((IInventory)inv, SNOWBALL);
        if (numSnowballs >= 16) {
            for (int i = 0; i < 4; ++i) {
                InvTools.removeOneItem((IInventory)inv, SNOWBALL);
            }
            if (InvTools.moveItemStack(new ItemStack(Block.field_72039_aU), inv) == null) {
                InvTools.writeInvToNBT(inv, INV_TAG, data);
            }
        } else if (numSnowballs < 8 && InvTools.removeOneItem((IInventory)inv, SNOWBLOCK) != null && InvTools.moveItemStack(new ItemStack(Item.field_77768_aD, 4), inv) == null) {
            InvTools.writeInvToNBT(inv, INV_TAG, data);
        }
    }

    @Override
    public String getKey() {
        return "ICEMAN";
    }

    @Override
    public String getName() {
        return RailcraftLanguage.translate("backpack.iceman.t1");
    }

    @Override
    public int getPrimaryColour() {
        return 0xFFFFFF;
    }

    @Override
    public int getSecondaryColour() {
        return 0xFFFFFF;
    }

    static {
        SNOWBALL = new ItemStack(Item.field_77768_aD);
        SNOWBLOCK = new ItemStack(Block.field_72039_aU);
    }
}

