/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.util.inventory.filters;

import mods.railcraft.api.core.items.IMinecartItem;
import mods.railcraft.api.core.items.IStackFilter;
import mods.railcraft.api.core.items.ITrackItem;
import mods.railcraft.common.plugins.forge.FuelPlugin;
import mods.railcraft.common.util.misc.BallastRegistry;
import net.minecraft.block.BlockRail;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemMinecart;
import net.minecraft.item.ItemSeeds;
import net.minecraft.item.ItemStack;

public enum StackFilter implements IStackFilter
{
    ALL{

        @Override
        public boolean matches(ItemStack stack) {
            return true;
        }
    }
    ,
    FUEL{

        @Override
        public boolean matches(ItemStack stack) {
            return FuelPlugin.getBurnTime(stack) > 0;
        }
    }
    ,
    TRACK{

        @Override
        public boolean matches(ItemStack stack) {
            return stack.func_77973_b() instanceof ITrackItem || stack.func_77973_b() instanceof ItemBlock && BlockRail.func_72184_d((int)stack.field_77993_c);
        }
    }
    ,
    MINECART{

        @Override
        public boolean matches(ItemStack stack) {
            return stack.func_77973_b() instanceof ItemMinecart || stack.func_77973_b() instanceof IMinecartItem;
        }
    }
    ,
    BALLAST{

        @Override
        public boolean matches(ItemStack stack) {
            return BallastRegistry.isItemBallast(stack);
        }
    }
    ,
    FEED{

        @Override
        public boolean matches(ItemStack stack) {
            return stack.func_77973_b() instanceof ItemFood || stack.field_77993_c == Item.field_77685_T.field_77779_bT || stack.func_77973_b() instanceof ItemSeeds;
        }
    };


    /*
     * WARNING - Possible parameter corruption
     * WARNING - void declaration
     */
    private StackFilter() {
    }

    public static void initialize() {
        for (StackFilter type : StackFilter.values()) {
            IStackFilter.filters.put(type.name(), type);
        }
    }

    @Override
    public abstract boolean matches(ItemStack var1);

    /*
     * WARNING - Possible parameter corruption
     * WARNING - void declaration
     */
    /* synthetic */ StackFilter(1 x0) {
        this((String)x0, (int)x1);
        void x1;
    }
}

