/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.util.steam;

import mods.railcraft.api.fuel.FuelManager;
import mods.railcraft.common.fluids.tanks.StandardTank;
import mods.railcraft.common.util.steam.IFuelProvider;
import net.minecraftforge.fluids.FluidStack;

public class FluidFuelProvider
implements IFuelProvider {
    private final StandardTank fuelTank;

    public FluidFuelProvider(StandardTank fuelTank) {
        this.fuelTank = fuelTank;
    }

    @Override
    public float getHeatStep() {
        return 0.05f;
    }

    @Override
    public float getMoreFuel() {
        FluidStack fuel = this.fuelTank.drain(1000, false);
        if (fuel == null) {
            return 0.0f;
        }
        float heatValue = FuelManager.getBoilerFuelValue(fuel.getFluid());
        if (heatValue > 0.0f) {
            this.fuelTank.drain(1000, true);
            if (fuel.amount < 1000) {
                heatValue *= (float)fuel.amount / 1000.0f;
            }
        }
        return heatValue;
    }
}

