/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.util.steam;

import mods.railcraft.common.blocks.RailcraftTileEntity;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.fluids.Fluids;
import mods.railcraft.common.fluids.tanks.StandardTank;
import mods.railcraft.common.gui.widgets.IIndicatorController;
import mods.railcraft.common.gui.widgets.IndicatorController;
import mods.railcraft.common.util.steam.IFuelProvider;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;

public class SteamBoiler {
    private final StandardTank tankWater;
    private final StandardTank tankSteam;
    private float partialConversions = 0.0f;
    public float burnTime;
    public float currentItemBurnTime;
    protected boolean isBurning = false;
    protected byte burnCycle;
    private float heat = 20.0f;
    private float maxHeat = 500.0f;
    private float efficiencyModifier = 1.0f;
    private int ticksPerCycle = 16;
    private RailcraftTileEntity tile;
    private IFuelProvider fuelProvider;
    public final IIndicatorController heatIndicator = new HeatIndicator();

    public SteamBoiler(StandardTank tankWater, StandardTank tankSteam) {
        this.tankWater = tankWater;
        this.tankSteam = tankSteam;
    }

    public SteamBoiler setFuelProvider(IFuelProvider fuelProvider) {
        this.fuelProvider = fuelProvider;
        return this;
    }

    public SteamBoiler setTile(RailcraftTileEntity tile) {
        this.tile = tile;
        return this;
    }

    public SteamBoiler setTicksPerCycle(int ticks) {
        this.ticksPerCycle = ticks;
        return this;
    }

    public SteamBoiler setInefficencyModifier(float modifier) {
        this.efficiencyModifier = modifier;
        return this;
    }

    public SteamBoiler setMaxHeat(float maxHeat) {
        this.maxHeat = maxHeat;
        return this;
    }

    public float getMaxHeat() {
        return this.maxHeat;
    }

    public float getHeatStep() {
        if (this.fuelProvider != null) {
            return this.fuelProvider.getHeatStep();
        }
        return 0.05f;
    }

    public void reset() {
        this.heat = 20.0f;
    }

    public float getHeat() {
        return this.heat;
    }

    public void setHeat(float heat) {
        this.heat = heat;
        if (this.heat < 20.0f) {
            this.heat = 20.0f;
        }
    }

    public float getHeatLevel() {
        return this.heat / this.getMaxHeat();
    }

    public void increaseHeat(int numTanks) {
        float max = this.getMaxHeat();
        if (this.heat == max) {
            return;
        }
        float step = this.getHeatStep();
        float change = step + (max - this.heat) / max * step * 3.0f;
        this.heat += (change /= (float)numTanks);
        this.heat = Math.min(this.heat, max);
    }

    public void reduceHeat(int numTanks) {
        if (this.heat == 20.0f) {
            return;
        }
        float step = 0.05f;
        float change = step + this.heat / this.getMaxHeat() * step * 3.0f;
        this.heat -= (change /= (float)numTanks);
        this.heat = Math.max(this.heat, 20.0f);
    }

    public boolean isBoiling() {
        return this.getHeat() >= 100.0f;
    }

    public boolean isSuperHeated() {
        return this.getHeat() >= 300.0f;
    }

    public boolean isBurning() {
        return this.isBurning;
    }

    public void setBurning(boolean isBurning) {
        this.isBurning = isBurning;
    }

    public int getBurnProgressScaled(int i) {
        if (!this.isBurning()) {
            return 0;
        }
        int scale = (int)(this.burnTime / this.currentItemBurnTime * (float)i);
        scale = Math.max(0, scale);
        scale = Math.min(i, scale);
        return scale;
    }

    private boolean addFuel() {
        if (this.fuelProvider == null) {
            return false;
        }
        float fuel = this.fuelProvider.getMoreFuel();
        this.burnTime += fuel;
        this.currentItemBurnTime = this.burnTime;
        return fuel > 0.0f;
    }

    public double getFuelPerCycle(int numTanks) {
        double fuel = 8.0;
        fuel -= (double)((float)numTanks * 8.0f * 0.0125f);
        fuel += (double)(0.8f * this.getHeatLevel());
        fuel += (double)(4.0f * (this.getMaxHeat() / 1000.0f));
        fuel *= (double)numTanks;
        fuel *= (double)this.efficiencyModifier;
        return fuel *= (double)RailcraftConfig.fuelPerSteamMultiplier();
    }

    public void tick(int numTanks) {
        this.burnCycle = (byte)(this.burnCycle + 1);
        if (this.burnCycle >= this.ticksPerCycle) {
            boolean addedFuel;
            this.burnCycle = 0;
            double fuelNeeded = this.getFuelPerCycle(numTanks);
            while ((double)this.burnTime < fuelNeeded && (addedFuel = this.addFuel())) {
            }
            boolean wasBurning = this.isBurning;
            boolean bl = this.isBurning = (double)this.burnTime >= fuelNeeded;
            if (this.isBurning) {
                this.burnTime = (float)((double)this.burnTime - fuelNeeded);
            }
            if (this.tile != null && this.isBurning != wasBurning) {
                this.tile.sendUpdateToClient();
            }
            this.convertSteam(numTanks);
        }
        if (this.isBurning) {
            this.increaseHeat(numTanks);
        } else {
            this.reduceHeat(numTanks);
        }
    }

    public void convertSteam(int numTanks) {
        if (!this.isBoiling()) {
            return;
        }
        this.partialConversions += (float)numTanks * this.getHeatLevel();
        int waterCost = (int)this.partialConversions;
        if (waterCost <= 0) {
            return;
        }
        this.partialConversions -= (float)waterCost;
        FluidStack water = this.tankWater.drain(waterCost, false);
        if (water == null) {
            return;
        }
        FluidStack steam = Fluids.STEAM.get(160 * (waterCost = Math.min(waterCost, water.amount)));
        if (steam == null) {
            return;
        }
        this.tankWater.drain(waterCost, true);
        this.tankSteam.fill(steam, true);
    }

    public void writeToNBT(NBTTagCompound data) {
        data.func_74776_a("heat", this.heat);
        data.func_74776_a("maxHeat", this.maxHeat);
        data.func_74776_a("burnTime", this.burnTime);
        data.func_74776_a("currentItemBurnTime", this.currentItemBurnTime);
    }

    public void readFromNBT(NBTTagCompound data) {
        this.heat = data.func_74760_g("heat");
        this.maxHeat = data.func_74760_g("maxHeat");
        this.burnTime = data.func_74760_g("burnTime");
        this.currentItemBurnTime = data.func_74760_g("currentItemBurnTime");
    }

    private class HeatIndicator
    extends IndicatorController {
        private HeatIndicator() {
        }

        @Override
        protected void refreshToolTip() {
            this.tip.text = String.format("%.0f\u00b0C", Float.valueOf(SteamBoiler.this.getHeat()));
        }

        @Override
        public int getScaledLevel(int size) {
            return (int)((SteamBoiler.this.getHeat() - 20.0f) * (float)size / (SteamBoiler.this.getMaxHeat() - 20.0f));
        }
    }
}

