/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api.gates;

import buildcraft.api.gates.IAction;
import buildcraft.api.gates.IActionProvider;
import buildcraft.api.gates.ITrigger;
import buildcraft.api.gates.ITriggerProvider;
import buildcraft.api.transport.IPipe;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;

public class ActionManager {
    public static Map triggers = new HashMap();
    public static Map actions = new HashMap();
    private static LinkedList triggerProviders = new LinkedList();
    private static LinkedList actionProviders = new LinkedList();

    public static void registerTriggerProvider(ITriggerProvider provider) {
        if (provider != null && !triggerProviders.contains(provider)) {
            triggerProviders.add(provider);
        }
    }

    public static void registerTrigger(ITrigger trigger) {
        triggers.put(trigger.getUniqueTag(), trigger);
    }

    public static void registerAction(IAction action) {
        actions.put(action.getUniqueTag(), action);
    }

    public static LinkedList getNeighborTriggers(Block block, TileEntity entity) {
        LinkedList<ITrigger> triggers = new LinkedList<ITrigger>();
        for (ITriggerProvider provider : triggerProviders) {
            LinkedList toAdd = provider.getNeighborTriggers(block, entity);
            if (toAdd == null) continue;
            for (ITrigger t : toAdd) {
                if (triggers.contains(t)) continue;
                triggers.add(t);
            }
        }
        return triggers;
    }

    public static void registerActionProvider(IActionProvider provider) {
        if (provider != null && !actionProviders.contains(provider)) {
            actionProviders.add(provider);
        }
    }

    public static LinkedList getNeighborActions(Block block, TileEntity entity) {
        LinkedList<IAction> actions = new LinkedList<IAction>();
        for (IActionProvider provider : actionProviders) {
            LinkedList toAdd = provider.getNeighborActions(block, entity);
            if (toAdd == null) continue;
            for (IAction t : toAdd) {
                if (actions.contains(t)) continue;
                actions.add(t);
            }
        }
        return actions;
    }

    public static LinkedList getPipeTriggers(IPipe pipe) {
        LinkedList<ITrigger> triggers = new LinkedList<ITrigger>();
        for (ITriggerProvider provider : triggerProviders) {
            LinkedList toAdd = provider.getPipeTriggers(pipe);
            if (toAdd == null) continue;
            for (ITrigger t : toAdd) {
                if (triggers.contains(t)) continue;
                triggers.add(t);
            }
        }
        return triggers;
    }

    public static ITrigger getTriggerFromLegacyId(int legacyId) {
        for (ITrigger trigger : triggers.values()) {
            if (trigger.getLegacyId() != legacyId) continue;
            return trigger;
        }
        return null;
    }

    public static IAction getActionFromLegacyId(int legacyId) {
        for (IAction action : actions.values()) {
            if (action.getLegacyId() != legacyId) continue;
            return action;
        }
        return null;
    }
}

