/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture;

import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IApiaristTracker;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeekeepingLogic;
import forestry.api.genetics.IEffectData;
import forestry.api.genetics.IIndividual;
import forestry.core.EnumErrorCode;
import forestry.core.config.ForestryItem;
import forestry.core.proxy.Proxies;
import forestry.plugins.PluginApiculture;
import java.util.Stack;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class BeekeepingLogic
implements IBeekeepingLogic {
    private static final int MAX_POLLINATION_ATTEMPTS = 20;
    IBeeHousing housing;
    private int breedingTime;
    private int totalBreedingTime = 100;
    private int throttle;
    private IEffectData[] effectData = new IEffectData[2];
    private IBee queen;
    private IIndividual pollen;
    private int attemptedPollinations = 0;
    private Stack spawn = new Stack();

    public BeekeepingLogic(IBeeHousing housing) {
        this.housing = housing;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        this.breedingTime = nbttagcompound.func_74762_e("BreedingTime");
        this.throttle = nbttagcompound.func_74762_e("Throttle");
        NBTTagList nbttaglist = new NBTTagList();
        while (!this.spawn.isEmpty()) {
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            ((ItemStack)this.spawn.pop()).func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbttagcompound.func_74782_a("Offspring", (NBTBase)nbttaglist);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74768_a("BreedingTime", this.breedingTime);
        nbttagcompound.func_74768_a("Throttle", this.throttle);
        NBTTagList nbttaglist = nbttagcompound.func_74761_m("Offspring");
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            this.spawn.add(ItemStack.func_77949_a((NBTTagCompound)((NBTTagCompound)nbttaglist.func_74743_b(i))));
        }
    }

    @Override
    public int getBreedingTime() {
        return this.breedingTime;
    }

    @Override
    public int getTotalBreedingTime() {
        return this.totalBreedingTime;
    }

    @Override
    public IBee getQueen() {
        return this.queen;
    }

    @Override
    public IBeeHousing getHousing() {
        return this.housing;
    }

    @Override
    public IEffectData[] getEffectData() {
        return this.effectData;
    }

    @Override
    public void update() {
        this.resetQueen(null);
        if (!this.spawn.isEmpty()) {
            ItemStack next = (ItemStack)this.spawn.peek();
            if (this.housing.addProduct(next, true)) {
                this.spawn.pop();
                this.housing.setErrorState(EnumErrorCode.OK.ordinal());
            } else {
                this.housing.setErrorState(EnumErrorCode.NOSPACE.ordinal());
            }
            return;
        }
        if (this.housing.getQueen() == null) {
            this.housing.setErrorState(EnumErrorCode.NOQUEEN.ordinal());
            return;
        }
        if (this.housing.getQueen().field_77993_c == ForestryItem.beePrincessGE.field_77779_bT) {
            if (this.housing.getDrone() == null || this.housing.getDrone().field_77993_c != ForestryItem.beeDroneGE.field_77779_bT) {
                this.housing.setErrorState(EnumErrorCode.NODRONE.ordinal());
            } else {
                this.housing.setErrorState(EnumErrorCode.OK.ordinal());
            }
            this.tickBreed();
            return;
        }
        if (this.housing.getQueen().field_77993_c != ForestryItem.beeQueenGE.field_77779_bT) {
            this.housing.setErrorState(EnumErrorCode.NOQUEEN.ordinal());
            return;
        }
        IBee queen = PluginApiculture.beeInterface.getMember(this.housing.getQueen());
        if (!queen.isAlive()) {
            this.killQueen(queen);
            this.housing.setErrorState(EnumErrorCode.OK.ordinal());
            return;
        }
        this.resetQueen(queen);
        EnumErrorCode state = EnumErrorCode.values()[queen.isWorking(this.housing)];
        if (state != EnumErrorCode.OK) {
            this.housing.setErrorState(state.ordinal());
            return;
        }
        if (this.housing.getErrorOrdinal() != EnumErrorCode.NOFLOWER.ordinal()) {
            this.housing.setErrorState(EnumErrorCode.OK.ordinal());
        }
        this.effectData = queen.doEffect(this.effectData, this.housing);
        ++this.throttle;
        if (this.throttle < PluginApiculture.beeCycleTicks) {
            return;
        }
        this.throttle = 0;
        if (!queen.hasFlower(this.housing)) {
            this.housing.setErrorState(EnumErrorCode.NOFLOWER.ordinal());
            return;
        }
        this.housing.setErrorState(EnumErrorCode.OK.ordinal());
        ItemStack[] products = queen.produceStacks(this.housing);
        this.housing.wearOutEquipment(1);
        for (ItemStack stack : products) {
            this.housing.addProduct(stack, false);
        }
        queen.plantFlowerRandom(this.housing);
        if (this.pollen == null) {
            this.pollen = queen.retrievePollen(this.housing);
            this.attemptedPollinations = 0;
            if (this.pollen != null && this.housing.onPollenRetrieved(queen, this.pollen, false)) {
                this.pollen = null;
            }
        }
        if (this.pollen != null) {
            ++this.attemptedPollinations;
            if (queen.pollinateRandom(this.housing, this.pollen) || this.attemptedPollinations >= 20) {
                this.pollen = null;
            }
        }
        queen.age(this.housing.getWorld(), this.housing.getLifespanModifier(queen.getGenome(), queen.getMate(), 0.0f));
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        queen.writeToNBT(nbttagcompound);
        this.housing.getQueen().func_77982_d(nbttagcompound);
    }

    private void resetQueen(IBee bee) {
        this.queen = bee;
    }

    private void tickBreed() {
        if (!this.tryBreed()) {
            this.breedingTime = 0;
            return;
        }
        if (this.breedingTime < this.totalBreedingTime) {
            ++this.breedingTime;
        }
        if (this.breedingTime < this.totalBreedingTime) {
            return;
        }
        if (this.housing.getQueen() == null || this.housing.getQueen().field_77993_c != ForestryItem.beePrincessGE.field_77779_bT) {
            return;
        }
        IBee princess = PluginApiculture.beeInterface.getMember(this.housing.getQueen());
        IBee drone = PluginApiculture.beeInterface.getMember(this.housing.getDrone());
        princess.mate(drone);
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        princess.writeToNBT(nbttagcompound);
        ItemStack queen = new ItemStack(ForestryItem.beeQueenGE);
        queen.func_77982_d(nbttagcompound);
        this.housing.setQueen(queen);
        this.housing.onQueenChange(this.housing.getQueen());
        PluginApiculture.beeInterface.getBreedingTracker(this.housing.getWorld(), this.housing.getOwnerName()).registerQueen(princess);
        --this.housing.getDrone().field_77994_a;
        if (this.housing.getDrone().field_77994_a <= 0) {
            this.housing.setDrone(null);
        }
        this.breedingTime = 0;
    }

    private boolean tryBreed() {
        if (this.housing.getDrone() == null || this.housing.getQueen() == null) {
            return false;
        }
        if (this.housing.getDrone().field_77993_c != ForestryItem.beeDroneGE.field_77779_bT || this.housing.getQueen().field_77993_c != ForestryItem.beePrincessGE.field_77779_bT) {
            return false;
        }
        return this.housing.canBreed();
    }

    private void killQueen(IBee queen) {
        if (queen.canSpawn()) {
            this.spawnOffspring(queen);
            this.housing.getQueen().field_77994_a = 0;
            this.housing.setQueen(null);
        } else {
            Proxies.log.warning("Tried to spawn offspring off an unmated queen. Devolving her to a princess.");
            ItemStack convert = new ItemStack(ForestryItem.beePrincessGE);
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            queen.writeToNBT(nbttagcompound);
            convert.func_77982_d(nbttagcompound);
            this.spawn.add(convert);
            this.housing.setQueen(null);
        }
        this.housing.onQueenChange(this.housing.getQueen());
    }

    private void spawnOffspring(IBee queen) {
        IBee[] larvae;
        Stack<ItemStack> offspring = new Stack<ItemStack>();
        IApiaristTracker breedingTracker = PluginApiculture.beeInterface.getBreedingTracker(this.housing.getWorld(), this.housing.getOwnerName());
        this.housing.onQueenDeath(this.getQueen());
        IBee heiress = queen.spawnPrincess(this.housing);
        if (heiress != null) {
            ItemStack princess = PluginApiculture.beeInterface.getMemberStack(heiress, EnumBeeType.PRINCESS.ordinal());
            breedingTracker.registerPrincess(heiress);
            offspring.push(princess);
        }
        for (IBee larva : larvae = queen.spawnDrones(this.housing)) {
            ItemStack drone = PluginApiculture.beeInterface.getMemberStack(larva, EnumBeeType.DRONE.ordinal());
            breedingTracker.registerDrone(larva);
            offspring.push(drone);
        }
        while (!offspring.isEmpty()) {
            ItemStack spawned = (ItemStack)offspring.pop();
            if (this.housing.addProduct(spawned, true)) continue;
            this.spawn.add(spawned);
        }
        this.housing.onPostQueenDeath(this.getQueen());
    }
}

