/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture;

import forestry.api.genetics.IFlowerProvider;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IPollinatable;
import forestry.core.utils.StringUtil;
import java.util.EnumSet;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;

public class FlowerProviderGourd
implements IFlowerProvider {
    @Override
    public boolean isAcceptedFlower(World world, IIndividual individual, int x, int y, int z) {
        int blockid = world.func_72798_a(x, y, z);
        return blockid == Block.field_71996_bs.field_71990_ca || blockid == Block.field_71999_bt.field_71990_ca;
    }

    @Override
    public boolean isAcceptedPollinatable(World world, IPollinatable pollinatable) {
        EnumSet types = pollinatable.getPlantType();
        return types.size() > 1 || !types.contains(EnumPlantType.Nether);
    }

    @Override
    public boolean growFlower(World world, IIndividual individual, int x, int y, int z) {
        int blockid = world.func_72798_a(x, y, z);
        if (blockid != Block.field_71996_bs.field_71990_ca && blockid != Block.field_71999_bt.field_71990_ca) {
            return false;
        }
        int meta = world.func_72805_g(x, y, z);
        if (meta > 6) {
            return false;
        }
        meta = meta < 6 ? (meta += 2) : 7;
        world.func_72921_c(x, y, z, meta, 2);
        return true;
    }

    @Override
    public String getDescription() {
        return StringUtil.localize("flowers.gourd");
    }

    @Override
    public ItemStack[] affectProducts(World world, IIndividual individual, int x, int y, int z, ItemStack[] products) {
        return products;
    }

    @Override
    public ItemStack[] getItemStacks() {
        return new ItemStack[]{new ItemStack(Block.field_72058_az, 1, 8)};
    }
}

