/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.gadgets;

import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeekeepingLogic;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.core.ForestryAPI;
import forestry.api.genetics.IIndividual;
import forestry.core.EnumErrorCode;
import forestry.core.config.Config;
import forestry.core.config.ForestryItem;
import forestry.core.gadgets.TileBase;
import forestry.core.interfaces.IClimatised;
import forestry.core.network.GuiId;
import forestry.core.network.PacketInventoryStack;
import forestry.core.network.PacketTileUpdate;
import forestry.core.proxy.Proxies;
import forestry.core.utils.InventoryAdapter;
import forestry.core.utils.Utils;
import forestry.plugins.PluginApiculture;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public class TileBeehouse
extends TileBase
implements IBeeHousing,
IClimatised {
    public static final int SLOT_QUEEN = 0;
    public static final int SLOT_DRONE = 1;
    public static final int SLOT_INVENTORY_1 = 2;
    protected static int SLOT_PRODUCT_1 = 2;
    protected static int SLOT_PRODUCT_COUNT = 7;
    public static final int SLOT_FRAMES_1 = 9;
    public static final int SLOT_INVENTORY_COUNT = 7;
    public static final int SLOT_FRAMES_COUNT = 3;
    protected InventoryAdapter inventory = new InventoryAdapter(12, "Items");
    private IBeekeepingLogic logic;
    private int biomeId = -1;
    private float temperature;
    private float humidity;
    private int displayHealthMax = 0;
    private int displayHealth = 0;

    public TileBeehouse() {
        this.setHints((String[])Config.hints.get("apiary"));
        this.logic = PluginApiculture.beeInterface.createBeekeepingLogic(this);
    }

    @Override
    public String func_70303_b() {
        return "apiculture.2";
    }

    @Override
    public void openGui(EntityPlayer player, TileBase tile) {
        player.openGui(ForestryAPI.instance, GuiId.BeehouseGUI.ordinal(), this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    @Override
    public void func_70310_b(NBTTagCompound nbttagcompound) {
        super.func_70310_b(nbttagcompound);
        nbttagcompound.func_74776_a("Temp", this.temperature);
        nbttagcompound.func_74776_a("Humidity", this.humidity);
        nbttagcompound.func_74768_a("BiomeId", this.biomeId);
        this.inventory.writeToNBT(nbttagcompound);
        if (this.logic != null) {
            this.logic.writeToNBT(nbttagcompound);
        }
    }

    @Override
    public void func_70307_a(NBTTagCompound nbttagcompound) {
        super.func_70307_a(nbttagcompound);
        this.temperature = nbttagcompound.func_74760_g("Temp");
        this.humidity = nbttagcompound.func_74760_g("Humidity");
        this.biomeId = nbttagcompound.func_74762_e("BiomeId");
        this.inventory.readFromNBT(nbttagcompound);
        this.logic.readFromNBT(nbttagcompound);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.updateBiome();
    }

    public void func_70312_q() {
        this.updateBiome();
    }

    @Override
    public boolean isClimatized() {
        return true;
    }

    @Override
    public EnumTemperature getTemperature() {
        if (EnumTemperature.isBiomeHellish(this.biomeId)) {
            return EnumTemperature.HELLISH;
        }
        return EnumTemperature.getFromValue(this.temperature);
    }

    @Override
    public EnumHumidity getHumidity() {
        return EnumHumidity.getFromValue(this.humidity);
    }

    @Override
    public float getExactTemperature() {
        return this.temperature;
    }

    @Override
    public float getExactHumidity() {
        return this.humidity;
    }

    @Override
    public void updateClientSide() {
        if (PluginApiculture.beeInterface.isMated(this.inventory.func_70301_a(0)) && this.getErrorState() == EnumErrorCode.OK && this.field_70331_k.func_82737_E() % 2L % 2L == 0L) {
            IBee displayQueen = PluginApiculture.beeInterface.getMember(this.inventory.func_70301_a(0));
            displayQueen.doFX(this.logic.getEffectData(), this);
        }
    }

    @Override
    public void updateServerSide() {
        this.logic.update();
        IBee queen = this.logic.getQueen();
        if (queen == null) {
            return;
        }
        if (this.field_70331_k.func_82737_E() % 200L * 10L == 0L) {
            this.onQueenChange(this.inventory.func_70301_a(0));
        }
        if (this.getErrorState() == EnumErrorCode.OK && this.field_70331_k.func_82737_E() % 2L % 2L == 0L) {
            queen.doFX(this.logic.getEffectData(), this);
        }
        if (this.getErrorState() == EnumErrorCode.OK && this.field_70331_k.func_82737_E() % 50L == 0L) {
            float f = (float)this.field_70329_l + 0.5f;
            float f1 = (float)this.field_70330_m + 0.0f + this.field_70331_k.field_73012_v.nextFloat() * 6.0f / 16.0f;
            float f2 = (float)this.field_70327_n + 0.5f;
            float f3 = 0.52f;
            float f4 = this.field_70331_k.field_73012_v.nextFloat() * 0.6f - 0.3f;
            Proxies.common.addEntitySwarmFX(this.field_70331_k, f - f3, f1, f2 + f4, 0.0f, 0.0f, 0.0f);
            Proxies.common.addEntitySwarmFX(this.field_70331_k, f + f3, f1, f2 + f4, 0.0f, 0.0f, 0.0f);
            Proxies.common.addEntitySwarmFX(this.field_70331_k, f + f4, f1, f2 - f3, 0.0f, 0.0f, 0.0f);
            Proxies.common.addEntitySwarmFX(this.field_70331_k, f + f4, f1, f2 + f3, 0.0f, 0.0f, 0.0f);
        }
    }

    public boolean isWorking() {
        return this.getErrorState() == EnumErrorCode.OK;
    }

    @Override
    public boolean addProduct(ItemStack product, boolean all) {
        return this.inventory.tryAddStack(product, SLOT_PRODUCT_1, SLOT_PRODUCT_COUNT, all, true);
    }

    @Override
    public void onQueenChange(ItemStack queenStack) {
        if (!Proxies.common.isSimulating(this.field_70331_k)) {
            return;
        }
        Proxies.net.sendNetworkPacket(new PacketInventoryStack(3, this.field_70329_l, this.field_70330_m, this.field_70327_n, 0, queenStack), this.field_70329_l, this.field_70330_m, this.field_70327_n);
        Proxies.net.sendNetworkPacket(new PacketTileUpdate(this), this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    private int getHealthDisplay() {
        if (this.inventory.func_70301_a(0) == null) {
            return 0;
        }
        if (this.inventory.func_70301_a((int)0).field_77993_c == ForestryItem.beeQueenGE.field_77779_bT) {
            return PluginApiculture.beeInterface.getMember(this.inventory.func_70301_a(0)).getHealth();
        }
        if (this.inventory.func_70301_a((int)0).field_77993_c == ForestryItem.beePrincessGE.field_77779_bT) {
            return this.displayHealth;
        }
        return 0;
    }

    private int getMaxHealthDisplay() {
        if (this.inventory.func_70301_a(0) == null) {
            return 0;
        }
        if (this.inventory.func_70301_a((int)0).field_77993_c == ForestryItem.beeQueenGE.field_77779_bT) {
            return PluginApiculture.beeInterface.getMember(this.inventory.func_70301_a(0)).getMaxHealth();
        }
        if (this.inventory.func_70301_a((int)0).field_77993_c == ForestryItem.beePrincessGE.field_77779_bT) {
            return this.displayHealthMax;
        }
        return 0;
    }

    public int getHealthScaled(int i) {
        if (this.getMaxHealthDisplay() == 0) {
            return 0;
        }
        return this.getHealthDisplay() * i / this.getMaxHealthDisplay();
    }

    public int getTemperatureScaled(int i) {
        return Math.round((float)i * (this.temperature / 2.0f));
    }

    public int getHumidityScaled(int i) {
        return Math.round((float)i * this.humidity);
    }

    public void updateBiome() {
        BiomeGenBase biome;
        if (this.field_70331_k != null && (biome = Utils.getBiomeAt(this.field_70331_k, this.field_70329_l, this.field_70327_n)) != null) {
            this.biomeId = biome.field_76756_M;
            this.temperature = biome.field_76750_F;
            this.humidity = biome.field_76751_G;
            this.setErrorState(EnumErrorCode.OK);
        }
    }

    public void getGUINetworkData(int i, int j) {
        if (this.logic == null) {
            return;
        }
        switch (i) {
            case 0: {
                this.displayHealth = j;
                break;
            }
            case 1: {
                this.displayHealthMax = j;
            }
        }
    }

    public void sendGUINetworkData(Container container, ICrafting iCrafting) {
        if (this.logic == null) {
            return;
        }
        iCrafting.func_71112_a(container, 0, this.logic.getBreedingTime());
        iCrafting.func_71112_a(container, 1, this.logic.getTotalBreedingTime());
    }

    @Override
    public InventoryAdapter getInternalInventory() {
        return this.inventory;
    }

    public ItemStack func_70301_a(int i) {
        return this.inventory.func_70301_a(i);
    }

    public void setSlotContents(int i, ItemStack itemstack) {
        this.inventory.func_70299_a(i, itemstack);
    }

    @Override
    public int getXCoord() {
        return this.field_70329_l;
    }

    @Override
    public int getYCoord() {
        return this.field_70330_m;
    }

    @Override
    public int getZCoord() {
        return this.field_70327_n;
    }

    @Override
    public int getBiomeId() {
        return this.biomeId;
    }

    @Override
    public ItemStack getQueen() {
        return this.func_70301_a(0);
    }

    @Override
    public ItemStack getDrone() {
        return this.func_70301_a(1);
    }

    @Override
    public void setQueen(ItemStack itemstack) {
        this.setSlotContents(0, itemstack);
    }

    @Override
    public void setDrone(ItemStack itemstack) {
        this.setSlotContents(1, itemstack);
    }

    @Override
    public World getWorld() {
        return this.field_70331_k;
    }

    @Override
    public void setErrorState(int state) {
        this.setErrorState(EnumErrorCode.values()[state]);
    }

    @Override
    public int getErrorOrdinal() {
        return this.getErrorState().ordinal();
    }

    @Override
    public boolean canBreed() {
        return true;
    }

    @Override
    public float getTerritoryModifier(IBeeGenome genome, float currentModifier) {
        return 1.0f;
    }

    @Override
    public float getProductionModifier(IBeeGenome genome, float currentModifier) {
        return 0.25f;
    }

    @Override
    public float getMutationModifier(IBeeGenome genome, IBeeGenome mate, float currentModifier) {
        return 0.0f;
    }

    @Override
    public float getLifespanModifier(IBeeGenome genome, IBeeGenome mate, float currentModifier) {
        return 3.0f;
    }

    @Override
    public float getFloweringModifier(IBeeGenome genome, float currentModifier) {
        return 3.0f;
    }

    @Override
    public float getGeneticDecay(IBeeGenome genome, float currentModifier) {
        return 0.0f;
    }

    @Override
    public void wearOutEquipment(int amount) {
    }

    @Override
    public boolean isSealed() {
        return false;
    }

    @Override
    public boolean isSelfLighted() {
        return false;
    }

    @Override
    public boolean isSunlightSimulated() {
        return false;
    }

    @Override
    public boolean isHellish() {
        return false;
    }

    @Override
    public void onQueenDeath(IBee queen) {
    }

    @Override
    public void onPostQueenDeath(IBee queen) {
    }

    @Override
    public boolean onPollenRetrieved(IBee queen, IIndividual pollen, boolean isHandled) {
        return false;
    }

    @Override
    public boolean onEggLaid(IBee queen) {
        return false;
    }
}

