/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics;

import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.genetics.IEffectData;
import forestry.apiculture.genetics.AlleleEffectThrottled;
import forestry.core.utils.StackUtils;
import forestry.core.utils.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;

public class AlleleEffectResurrection
extends AlleleEffectThrottled {
    private List resurrectables;

    public static List getReanimationList() {
        ArrayList<Resurrectable> list = new ArrayList<Resurrectable>();
        list.add(new Resurrectable(new ItemStack(Item.field_77755_aX), EntitySkeleton.class));
        list.add(new Resurrectable(new ItemStack(Item.field_77704_l), EntitySkeleton.class));
        list.add(new Resurrectable(new ItemStack(Item.field_77737_bm), EntityZombie.class));
        list.add(new Resurrectable(new ItemStack(Item.field_77731_bo), EntityBlaze.class));
        return list;
    }

    public static List getResurrectionList() {
        ArrayList<Resurrectable> list = new ArrayList<Resurrectable>();
        list.add(new Resurrectable(new ItemStack(Item.field_77677_M), EntityCreeper.class));
        list.add(new Resurrectable(new ItemStack(Item.field_77730_bn), EntityEnderman.class));
        list.add(new Resurrectable(new ItemStack(Item.field_77683_K), EntitySpider.class));
        list.add(new Resurrectable(new ItemStack(Item.field_77728_bu), EntitySpider.class));
        list.add(new Resurrectable(new ItemStack(Item.field_77683_K), EntityCaveSpider.class));
        list.add(new Resurrectable(new ItemStack(Item.field_77728_bu), EntityCaveSpider.class));
        list.add(new Resurrectable(new ItemStack(Item.field_77732_bp), EntityGhast.class));
        list.add(new Resurrectable(new ItemStack(Block.field_72084_bK), EntityDragon.class));
        return list;
    }

    public AlleleEffectResurrection(String uid, String name, List resurrectables) {
        super(uid, name, true, 40, true, true);
        this.resurrectables = resurrectables;
    }

    @Override
    public IEffectData doEffect(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
        if (this.isHalted(storedData, housing)) {
            return storedData;
        }
        AxisAlignedBB bounding = this.getBounding(genome, housing, 1.0f);
        List list = housing.getWorld().func_72872_a(EntityItem.class, bounding);
        if (list.size() > 0) {
            Collections.shuffle(this.resurrectables);
        }
        block0: for (Object obj : list) {
            EntityItem item = (EntityItem)obj;
            if (item.field_70128_L) continue;
            ItemStack contained = item.func_92059_d();
            for (Resurrectable entry : this.resurrectables) {
                if (!StackUtils.isIdenticalItem(entry.res, contained)) continue;
                Utils.spawnEntity(housing.getWorld(), entry.risen, item.field_70165_t, item.field_70163_u, item.field_70161_v);
                --contained.field_77994_a;
                if (contained.field_77994_a > 0) continue block0;
                item.func_70106_y();
                continue block0;
            }
        }
        return storedData;
    }

    public static class Resurrectable {
        public final ItemStack res;
        public final Class risen;

        public Resurrectable(ItemStack res, Class risen) {
            this.res = res;
            this.risen = risen;
        }
    }
}

