/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.network;

import forestry.arboriculture.gadgets.TileLeaves;
import forestry.core.network.PacketCoordinates;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class PacketLeafUpdate
extends PacketCoordinates {
    public byte isRipeningUpdate = 0;
    private byte leafState = 0;
    public short textureIndexFancy;
    public short textureIndexPlain;
    public short textureIndexFruit;
    public int colourLeaves;
    public int colourFruits;

    public PacketLeafUpdate() {
    }

    public PacketLeafUpdate(int posX, int posY, int posZ, TileLeaves leaves) {
        super(90, posX, posY, posZ);
        this.leafState = 0;
        if (leaves.hasFruit()) {
            this.leafState = (byte)(this.leafState | 1);
        }
        if (leaves.isPollinated()) {
            this.leafState = (byte)(this.leafState | 2);
        }
        this.textureIndexFancy = leaves.determineTextureIndex(true);
        this.textureIndexPlain = leaves.determineTextureIndex(false);
        this.textureIndexFruit = leaves.determineOverlayIndex();
        this.colourLeaves = leaves.determineFoliageColour();
        this.colourFruits = leaves.determineFruitColour();
    }

    public PacketLeafUpdate(int posX, int posY, int posZ, int fruitColour) {
        super(90, posX, posY, posZ);
        this.isRipeningUpdate = 1;
        this.colourFruits = fruitColour;
    }

    @Override
    public void writeData(DataOutputStream data) throws IOException {
        super.writeData(data);
        data.writeByte(this.isRipeningUpdate);
        if (this.isRipeningUpdate()) {
            data.writeInt(this.colourFruits);
        } else {
            data.writeByte(this.leafState);
            data.writeShort(this.textureIndexFancy);
            data.writeShort(this.textureIndexPlain);
            data.writeShort(this.textureIndexFruit);
            data.writeInt(this.colourLeaves);
            data.writeInt(this.colourFruits);
        }
    }

    @Override
    public void readData(DataInputStream data) throws IOException {
        super.readData(data);
        this.isRipeningUpdate = data.readByte();
        if (this.isRipeningUpdate()) {
            this.colourFruits = data.readInt();
        } else {
            this.leafState = data.readByte();
            this.textureIndexFancy = data.readShort();
            this.textureIndexPlain = data.readShort();
            this.textureIndexFruit = data.readShort();
            this.colourLeaves = data.readInt();
            this.colourFruits = data.readInt();
        }
    }

    public boolean isRipeningUpdate() {
        return this.isRipeningUpdate != 0;
    }

    public boolean isFruitLeaf() {
        return (this.leafState & 1) > 0;
    }

    public boolean isPollinated() {
        return (this.leafState & 2) > 0;
    }
}

