/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import forestry.api.world.ITreeGenData;
import forestry.arboriculture.gadgets.TileSapling;
import forestry.arboriculture.worldgen.BlockTypeVoid;
import forestry.core.config.Config;
import forestry.core.utils.Utils;
import forestry.core.utils.Vect;
import forestry.core.worldgen.BlockType;
import forestry.core.worldgen.WorldGenBase;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public abstract class WorldGenArboriculture
extends WorldGenBase {
    protected ITreeGenData tree;
    protected int startX;
    protected int startY;
    protected int startZ;
    protected boolean spawnPods = false;
    protected int minPodHeight = 3;
    BlockType leaf;
    BlockType wood;
    BlockType vine;
    BlockType air;

    public WorldGenArboriculture(ITreeGenData tree) {
        this.vine = new BlockType(Block.field_71998_bu.field_71990_ca, 0);
        this.air = new BlockTypeVoid();
        this.tree = tree;
    }

    @Override
    public boolean func_76484_a(World world, Random random, int x, int y, int z) {
        super.func_76484_a(world, random, x, y, z);
        this.startX = x;
        this.startY = y;
        this.startZ = z;
        this.spawnPods = this.tree.allowsFruitBlocks();
        this.leaf = this.getLeaf(this.getOwner());
        this.wood = this.getWood();
        this.preGenerate();
        if (!this.canGrow()) {
            return false;
        }
        this.generate();
        return true;
    }

    private String getOwner() {
        TileEntity tile = this.world.func_72796_p(this.startX, this.startY, this.startZ);
        if (!(tile instanceof TileSapling)) {
            return Config.fakeUserLogin;
        }
        return ((TileSapling)tile).getOwnerName();
    }

    public abstract void preGenerate();

    public abstract void generate();

    public abstract boolean canGrow();

    public abstract BlockType getLeaf(String var1);

    public abstract BlockType getWood();

    public final Vect getStartVector() {
        return new Vect(this.startX, this.startY, this.startZ);
    }

    protected void generateTreeTrunk(int height, int girth) {
        this.generateTreeTrunk(height, girth, 0.0f);
    }

    protected void generateTreeTrunk(int height, int girth, float vines) {
        int offset = (girth - 1) / 2;
        for (int x = 0; x < girth; ++x) {
            for (int y = 0; y < girth; ++y) {
                for (int i = 0; i < height; ++i) {
                    this.addWood(x - offset, i, y - offset, WorldGenBase.EnumReplaceMode.ALL);
                    if (this.rand.nextFloat() < vines) {
                        this.addVine(x - offset - 1, i, y - offset);
                    }
                    if (this.rand.nextFloat() < vines) {
                        this.addVine(x - offset + 1, i, y - offset);
                    }
                    if (this.rand.nextFloat() < vines) {
                        this.addVine(x - offset, i, y - offset - 1);
                    }
                    if (!(this.rand.nextFloat() < vines)) continue;
                    this.addVine(x - offset, i, y - offset + 1);
                }
            }
        }
        if (!this.spawnPods) {
            return;
        }
        for (int y = this.minPodHeight; y < height; ++y) {
            for (int x = 0; x < girth; ++x) {
                for (int z = 0; z < girth; ++z) {
                    if (x > 0 && x < girth && z > 0 && z < girth) continue;
                    this.tree.trySpawnFruitBlock(this.world, this.startX + x + 1, this.startY + y, this.startZ + z);
                    this.tree.trySpawnFruitBlock(this.world, this.startX + x - 1, this.startY + y, this.startZ + z);
                    this.tree.trySpawnFruitBlock(this.world, this.startX + x, this.startY + y, this.startZ + z + 1);
                    this.tree.trySpawnFruitBlock(this.world, this.startX + x, this.startY + y, this.startZ + z - 1);
                }
            }
        }
    }

    protected void generateSupportStems(int height, int girth, float chance, float maxHeight) {
        int offset = 1;
        for (int x = -offset; x < girth + offset; ++x) {
            for (int z = -offset; z < girth + offset; ++z) {
                if (x == -offset && z == -offset || x == girth + offset && z == girth + offset || x == -offset && z == girth + offset || x == girth + offset && z == -offset) continue;
                int stemHeight = this.rand.nextInt(Math.round((float)height * maxHeight));
                if (!(this.rand.nextFloat() < chance)) continue;
                for (int i = 0; i < stemHeight; ++i) {
                    this.addWood(x, i, z, WorldGenBase.EnumReplaceMode.SOFT);
                }
            }
        }
    }

    @Override
    protected void addBlock(int x, int y, int z, BlockType type, WorldGenBase.EnumReplaceMode replace) {
        if (replace == WorldGenBase.EnumReplaceMode.ALL || replace == WorldGenBase.EnumReplaceMode.SOFT && Utils.isReplaceableBlock(this.world, this.startX + x, this.startY + y, this.startZ + z) || this.world.func_72799_c(this.startX + x, this.startY + y, this.startZ + z)) {
            type.setBlock(this.world, this.tree, this.startX + x, this.startY + y, this.startZ + z);
        }
    }

    protected final void clearBlock(int x, int y, int z) {
        this.air.setBlock(this.world, this.tree, this.startX + x, this.startY + y, this.startZ + z);
    }

    protected final void addWood(int x, int y, int z, WorldGenBase.EnumReplaceMode replace) {
        this.addBlock(x, y, z, this.wood, replace);
    }

    protected final void addLeaf(int x, int y, int z, WorldGenBase.EnumReplaceMode replace) {
        this.addBlock(x, y, z, this.leaf, replace);
    }

    protected final void addVine(int x, int y, int z) {
        this.addBlock(x, y, z, this.vine, WorldGenBase.EnumReplaceMode.NONE);
    }
}

