/*
 * Decompiled with CFR 0.152.
 */
package forestry.core;

import forestry.api.core.IPlugin;
import forestry.api.core.PluginInfo;
import forestry.core.config.Version;
import forestry.core.proxy.Proxies;
import forestry.core.utils.CommandMC;
import forestry.plugins.PluginManager;
import java.util.List;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;

public class CommandForestry
extends CommandMC {
    public int compareTo(Object arg0) {
        return this.func_71517_b().compareTo(((ICommand)arg0).func_71517_b());
    }

    public String func_71517_b() {
        return "forestry";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/" + this.func_71517_b() + " help";
    }

    public List func_71514_a() {
        return null;
    }

    public void func_71515_b(ICommandSender sender, String[] arguments) {
        if (arguments.length <= 0) {
            throw new WrongUsageException("Type '" + this.func_71518_a(sender) + "' for help.", new Object[0]);
        }
        if (arguments[0].matches("version")) {
            this.commandVersion(sender, arguments);
            return;
        }
        if (arguments[0].matches("plugins")) {
            this.commandPlugins(sender, arguments);
            return;
        }
        if (arguments[0].matches("help")) {
            this.sendChatMessage(sender, "Format: '" + this.func_71517_b() + " <command> <arguments>'");
            this.sendChatMessage(sender, "Available commands:");
            this.sendChatMessage(sender, "- version : Version information.");
            this.sendChatMessage(sender, "- plugins : list of Forestry plugins.");
            this.sendChatMessage(sender, "- plugins info <plugin-name>: information on plugin.");
            return;
        }
        throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
    }

    private void commandVersion(ICommandSender sender, String[] arguments) {
        String colour = Version.isOutdated() ? "\u00a7c" : "\u00a7a";
        this.sendChatMessage(sender, String.format(colour + "Forestry %s for Minecraft %s (Latest: %s).", Version.getVersion(), Proxies.common.getMinecraftVersion(), Version.getRecommendedVersion()));
        if (Version.isOutdated()) {
            for (String updateLine : Version.getChangelog()) {
                this.sendChatMessage(sender, "\u00a79" + updateLine);
            }
        }
    }

    private void commandPlugins(ICommandSender sender, String[] arguments) {
        if (arguments.length <= 1) {
            this.listPluginsForSender(sender);
        } else if (arguments[1].matches("info")) {
            this.listPluginInfoForSender(sender, arguments);
        }
    }

    private void listPluginsForSender(ICommandSender sender) {
        String pluginList = "";
        for (IPlugin plugin : PluginManager.plugins) {
            if (!pluginList.isEmpty()) {
                pluginList = pluginList + ", ";
            }
            pluginList = pluginList + this.makeListEntry(plugin);
        }
        this.sendChatMessage(sender, pluginList);
    }

    private void listPluginInfoForSender(ICommandSender sender, String[] arguments) {
        PluginInfo info;
        if (arguments.length < 3) {
            throw new WrongUsageException("/" + this.func_71517_b() + " plugins info <plugin-name>", new Object[0]);
        }
        IPlugin found = null;
        for (IPlugin plugin : PluginManager.plugins) {
            PluginInfo info2 = plugin.getClass().getAnnotation(PluginInfo.class);
            if (info2 == null || !info2.pluginID().equalsIgnoreCase(arguments[2]) && !info2.name().equalsIgnoreCase(arguments[2])) continue;
            found = plugin;
            break;
        }
        if (found == null) {
            throw new CommandException("No information available for plugin " + arguments[2] + ".", new Object[0]);
        }
        String entry = "\u00a7c";
        if (found.isAvailable()) {
            entry = "\u00a7a";
        }
        if ((info = found.getClass().getAnnotation(PluginInfo.class)) != null) {
            this.sendChatMessage(sender, entry + "Plugin: " + info.name());
            if (!info.version().isEmpty()) {
                this.sendChatMessage(sender, "\u00a79Version: " + info.version());
            }
            if (!info.author().isEmpty()) {
                this.sendChatMessage(sender, "\u00a79Author(s): " + info.author());
            }
            if (!info.url().isEmpty()) {
                this.sendChatMessage(sender, "\u00a79URL: " + info.url());
            }
            if (!info.description().isEmpty()) {
                this.sendChatMessage(sender, info.description());
            }
        }
    }

    private String makeListEntry(IPlugin plugin) {
        PluginInfo info;
        String entry = "\u00a7c";
        if (plugin.isAvailable()) {
            entry = "\u00a7a";
        }
        if ((info = plugin.getClass().getAnnotation(PluginInfo.class)) != null) {
            entry = entry + info.pluginID();
            if (!info.version().isEmpty()) {
                entry = entry + " (" + info.version() + ")";
            }
        } else {
            entry = entry + "???";
        }
        return entry;
    }

    public boolean func_71519_b(ICommandSender sender) {
        if (sender instanceof EntityPlayer) {
            return Proxies.common.isOp((EntityPlayer)sender);
        }
        return sender.func_70003_b(4, this.func_71517_b());
    }
}

