/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.config;

import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.core.GlobalManager;
import forestry.core.config.Configuration;
import forestry.core.config.Property;
import forestry.core.proxy.Proxies;
import forestry.core.triggers.ForestryTrigger;
import forestry.core.utils.Localization;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Properties;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;

public class Config {
    public static final String CATEGORY_COMMON = "common";
    public static net.minecraftforge.common.Configuration idConfig;
    public static Configuration config;
    public static String gameMode;
    public static HashSet disabledStructures;
    public static boolean isDebug;
    public static boolean disableApiculture;
    public static boolean disableArboriculture;
    public static boolean disableCultivation;
    public static boolean disableEnergy;
    public static boolean disableFactory;
    public static boolean disableFarming;
    public static boolean disableFood;
    public static boolean disableMail;
    public static boolean disableStorage;
    public static boolean disablePermissions;
    public static boolean disableNags;
    public static boolean disableVersionCheck;
    public static boolean invalidFingerprint;
    public static boolean enableParticleFX;
    public static boolean clearInvalidChromosomes;
    public static boolean dungeonLootRare;
    public static boolean generateApatiteOre;
    public static boolean generateCopperOre;
    public static boolean generateTinOre;
    public static boolean generateBeehives;
    public static boolean generateBogEarth;
    public static boolean enableBackpackResupply;
    public static int planterThrottle;
    public static int harvesterThrottle;
    public static boolean tooltipLiquidAmount;
    public static boolean planterSideSensitive;
    public static boolean harvesterSideSensitive;
    private static boolean craftingBronzeEnabled;
    public static boolean craftingStampsEnabled;
    public static ArrayList collectorStamps;
    public static boolean applePickup;
    public static boolean squareFarms;
    public static boolean mailAlertEnabled;
    public static String fakeUserLogin;
    public static boolean fakeUserAutoop;
    public static boolean disableHints;
    public static HashMap hints;
    public static boolean disableEnergyStat;

    public static boolean getCraftingBronzeEnabled() {
        return craftingBronzeEnabled;
    }

    public static void load() {
        File hardMode;
        File normalMode;
        File opMode;
        Config.setDebugMode();
        idConfig = new net.minecraftforge.common.Configuration(new File(Proxies.common.getForestryRoot(), "config/forestry/base.conf"));
        idConfig.load();
        config = new Configuration();
        config.addPurge("buildcraft.blockid.engine");
        config.addPurge("buildcraft.blockid.pipe");
        config.addPurge("crafting.farms.enabled");
        config.addPurge("crafting.farms.uncrafting.enabled");
        config.addPurge("performance.planter");
        config.addPurge("performance.harvester");
        config.addPurge("buildcraft.ignore");
        config.addPurge("power.framework");
        Property property = config.get("difficulty.gamemode", CATEGORY_COMMON, "EASY");
        property.Comment = "set to your preferred game mode. available modes are OP, EASY, NORMAL, HARD. mismatch with the server may cause visual glitches with recipes. setting an unavailable mode will create a new mode definition file.";
        gameMode = property.Value;
        property = config.get("difficulty.recreate.definitions", CATEGORY_COMMON, true);
        property.Comment = "set to true to force recreation of the game mode definitions in config/forestry/gamemodes";
        boolean recreate = Boolean.parseBoolean(property.Value);
        if (recreate) {
            Proxies.log.info("Recreating all gamemode definitions from the defaults. This may be caused by an upgrade");
        }
        File easyMode = config.getCategoryFile("gamemodes/EASY");
        if (recreate) {
            Config.CopyFileToFS(easyMode, "/config/forestry/gamemodes/EASY.conf");
        }
        if (!(opMode = config.getCategoryFile("gamemodes/OP")).exists() || recreate) {
            Config.CopyFileToFS(opMode, "/config/forestry/gamemodes/OP.conf");
        }
        if (!(normalMode = config.getCategoryFile("gamemodes/NORMAL")).exists() || recreate) {
            Config.CopyFileToFS(normalMode, "/config/forestry/gamemodes/NORMAL.conf");
        }
        if (!(hardMode = config.getCategoryFile("gamemodes/HARD")).exists() || recreate) {
            Config.CopyFileToFS(hardMode, "/config/forestry/gamemodes/HARD.conf");
        }
        config.set("difficulty.recreate.definitions", CATEGORY_COMMON, false);
        Property particleFX = config.get("performance.particleFX.enabled", CATEGORY_COMMON, true);
        particleFX.Comment = "set to false to disable particle fx on slower machines";
        enableParticleFX = Boolean.parseBoolean(particleFX.Value);
        Property genApatiteOre = config.get("world.generate.apatite", CATEGORY_COMMON, true);
        genApatiteOre.Comment = "set to false to force forestry to skip generating own apatite ore blocks in the world";
        generateApatiteOre = Boolean.parseBoolean(genApatiteOre.Value);
        Property genBeehives = config.get("world.generate.beehives", CATEGORY_COMMON, true);
        genBeehives.Comment = "set to false to force forestry to skip generating beehives in the world";
        generateBeehives = Boolean.parseBoolean(genBeehives.Value);
        Property genCopperOre = config.get("world.generate.copper", CATEGORY_COMMON, true);
        genCopperOre.Comment = "set to false to force forestry to skip generating own copper ore blocks in the world";
        generateCopperOre = Boolean.parseBoolean(genCopperOre.Value);
        Property genTinOre = config.get("world.generate.tin", CATEGORY_COMMON, true);
        genTinOre.Comment = "set to false to force forestry to skip generating own tin ore blocks in the world";
        generateTinOre = Boolean.parseBoolean(genTinOre.Value);
        Property planterSideSense = config.get("planters.sidesensitive", CATEGORY_COMMON, true);
        planterSideSense.Comment = "set to false if farms should output all harvested products regardless of side a pipe is attached to";
        planterSideSensitive = Boolean.parseBoolean(planterSideSense.Value);
        Property harvesterSideSense = config.get("harvesters.sidesensitive", CATEGORY_COMMON, true);
        harvesterSideSense.Comment = "set to false if harvesters should output all harvested products regardless of side a pipe is attached to";
        harvesterSideSensitive = Boolean.parseBoolean(harvesterSideSense.Value);
        Property bronzeRecipe = config.get("crafting.bronze.enabled", CATEGORY_COMMON, true);
        bronzeRecipe.Comment = "set to false to disable crafting recipe for bronze";
        craftingBronzeEnabled = Boolean.parseBoolean(bronzeRecipe.Value);
        property = config.get("crafting.stamps.enabled", CATEGORY_COMMON, true);
        property.Comment = "set to false to disable crafting recipes for all types of stamps.";
        craftingStampsEnabled = Boolean.parseBoolean(property.Value);
        String defaultCollectors = "20n;50n;100n;200n";
        property = config.get("crafting.stamps.collector", CATEGORY_COMMON, defaultCollectors);
        property.Comment = "if crafting of stamps is generally allowed, these stamps are still excluded from crafting.";
        try {
            collectorStamps.addAll(Arrays.asList(Config.parseStamps(property.Value)));
        }
        catch (Exception ex) {
            config.set("crafting.stamps.collector", CATEGORY_COMMON, defaultCollectors);
            collectorStamps.addAll(Arrays.asList(Config.parseStamps(defaultCollectors)));
        }
        Property indicatorEnable = config.get("tweaks.mailalert.enabled", CATEGORY_COMMON, true);
        indicatorEnable.Comment = "set to false to disable the mail alert box";
        mailAlertEnabled = Boolean.parseBoolean(indicatorEnable.Value);
        Property appleHarvest = config.get("tweaks.apple.pickup.enabled", CATEGORY_COMMON, true);
        appleHarvest.Comment = "set to false to disable apple pickup by appropriate harvesters";
        applePickup = Boolean.parseBoolean(appleHarvest.Value);
        Property clearGenome = config.get("genetics.clear.invalid.chromosomes", CATEGORY_COMMON, clearInvalidChromosomes);
        clearGenome.Comment = "NEW: set to true to clear chromosomes which contain invalid alleles. might rescue your save if it is crashing after removal of a bee addon.";
        clearInvalidChromosomes = Boolean.parseBoolean(clearGenome.Value);
        Property dungeonLootRarity = config.get("difficulty.dungeonloot.rare", CATEGORY_COMMON, false);
        dungeonLootRarity.Comment = "set to true to make dungeon loot generated by forestry rarer";
        dungeonLootRare = Boolean.parseBoolean(dungeonLootRarity.Value);
        Property resupplyEnable = config.get("performance.backpacks.resupply", CATEGORY_COMMON, true);
        resupplyEnable.Comment = "leaving this enabled will cycle the list of active players PER INGAME TICK to check for resupply via backpack. you want to set this to false on busy servers.";
        enableBackpackResupply = Boolean.parseBoolean(resupplyEnable.Value);
        property = config.get("tweaks.hints.disabled", CATEGORY_COMMON, false);
        property.Comment = "set to true to disable hints on machine and engine guis.";
        disableHints = Boolean.parseBoolean(property.Value);
        property = config.get("tweaks.energystat.disabled", CATEGORY_COMMON, true);
        property.Comment = "set to true to disable energy statistics on energy consumers.";
        disableEnergyStat = !isDebug && Boolean.parseBoolean(property.Value);
        property = config.get("tweaks.tooltip.liquidamount.disabled", CATEGORY_COMMON, true);
        property.Comment = "set to true to disable displaying liquid amounts in tank tooltips.";
        tooltipLiquidAmount = isDebug || !Boolean.parseBoolean(property.Value);
        property = config.get("tweaks.permissions.disabled", CATEGORY_COMMON, false);
        property.Comment = "set to true to disable access restrictions on forestry machines.";
        disablePermissions = Boolean.parseBoolean(property.Value);
        property = config.get("tweaks.nags.disabled", CATEGORY_COMMON, false);
        property.Comment = "set to true to disable some nagging and warnings (e.g. GregTech).";
        disableNags = Boolean.parseBoolean(property.Value);
        property = config.get("tweaks.upgradenotice.disabled", CATEGORY_COMMON, false);
        property.Comment = "set to true to disable update and version check notice.";
        disableVersionCheck = isDebug || Boolean.parseBoolean(property.Value);
        property = config.get("tweaks.farms.squared", CATEGORY_COMMON, false);
        property.Comment = "set to true to have farms use a square layout instead of a diamond one.";
        squareFarms = Boolean.parseBoolean(property.Value);
        property = config.get("structures.schemata.disabled", CATEGORY_COMMON, "");
        property.Comment = "add schemata keys to disable them. current keys: alveary3x3;farm3x3;farm3x4;farm3x5;farm4x4;farm5x5";
        disabledStructures.addAll(Arrays.asList(Config.parseStructureKeys(property.Value)));
        for (String str : disabledStructures) {
            Proxies.log.finer("Disabled structure '%s'.", (Object)str);
        }
        property = config.get("permissions.login", CATEGORY_COMMON, "[Forestry]");
        property.Comment = "set the default login used by Forestry.";
        fakeUserLogin = property.Value;
        property = config.get("permissions.autoop", CATEGORY_COMMON, true);
        property.Comment = "set to false to prevent Forestry's user from autooping.";
        fakeUserAutoop = Boolean.parseBoolean(property.Value);
        Config.registerClimates();
        ForestryTrigger.initialize();
        GlobalManager.leafBlockIds.add(Block.field_71952_K.field_71990_ca);
        GlobalManager.dirtBlockIds.add(Block.field_71979_v.field_71990_ca);
        GlobalManager.dirtBlockIds.add(Block.field_71980_u.field_71990_ca);
        GlobalManager.sandBlockIds.add(Block.field_71939_E.field_71990_ca);
        GlobalManager.snowBlockIds.add(Block.field_72037_aS.field_71990_ca);
        config.save();
        idConfig.save();
        Config.loadHints();
    }

    private static void setDebugMode() {
        File debug = new File(Proxies.common.getForestryRoot(), "config/" + "Forestry".toLowerCase(Locale.ENGLISH) + "/DEBUG.ON");
        isDebug = debug.exists();
    }

    private static void CopyFileToFS(File destination, String resourcePath) {
        InputStream stream = Config.class.getResourceAsStream(resourcePath);
        byte[] buffer = new byte[4096];
        try {
            int readBytes;
            if (destination.getParentFile() != null) {
                destination.getParentFile().mkdirs();
            }
            if (!destination.exists() && !destination.createNewFile()) {
                return;
            }
            FileOutputStream outstream = new FileOutputStream(destination);
            while ((readBytes = stream.read(buffer)) > 0) {
                ((OutputStream)outstream).write(buffer, 0, readBytes);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void loadHints() {
        Properties prop = new Properties();
        try {
            InputStream hintStream = Localization.class.getResourceAsStream("/config/forestry/hints.properties");
            prop.load(hintStream);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        for (String key : prop.stringPropertyNames()) {
            hints.put(key, Config.parseHints(prop.getProperty(key)));
        }
    }

    private static String[] parseHints(String list) {
        if (list.isEmpty()) {
            return new String[0];
        }
        return list.split("[;]+");
    }

    private static String[] parseStructureKeys(String list) {
        if (list.isEmpty()) {
            return new String[0];
        }
        return list.split("[;]+");
    }

    private static String[] parseStamps(String list) {
        if (list.isEmpty()) {
            return new String[0];
        }
        return list.split("[;]+");
    }

    private static void registerClimates() {
        for (BiomeGenBase biome : BiomeGenBase.field_76773_a) {
            if (biome == null) continue;
            if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.NETHER)) {
                EnumTemperature.hellishBiomeIds.add(biome.field_76756_M);
                continue;
            }
            if (biome.field_76750_F >= 2.0f) {
                EnumTemperature.hotBiomeIds.add(biome.field_76756_M);
                continue;
            }
            if (biome.field_76750_F >= 1.2f) {
                EnumTemperature.warmBiomeIds.add(biome.field_76756_M);
                continue;
            }
            if (biome.field_76750_F >= 0.2f) {
                EnumTemperature.normalBiomeIds.add(biome.field_76756_M);
                continue;
            }
            if (biome.field_76750_F >= 0.15f) {
                EnumTemperature.coldBiomeIds.add(biome.field_76756_M);
                continue;
            }
            EnumTemperature.icyBiomeIds.add(biome.field_76756_M);
        }
        for (BiomeGenBase biome : BiomeGenBase.field_76773_a) {
            if (biome == null) continue;
            if (biome.field_76751_G >= 0.9f) {
                EnumHumidity.dampBiomeIds.add(biome.field_76756_M);
                continue;
            }
            if (biome.field_76751_G >= 0.3f) {
                EnumHumidity.normalBiomeIds.add(biome.field_76756_M);
                continue;
            }
            EnumHumidity.aridBiomeIds.add(biome.field_76756_M);
        }
    }

    public static int getOrCreateBlockIdProperty(String key, int defaultId) {
        int blockid = idConfig.getBlock(key, defaultId).getInt(defaultId);
        idConfig.save();
        return blockid;
    }

    public static int getOrCreateItemIdProperty(String key, int defaultId) {
        int itemid = idConfig.getItem(key, defaultId).getInt(defaultId);
        idConfig.save();
        if (Item.field_77698_e[itemid + 256] != null) {
            throw new RuntimeException(String.format("Tried to recreate an item id (%s / shifted:%s) for an item which already exists as %s. Check your config and resolve the conflict.", itemid, itemid + 256, Item.field_77698_e[itemid + 256].toString()));
        }
        return itemid;
    }

    public static boolean getOrCreateBooleanProperty(String key, String kind, boolean defaults) {
        return Boolean.parseBoolean(Config.config.get((String)key, (String)kind, (boolean)defaults).Value);
    }

    static {
        disabledStructures = new HashSet();
        isDebug = false;
        disableApiculture = false;
        disableArboriculture = false;
        disableCultivation = false;
        disableEnergy = false;
        disableFactory = false;
        disableFarming = false;
        disableFood = false;
        disableMail = false;
        disableStorage = false;
        disablePermissions = false;
        disableNags = false;
        disableVersionCheck = false;
        invalidFingerprint = false;
        enableParticleFX = true;
        clearInvalidChromosomes = false;
        dungeonLootRare = false;
        generateApatiteOre = true;
        generateCopperOre = true;
        generateTinOre = true;
        generateBeehives = true;
        generateBogEarth = false;
        enableBackpackResupply = true;
        tooltipLiquidAmount = false;
        planterSideSensitive = true;
        harvesterSideSensitive = true;
        craftingBronzeEnabled = true;
        craftingStampsEnabled = true;
        collectorStamps = new ArrayList();
        applePickup = true;
        squareFarms = false;
        mailAlertEnabled = true;
        fakeUserLogin = "[Forestry]";
        fakeUserAutoop = true;
        disableHints = false;
        hints = new HashMap();
        disableEnergyStat = false;
    }
}

