/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.network;

import cpw.mods.fml.common.network.IPacketHandler;
import cpw.mods.fml.common.network.Player;
import forestry.api.core.ForestryEvent;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IBreedingTracker;
import forestry.api.genetics.ISpeciesRoot;
import forestry.core.circuits.ItemCircuitBoard;
import forestry.core.gadgets.TileForestry;
import forestry.core.gui.ContainerForestry;
import forestry.core.gui.ContainerLiquidTanks;
import forestry.core.gui.ContainerSocketed;
import forestry.core.gui.IGuiSelectable;
import forestry.core.interfaces.ISocketable;
import forestry.core.network.ForestryPacket;
import forestry.core.network.ILocatedPacket;
import forestry.core.network.INetworkedEntity;
import forestry.core.network.PacketCoordinates;
import forestry.core.network.PacketFXSignal;
import forestry.core.network.PacketInventoryStack;
import forestry.core.network.PacketNBT;
import forestry.core.network.PacketSocketUpdate;
import forestry.core.network.PacketTankUpdate;
import forestry.core.network.PacketTileNBT;
import forestry.core.network.PacketTileUpdate;
import forestry.core.network.PacketUpdate;
import forestry.core.proxy.Proxies;
import forestry.plugins.PluginManager;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;

public class PacketHandler
implements IPacketHandler {
    public void onPacketData(INetworkManager network, Packet250CustomPayload packet, Player player) {
        DataInputStream data = new DataInputStream(new ByteArrayInputStream(packet.field_73629_c));
        try {
            byte packetId = data.readByte();
            switch (packetId) {
                case 0: {
                    PacketTileUpdate packetT = new PacketTileUpdate();
                    packetT.readData(data);
                    this.onTileUpdate(packetT);
                    break;
                }
                case 1: {
                    PacketUpdate packetUpdate = new PacketUpdate();
                    packetUpdate.readData(data);
                    this.onTileUpdate(packetUpdate);
                    break;
                }
                case 5: {
                    PacketTileNBT packetN = new PacketTileNBT();
                    packetN.readData(data);
                    this.onTileUpdate(packetN);
                    break;
                }
                case 72: {
                    PacketSocketUpdate packetS = new PacketSocketUpdate();
                    packetS.readData(data);
                    this.onSocketUpdate(packetS);
                    break;
                }
                case 3: {
                    PacketInventoryStack packetQ = new PacketInventoryStack();
                    packetQ.readData(data);
                    this.onInventoryStack(packetQ);
                    break;
                }
                case 4: {
                    PacketFXSignal packetF = new PacketFXSignal();
                    packetF.readData(data);
                    packetF.executeFX();
                    break;
                }
                case 40: {
                    PacketUpdate packetU = new PacketUpdate();
                    packetU.readData(data);
                    this.onPipetteClick(packetU, (EntityPlayer)player);
                    break;
                }
                case 71: {
                    PacketUpdate packetU = new PacketUpdate();
                    packetU.readData(data);
                    this.onSolderingIronClick(packetU, (EntityPlayer)player);
                    break;
                }
                case 70: {
                    PacketUpdate packetU = new PacketUpdate();
                    packetU.readData(data);
                    this.onChipsetClick(packetU, (EntityPlayer)player);
                    break;
                }
                case 50: {
                    PacketCoordinates packetC = new PacketCoordinates();
                    packetC.readData(data);
                    this.onAccessSwitch(packetC, (EntityPlayer)player);
                    break;
                }
                case 32: {
                    PacketUpdate packetI = new PacketUpdate();
                    packetI.readData(data);
                    this.onGuiSelection((EntityPlayer)player, packetI);
                    break;
                }
                case 30: {
                    PacketUpdate packetZ = new PacketUpdate();
                    packetZ.readData(data);
                    this.onGuiChange((EntityPlayer)player, packetZ);
                    break;
                }
                case 60: {
                    PacketNBT packetTR = new PacketNBT();
                    packetTR.readData(data);
                    this.onGenomeTrackerUpdate((EntityPlayer)player, packetTR);
                    break;
                }
                case 91: {
                    PacketTankUpdate packetAB = new PacketTankUpdate();
                    packetAB.readData(data);
                    this.onTankUpdate((EntityPlayer)player, packetAB);
                    break;
                }
                default: {
                    for (forestry.core.interfaces.IPacketHandler handler : PluginManager.packetHandlers) {
                        handler.onPacketData(network, packetId, data, player);
                    }
                    break;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void onTankUpdate(EntityPlayer player, PacketTankUpdate packetAB) {
        if (player.field_71070_bA instanceof ContainerForestry) {
            ((ContainerForestry)player.field_71070_bA).onTankUpdate(packetAB.nbttagcompound);
        }
    }

    private void onGenomeTrackerUpdate(EntityPlayer player, PacketNBT packet) {
        IBreedingTracker tracker = null;
        String type = packet.getTagCompound().func_74779_i("TYPE");
        ISpeciesRoot root = AlleleManager.alleleRegistry.getSpeciesRoot(type);
        if (root != null) {
            tracker = root.getBreedingTracker(Proxies.common.getRenderWorld(), player.field_71092_bJ);
        }
        if (tracker != null) {
            tracker.decodeFromNBT(packet.getTagCompound());
            MinecraftForge.EVENT_BUS.post((Event)new ForestryEvent.SyncedBreedingTracker(tracker, player));
        }
    }

    private void onGuiChange(EntityPlayer player, PacketUpdate packet) {
        if (!(player.field_71070_bA instanceof IGuiSelectable)) {
            return;
        }
        ((IGuiSelectable)player.field_71070_bA).handleSelectionChange(player, packet);
    }

    private void onGuiSelection(EntityPlayer player, PacketUpdate packet) {
        Container container = player.field_71070_bA;
        if (!(container instanceof IGuiSelectable)) {
            return;
        }
        ((IGuiSelectable)container).setSelection(packet);
    }

    private void onSocketUpdate(PacketSocketUpdate packet) {
        TileEntity tile = Proxies.common.getRenderWorld().func_72796_p(packet.posX, packet.posY, packet.posZ);
        if (!(tile instanceof ISocketable)) {
            return;
        }
        ISocketable socketable = (ISocketable)tile;
        for (int i = 0; i < packet.itemstacks.length; ++i) {
            socketable.setSocket(i, packet.itemstacks[i]);
        }
    }

    private void onTileUpdate(ForestryPacket packet) {
        TileEntity tile = ((ILocatedPacket)((Object)packet)).getTarget(Proxies.common.getRenderWorld());
        if (tile instanceof INetworkedEntity) {
            ((INetworkedEntity)tile).fromPacket(packet);
        }
    }

    private void onInventoryStack(PacketInventoryStack packet) {
        TileEntity tile = Proxies.common.getRenderWorld().func_72796_p(packet.posX, packet.posY, packet.posZ);
        if (tile == null) {
            return;
        }
        if (!(tile instanceof IInventory)) {
            return;
        }
        ((IInventory)tile).func_70299_a(packet.slotIndex, packet.itemstack);
    }

    private void onChipsetClick(PacketUpdate packet, EntityPlayer player) {
        if (!(player.field_71070_bA instanceof ContainerSocketed)) {
            return;
        }
        ItemStack itemstack = player.field_71071_by.func_70445_o();
        if (!(itemstack.func_77973_b() instanceof ItemCircuitBoard)) {
            return;
        }
        ((ContainerSocketed)player.field_71070_bA).handleChipsetClick(packet.payload.intPayload[0], player, itemstack);
    }

    private void onSolderingIronClick(PacketUpdate packet, EntityPlayer player) {
        if (!(player.field_71070_bA instanceof ContainerSocketed)) {
            return;
        }
        ItemStack itemstack = player.field_71071_by.func_70445_o();
        ((ContainerSocketed)player.field_71070_bA).handleSolderingIronClick(packet.payload.intPayload[0], player, itemstack);
    }

    private void onAccessSwitch(PacketCoordinates packet, EntityPlayer playerEntity) {
        TileForestry tile = (TileForestry)playerEntity.field_70170_p.func_72796_p(packet.posX, packet.posY, packet.posZ);
        if (tile == null) {
            return;
        }
        tile.switchAccessRule(playerEntity);
    }

    private void onPipetteClick(PacketUpdate packet, EntityPlayer player) {
        if (!(player.field_71070_bA instanceof ContainerLiquidTanks)) {
            return;
        }
        ((ContainerLiquidTanks)player.field_71070_bA).handlePipetteClick(packet.payload.intPayload[0], player);
    }
}

