/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import forestry.core.gadgets.TileForestry;
import forestry.core.utils.InventoryAdapter;
import forestry.core.utils.LiquidHelper;
import forestry.core.utils.TankSlot;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.oredict.OreDictionary;

public class StackUtils {
    public static final ItemStack[] EMPTY_STACK_ARRAY = new ItemStack[0];
    public static final ArrayList EMPTY_STACK_LIST = new ArrayList();

    public static boolean isIdenticalItem(ItemStack lhs, ItemStack rhs) {
        if (lhs == null || rhs == null) {
            return false;
        }
        if (lhs.field_77993_c != rhs.field_77993_c) {
            return false;
        }
        if (lhs.func_77960_j() != Short.MAX_VALUE && lhs.func_77960_j() != rhs.func_77960_j()) {
            return false;
        }
        return ItemStack.func_77970_a((ItemStack)lhs, (ItemStack)rhs);
    }

    public static boolean stowInInventory(ItemStack itemstack, IInventory inventory, boolean doAdd) {
        return StackUtils.stowInInventory(itemstack, inventory, doAdd, 0, inventory.func_70302_i_());
    }

    public static boolean stowInInventory(ItemStack itemstack, IInventory inventory, boolean doAdd, int slot1, int count) {
        boolean added = false;
        for (int i = slot1; i < slot1 + count; ++i) {
            ItemStack inventoryStack = inventory.func_70301_a(i);
            if (inventoryStack == null) {
                if (doAdd) {
                    inventory.func_70299_a(i, itemstack.func_77946_l());
                    itemstack.field_77994_a = 0;
                }
                return true;
            }
            if (inventoryStack.field_77994_a >= inventoryStack.func_77976_d() || !inventoryStack.func_77969_a(itemstack) || !ItemStack.func_77970_a((ItemStack)inventoryStack, (ItemStack)itemstack)) continue;
            int space = inventoryStack.func_77976_d() - inventoryStack.field_77994_a;
            if (space > itemstack.field_77994_a) {
                if (doAdd) {
                    inventoryStack.field_77994_a += itemstack.field_77994_a;
                    itemstack.field_77994_a = 0;
                }
                return true;
            }
            if (doAdd) {
                inventoryStack.field_77994_a = inventoryStack.func_77976_d();
                itemstack.field_77994_a -= space;
            }
            added = true;
        }
        return added;
    }

    public static int addToInventory(ItemStack itemstack, IInventory inventory, boolean doAdd, int slot1, int count) {
        int added = 0;
        for (int i = slot1; i < slot1 + count; ++i) {
            ItemStack inventoryStack = inventory.func_70301_a(i);
            if (inventoryStack == null) {
                if (doAdd) {
                    inventory.func_70299_a(i, itemstack.func_77946_l());
                }
                return itemstack.field_77994_a;
            }
            if (inventoryStack.field_77994_a >= inventoryStack.func_77976_d() || !inventoryStack.func_77969_a(itemstack)) continue;
            int space = inventoryStack.func_77976_d() - inventoryStack.field_77994_a;
            if (space > itemstack.field_77994_a - added) {
                if (doAdd) {
                    inventoryStack.field_77994_a += itemstack.field_77994_a;
                }
                return itemstack.field_77994_a;
            }
            if (doAdd) {
                inventoryStack.field_77994_a = inventoryStack.func_77976_d();
            }
            added += space;
        }
        return added;
    }

    public static void mergeStacks(ItemStack giver, ItemStack receptor) {
        if (receptor.field_77994_a >= 64) {
            return;
        }
        if (!receptor.func_77969_a(giver)) {
            return;
        }
        if (giver.field_77994_a <= receptor.func_77976_d() - receptor.field_77994_a) {
            receptor.field_77994_a += giver.field_77994_a;
            giver.field_77994_a = 0;
            return;
        }
        ItemStack temp = giver.func_77979_a(receptor.func_77976_d() - receptor.field_77994_a);
        receptor.field_77994_a += temp.field_77994_a;
        temp.field_77994_a = 0;
    }

    public static boolean freeSpaceInStack(ItemStack stack, int maxSize) {
        if (stack == null) {
            return true;
        }
        return stack.field_77994_a < maxSize;
    }

    public static boolean canAddToStack(ItemStack stack, ItemStack inventory) {
        if (inventory == null) {
            return true;
        }
        return stack.field_77993_c == inventory.field_77993_c;
    }

    public static ItemStack createSplitStack(ItemStack stack, int amount) {
        ItemStack split = new ItemStack(stack.field_77993_c, amount, stack.func_77960_j());
        if (stack.func_77978_p() != null) {
            NBTTagCompound nbttagcompound = (NBTTagCompound)stack.func_77978_p().func_74737_b();
            split.func_77982_d(nbttagcompound);
        }
        return split;
    }

    public static ItemStack[] condenseStacks(ItemStack[] stacks) {
        return StackUtils.condenseStacks(stacks, -1, false);
    }

    public static ItemStack[] condenseStacks(ItemStack[] stacks, int maxCountedPerStack, boolean craftingEquivalency) {
        ArrayList<ItemStack> condensed = new ArrayList<ItemStack>();
        for (ItemStack stack : stacks) {
            if (stack == null || stack.field_77994_a <= 0) continue;
            boolean matched = false;
            for (ItemStack cached : condensed) {
                if (!cached.func_77969_a(stack) && (!craftingEquivalency || !StackUtils.isCraftingEquivalent(cached, stack, true, false))) continue;
                cached.field_77994_a = cached.field_77994_a + (maxCountedPerStack > 0 && stack.field_77994_a > maxCountedPerStack ? maxCountedPerStack : stack.field_77994_a);
                matched = true;
            }
            if (matched) continue;
            ItemStack cached = stack.func_77946_l();
            if (maxCountedPerStack > 0) {
                cached.field_77994_a = maxCountedPerStack;
            }
            condensed.add(cached);
        }
        return condensed.toArray(EMPTY_STACK_ARRAY);
    }

    public static int containsSets(ItemStack[] set, ItemStack[] stock) {
        return StackUtils.containsSets(set, stock, null, false, false);
    }

    public static int containsSets(ItemStack[] set, ItemStack[] stock, ItemStack exclude, boolean oreDictionary, boolean craftingTools) {
        int count = 0;
        ItemStack[] condensedRequired = StackUtils.condenseStacks(set);
        ItemStack[] condensedOffered = StackUtils.condenseStacks(stock, -1, oreDictionary);
        for (ItemStack req : condensedRequired) {
            boolean matched = false;
            for (ItemStack offer : condensedOffered) {
                if (exclude != null && StackUtils.isIdenticalItem(offer, exclude) || !StackUtils.isCraftingEquivalent(req, offer, oreDictionary, craftingTools)) continue;
                matched = true;
                int stackCount = (int)Math.floor(offer.field_77994_a / req.field_77994_a);
                if (stackCount <= 0) {
                    return 0;
                }
                if (count == 0) {
                    count = stackCount;
                    continue;
                }
                if (count <= stackCount) continue;
                count = stackCount;
            }
            if (matched) continue;
            return 0;
        }
        return count;
    }

    public static boolean isCraftingEquivalent(ItemStack base, ItemStack comparison, boolean oreDictionary, boolean craftingTools) {
        int idBase;
        if (StackUtils.isIdenticalItem(base, comparison)) {
            return true;
        }
        if (oreDictionary && (idBase = OreDictionary.getOreID((ItemStack)base)) >= 0) {
            for (ItemStack itemstack : OreDictionary.getOres((Integer)idBase)) {
                if (comparison.field_77993_c != itemstack.field_77993_c || itemstack.func_77960_j() != Short.MAX_VALUE && comparison.func_77960_j() != itemstack.func_77960_j()) continue;
                return true;
            }
        }
        if (craftingTools) {
            return StackUtils.isThisCraftingTool(base, comparison);
        }
        return false;
    }

    public static boolean isCraftingTool(ItemStack itemstack) {
        return itemstack.func_77973_b().func_77634_r() && itemstack.func_77973_b().func_77645_m() && !itemstack.func_77973_b().func_77630_h(itemstack);
    }

    public static boolean isThisCraftingTool(ItemStack phantom, ItemStack actual) {
        return StackUtils.isCraftingTool(phantom) && phantom.field_77993_c == actual.field_77993_c;
    }

    public static void stowContainerItem(ItemStack itemstack, InventoryAdapter stowing, int slotIndex, EntityPlayer player) {
        if (!itemstack.func_77973_b().func_77634_r()) {
            return;
        }
        ItemStack container = itemstack.func_77973_b().getContainerItemStack(itemstack);
        if (container.func_77984_f() && container.func_77960_j() > container.func_77958_k()) {
            MinecraftForge.EVENT_BUS.post((Event)new PlayerDestroyItemEvent(player, container));
            container = null;
        }
        if (container != null) {
            if (itemstack.func_77973_b().func_77630_h(itemstack)) {
                if (!stowing.tryAddStack(container, true) && !player.field_71071_by.func_70441_a(container)) {
                    player.func_71021_b(container);
                }
            } else if (!stowing.tryAddStack(container, slotIndex, 1, true) && !stowing.tryAddStack(container, true)) {
                player.func_71021_b(container);
            }
        }
    }

    public static void dropItemStackAsEntity(ItemStack items, World world, double x, double y, double z) {
        if (items.field_77994_a <= 0) {
            return;
        }
        float f1 = 0.7f;
        double d = (double)(world.field_73012_v.nextFloat() * f1) + (double)(1.0f - f1) * 0.5;
        double d1 = (double)(world.field_73012_v.nextFloat() * f1) + (double)(1.0f - f1) * 0.5;
        double d2 = (double)(world.field_73012_v.nextFloat() * f1) + (double)(1.0f - f1) * 0.5;
        EntityItem entityitem = new EntityItem(world, x + d, y + d1, z + d2, items);
        entityitem.field_70293_c = 10;
        world.func_72838_d((Entity)entityitem);
    }

    public static void replenishByContainer(TileForestry tile, ItemStack inventoryStack, TankSlot tank) {
        FluidContainerRegistry.FluidContainerData container = LiquidHelper.getLiquidContainer(inventoryStack);
        StackUtils.replenishByContainer(tile, inventoryStack, container, tank);
    }

    public static ItemStack replenishByContainer(TileForestry tile, ItemStack inventoryStack, FluidContainerRegistry.FluidContainerData container, TankSlot tank) {
        if (container == null) {
            return inventoryStack;
        }
        if (tank.fill(container.fluid, false) >= container.fluid.amount) {
            tank.fill(container.fluid, true);
            if (container.filledContainer != null && container.filledContainer.func_77973_b().func_77634_r()) {
                inventoryStack = container.emptyContainer.func_77946_l();
            } else {
                --inventoryStack.field_77994_a;
            }
            tile.sendNetworkUpdate();
        }
        return inventoryStack;
    }

    public static ItemStack copyWithRandomSize(ItemStack template, int max, Random rand) {
        int size = rand.nextInt(max);
        ItemStack created = template.func_77946_l();
        created.field_77994_a = size <= 0 ? 1 : (size > created.func_77976_d() ? created.func_77976_d() : size);
        return created;
    }
}

