/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.gui;

import forestry.api.farming.IFarmLogic;
import forestry.core.gui.ContainerForestry;
import forestry.core.gui.GuiForestry;
import forestry.core.gui.Ledger;
import forestry.core.gui.LiquidTankSlot;
import forestry.core.gui.SocketSlot;
import forestry.core.gui.Widget;
import forestry.core.gui.WidgetManager;
import forestry.core.proxy.Proxies;
import forestry.core.utils.StringUtil;
import forestry.farming.gadgets.TileFarmPlain;
import forestry.farming.gui.ContainerFarm;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.Icon;
import org.lwjgl.opengl.GL11;

public class GuiFarm
extends GuiForestry {
    public GuiFarm(EntityPlayer player, TileFarmPlain tile) {
        super("textures/gui/mfarm.png", (ContainerForestry)new ContainerFarm(player.field_71071_by, tile), (Object)tile);
        this.widgetManager.add(new LiquidTankSlot(this.widgetManager, 15, 19, 0).setOverlayOrigin(216, 18));
        this.widgetManager.add(new SocketSlot(this.widgetManager, 69, 40, tile, 0));
        this.widgetManager.add(new FarmLogicSlot(this.widgetManager, 69, 22, tile, 0));
        this.widgetManager.add(new FarmLogicSlot(this.widgetManager, 69, 58, tile, 1));
        this.widgetManager.add(new FarmLogicSlot(this.widgetManager, 51, 40, tile, 2));
        this.widgetManager.add(new FarmLogicSlot(this.widgetManager, 87, 40, tile, 3));
        this.field_74194_b = 216;
        this.field_74195_c = 220;
        this.tile = tile;
    }

    @Override
    protected void initLedgers(Object inventory) {
        super.initLedgers(inventory);
        this.ledgerManager.insert(new FarmLedger((TileFarmPlain)this.tile));
    }

    @Override
    protected void func_74189_g(int mouseX, int mouseY) {
        super.func_74189_g(mouseX, mouseY);
        String title = StringUtil.localize("Farm");
        this.field_73886_k.func_78276_b(title, this.getCenteredOffset(title), 6, this.fontColor.get("gui.title"));
    }

    @Override
    protected void func_74185_a(float var1, int mouseX, int mouseY) {
        super.func_74185_a(var1, mouseX, mouseY);
        int fertilizerRemain = ((TileFarmPlain)this.tile).getStoredFertilizerScaled(16);
        if (fertilizerRemain > 0) {
            this.func_73729_b(this.field_74198_m + 81, this.field_74197_n + 94 + 17 - fertilizerRemain, this.field_74194_b, 17 - fertilizerRemain, 4, fertilizerRemain);
        }
    }

    private static class FarmLogicSlot
    extends Widget {
        private TileFarmPlain tile;
        private int slot;

        public FarmLogicSlot(WidgetManager manager, int xPos, int yPos, TileFarmPlain tile, int slot) {
            super(manager, xPos, yPos);
            this.tile = tile;
            this.slot = slot;
        }

        private IFarmLogic getLogic() {
            return this.tile.getFarmLogics()[this.slot];
        }

        private Icon getIconIndex() {
            if (this.getLogic() == null) {
                return null;
            }
            return this.getLogic().getIcon();
        }

        @Override
        public void draw(int startX, int startY) {
            if (this.getLogic() == null) {
                return;
            }
            if (this.getIconIndex() != null) {
                GL11.glDisable((int)2896);
                Proxies.common.bindTexture(this.getLogic().getSpriteSheet());
                this.manager.gui.func_94065_a(startX + this.xPos, startY + this.yPos, this.getIconIndex(), 16, 16);
                GL11.glEnable((int)2896);
            }
        }

        @Override
        protected String getTooltip(EntityPlayer player) {
            if (this.getLogic() != null) {
                return this.getLogic().getName();
            }
            return null;
        }

        @Override
        protected void addInformation(ArrayList list, EntityPlayer player) {
            if (this.getLogic() == null) {
                return;
            }
            list.add("Fertilizer: " + this.getLogic().getFertilizerConsumption());
            list.add("Water: " + this.getLogic().getWaterConsumption(this.tile.getHydrationModifier()));
        }
    }

    protected class FarmLedger
    extends Ledger {
        private TileFarmPlain farm;

        public FarmLedger(TileFarmPlain farm) {
            super(GuiFarm.this.ledgerManager);
            this.farm = farm;
            this.maxHeight = 118;
            this.overlayColor = GuiFarm.this.fontColor.get("ledger.farm.background");
        }

        @Override
        public void draw(int x, int y) {
            this.drawBackground(x, y);
            this.drawIcon(Item.field_77786_ax.func_77617_a(0), x + 3, y + 4);
            if (!this.isFullyOpened()) {
                return;
            }
            GuiFarm.this.field_73886_k.func_78261_a(StringUtil.localize("gui.hydration"), x + 22, y + 8, GuiFarm.this.fontColor.get("ledger.power.header"));
            GuiFarm.this.field_73886_k.func_78261_a(StringUtil.localize("gui.hydr.heat") + ":", x + 22, y + 20, GuiFarm.this.fontColor.get("ledger.power.subheader"));
            GuiFarm.this.field_73886_k.func_78276_b(StringUtil.floatAsPercent(this.farm.getHydrationTempModifier()), x + 22, y + 32, GuiFarm.this.fontColor.get("ledger.power.text"));
            GuiFarm.this.field_73886_k.func_78261_a(StringUtil.localize("gui.hydr.humid") + ":", x + 22, y + 44, GuiFarm.this.fontColor.get("ledger.power.subheader"));
            GuiFarm.this.field_73886_k.func_78276_b(StringUtil.floatAsPercent(this.farm.getHydrationHumidModifier()), x + 22, y + 56, GuiFarm.this.fontColor.get("ledger.power.text"));
            GuiFarm.this.field_73886_k.func_78261_a(StringUtil.localize("gui.hydr.rainfall") + ":", x + 22, y + 68, GuiFarm.this.fontColor.get("ledger.power.subheader"));
            GuiFarm.this.field_73886_k.func_78276_b(StringUtil.floatAsPercent(this.farm.getHydrationRainfallModifier()) + " (" + this.farm.getDrought() + " d)", x + 22, y + 80, GuiFarm.this.fontColor.get("ledger.power.text"));
            GuiFarm.this.field_73886_k.func_78261_a(StringUtil.localize("gui.hydr.overall") + ":", x + 22, y + 92, GuiFarm.this.fontColor.get("ledger.power.subheader"));
            GuiFarm.this.field_73886_k.func_78276_b(StringUtil.floatAsPercent(this.farm.getHydrationModifier()), x + 22, y + 104, GuiFarm.this.fontColor.get("ledger.power.text"));
        }

        @Override
        public String getTooltip() {
            return StringUtil.floatAsPercent(this.farm.getHydrationModifier()) + " " + StringUtil.localize("gui.hydration");
        }
    }
}

