/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.render;

import forestry.core.config.ForestryBlock;
import forestry.core.render.OverlayRenderingHandler;
import forestry.farming.gadgets.BlockFarm;
import forestry.plugins.PluginFarming;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.world.IBlockAccess;

public class FarmRenderingHandler
extends OverlayRenderingHandler {
    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderer) {
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        renderer.func_78570_q(block, x, y, z);
        this.renderFarmOverlay(world, (BlockFarm)ForestryBlock.farm, x, y, z, renderer, 0xFFFFFF);
        return true;
    }

    private boolean renderFarmOverlay(IBlockAccess world, BlockFarm block, int x, int y, int z, RenderBlocks renderer, int multiplier) {
        float mR = (float)(multiplier >> 16 & 0xFF) / 255.0f;
        float mG = (float)(multiplier >> 8 & 0xFF) / 255.0f;
        float mB = (float)(multiplier & 0xFF) / 255.0f;
        if (EntityRenderer.field_78517_a) {
            mR = (mR * 30.0f + mG * 59.0f + mB * 11.0f) / 100.0f;
            mG = (mR * 30.0f + mG * 70.0f) / 100.0f;
            mB = (mR * 30.0f + mB * 70.0f) / 100.0f;
        }
        return this.renderFarmOverlayWithColourMultiplier(world, block, x, y, z, mR, mG, mB, renderer);
    }

    private boolean renderFarmOverlayWithColourMultiplier(IBlockAccess world, BlockFarm block, int x, int y, int z, float r, float g, float b, RenderBlocks renderer) {
        int mixedBrightness = block.func_71874_e(world, x, y, z);
        int metadata = world.func_72805_g(x, y, z);
        float adjR = 0.5f * r;
        float adjG = 0.5f * g;
        float adjB = 0.5f * b;
        this.renderBottomFace(world, (Block)block, x, y, z, renderer, block.getOverlayTextureForBlock(0, metadata), mixedBrightness, adjR, adjG, adjB);
        this.renderTopFace(world, (Block)block, x, y, z, renderer, block.getOverlayTextureForBlock(1, metadata), mixedBrightness, adjR, adjG, adjB);
        this.renderEastFace(world, (Block)block, x, y, z, renderer, block.getOverlayTextureForBlock(2, metadata), mixedBrightness, adjR, adjG, adjB);
        this.renderWestFace(world, (Block)block, x, y, z, renderer, block.getOverlayTextureForBlock(3, metadata), mixedBrightness, adjR, adjG, adjB);
        this.renderNorthFace(world, (Block)block, x, y, z, renderer, block.getOverlayTextureForBlock(4, metadata), mixedBrightness, adjR, adjG, adjB);
        this.renderSouthFace(world, (Block)block, x, y, z, renderer, block.getOverlayTextureForBlock(5, metadata), mixedBrightness, adjR, adjG, adjB);
        return true;
    }

    public boolean shouldRender3DInInventory() {
        return true;
    }

    public int getRenderId() {
        return PluginFarming.modelIdFarmBlock;
    }
}

