/*
 * Decompiled with CFR 0.152.
 */
package forestry.lepidopterology.genetics;

import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IChromosome;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.IIndividual;
import forestry.api.lepidopterology.EnumButterflyChromosome;
import forestry.api.lepidopterology.IAlleleButterflySpecies;
import forestry.api.lepidopterology.IButterfly;
import forestry.api.lepidopterology.IButterflyGenome;
import forestry.api.lepidopterology.IButterflyMutation;
import forestry.api.lepidopterology.IButterflyNursery;
import forestry.api.lepidopterology.IEntityButterfly;
import forestry.core.genetics.Chromosome;
import forestry.core.genetics.ClimateHelper;
import forestry.core.genetics.GenericRatings;
import forestry.core.genetics.IndividualLiving;
import forestry.core.utils.StackUtils;
import forestry.core.utils.StringUtil;
import forestry.core.utils.Utils;
import forestry.lepidopterology.genetics.ButterflyGenome;
import forestry.plugins.PluginLepidopterology;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.entity.EntityCreature;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;

public class Butterfly
extends IndividualLiving
implements IButterfly {
    public IButterflyGenome genome;
    public IButterflyGenome mate;

    public Butterfly(NBTTagCompound nbttagcompound) {
        this.readFromNBT(nbttagcompound);
    }

    public Butterfly(IButterflyGenome genome) {
        this(genome, true, 0);
    }

    public Butterfly(IButterflyGenome genome, boolean isNatural, int generation) {
        super(genome.getLifespan(), isNatural, generation);
        this.genome = genome;
    }

    @Override
    public void addTooltip(List list) {
        IAlleleButterflySpecies primary = this.genome.getPrimary();
        IAlleleButterflySpecies secondary = this.genome.getSecondary();
        if (!this.isPureBred(EnumButterflyChromosome.SPECIES.ordinal())) {
            list.add("\u00a79" + StringUtil.localize("gui.hybrid") + ":" + primary.getName() + "-" + secondary.getName());
        }
        if (this.getMate() != null) {
            list.add("\u00a7c" + StringUtil.localize("gui.fecundated").toUpperCase(Locale.ENGLISH));
        }
        list.add("\u00a7e" + this.genome.getActiveAllele(EnumButterflyChromosome.SIZE.ordinal()).getName());
        list.add("\u00a7f" + this.genome.getActiveAllele(EnumButterflyChromosome.SPEED.ordinal()).getName() + " " + StringUtil.localize("gui.flyer"));
        list.add(this.genome.getActiveAllele(EnumButterflyChromosome.LIFESPAN.ordinal()).getName() + " " + StringUtil.localize("gui.life"));
        list.add("\u00a7aT: " + ClimateHelper.toDisplay(this.genome.getPrimary().getTemperature()) + " / " + StringUtil.capitalize(this.genome.getToleranceTemp().name()));
        list.add("\u00a7aH: " + ClimateHelper.toDisplay(this.genome.getPrimary().getHumidity()) + " / " + StringUtil.capitalize(this.genome.getToleranceHumid().name()));
        list.add("\u00a7c" + GenericRatings.rateActivityTime(this.genome.getNocturnal(), this.genome.getPrimary().isNocturnal()));
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        if (nbttagcompound == null) {
            this.genome = PluginLepidopterology.butterflyInterface.templateAsGenome(PluginLepidopterology.butterflyInterface.getDefaultTemplate());
            return;
        }
        super.readFromNBT(nbttagcompound);
        this.genome = nbttagcompound.func_74764_b("Genome") ? new ButterflyGenome(nbttagcompound.func_74775_l("Genome")) : PluginLepidopterology.butterflyInterface.templateAsGenome(PluginLepidopterology.butterflyInterface.getDefaultTemplate());
        if (nbttagcompound.func_74764_b("Mate")) {
            this.mate = new ButterflyGenome(nbttagcompound.func_74775_l("Mate"));
        }
    }

    @Override
    public IButterfly copy() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.writeToNBT(nbttagcompound);
        return new Butterfly(nbttagcompound);
    }

    @Override
    public IButterflyGenome getGenome() {
        return this.genome;
    }

    @Override
    public IButterflyGenome getMate() {
        return this.mate;
    }

    @Override
    public boolean canSpawn(World world, double x, double y, double z) {
        BiomeGenBase biome;
        block3: {
            boolean noneMatched;
            block5: {
                block4: {
                    if (!this.canFly(world)) {
                        return false;
                    }
                    biome = Utils.getBiomeAt(world, (int)x, (int)z);
                    if (this.getGenome().getPrimary().getSpawnBiomes().size() <= 0) break block3;
                    noneMatched = true;
                    if (!this.getGenome().getPrimary().strictSpawnMatch()) break block4;
                    BiomeDictionary.Type[] types = BiomeDictionary.getTypesForBiome((BiomeGenBase)biome);
                    if (types.length != 1 || !this.getGenome().getPrimary().getSpawnBiomes().contains(types[0])) break block5;
                    noneMatched = false;
                    break block5;
                }
                for (BiomeDictionary.Type type : this.getGenome().getPrimary().getSpawnBiomes()) {
                    if (!BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)type)) continue;
                    noneMatched = false;
                    break;
                }
            }
            if (noneMatched) {
                return false;
            }
        }
        return this.isAcceptedEnvironment(biome);
    }

    @Override
    public boolean canTakeFlight(World world, double x, double y, double z) {
        if (!this.canFly(world)) {
            return false;
        }
        return this.isAcceptedEnvironment(Utils.getBiomeAt(world, (int)x, (int)z));
    }

    private boolean canFly(World world) {
        if (world.func_72896_J() && !this.getGenome().getTolerantFlyer()) {
            return false;
        }
        return this.isActiveThisTime(world.func_72935_r());
    }

    @Override
    public boolean isAcceptedEnvironment(World world, double x, double y, double z) {
        return this.isAcceptedEnvironment(Utils.getBiomeAt(world, (int)x, (int)z));
    }

    private boolean isAcceptedEnvironment(BiomeGenBase biome) {
        return ClimateHelper.isWithinLimits(EnumTemperature.getFromValue(biome.field_76750_F), EnumHumidity.getFromValue(biome.field_76751_G), this.getGenome().getPrimary().getTemperature(), this.getGenome().getToleranceTemp(), this.getGenome().getPrimary().getHumidity(), this.getGenome().getToleranceHumid());
    }

    @Override
    public IButterfly spawnCaterpillar(IButterflyNursery nursery) {
        IChromosome[] mutated2;
        if (this.mate == null) {
            return null;
        }
        World world = nursery.getWorld();
        IChromosome[] chromosomes = new IChromosome[this.genome.getChromosomes().length];
        IChromosome[] parent1 = this.genome.getChromosomes();
        IChromosome[] parent2 = this.mate.getChromosomes();
        IChromosome[] mutated1 = this.mutateSpecies(nursery, this.genome, this.mate);
        if (mutated1 != null) {
            parent1 = mutated1;
        }
        if ((mutated2 = this.mutateSpecies(nursery, this.mate, this.genome)) != null) {
            parent2 = mutated2;
        }
        for (int i = 0; i < parent1.length; ++i) {
            if (parent1[i] == null || parent2[i] == null) continue;
            chromosomes[i] = Chromosome.inheritChromosome(world.field_73012_v, parent1[i], parent2[i]);
        }
        return new Butterfly(new ButterflyGenome(chromosomes), true, this.generation);
    }

    private IChromosome[] mutateSpecies(IButterflyNursery nursery, IGenome genomeOne, IGenome genomeTwo) {
        IGenome genome1;
        IGenome genome0;
        IAllele allele1;
        IAllele allele0;
        World world = nursery.getWorld();
        IChromosome[] parent1 = genomeOne.getChromosomes();
        IChromosome[] parent2 = genomeTwo.getChromosomes();
        if (world.field_73012_v.nextBoolean()) {
            allele0 = parent1[EnumButterflyChromosome.SPECIES.ordinal()].getPrimaryAllele();
            allele1 = parent2[EnumButterflyChromosome.SPECIES.ordinal()].getSecondaryAllele();
            genome0 = genomeOne;
            genome1 = genomeTwo;
        } else {
            allele0 = parent2[EnumButterflyChromosome.SPECIES.ordinal()].getPrimaryAllele();
            allele1 = parent1[EnumButterflyChromosome.SPECIES.ordinal()].getSecondaryAllele();
            genome0 = genomeTwo;
            genome1 = genomeOne;
        }
        for (IButterflyMutation mutation : PluginLepidopterology.butterflyInterface.getMutations(true)) {
            float f;
            float chance = 0.0f;
            chance = mutation.getChance(nursery, allele0, allele1, genome0, genome1);
            if (!(f > 0.0f) || !(world.field_73012_v.nextFloat() * 100.0f < chance)) continue;
            return PluginLepidopterology.butterflyInterface.templateAsChromosomes(mutation.getTemplate());
        }
        return null;
    }

    private boolean isActiveThisTime(boolean isDayTime) {
        if (this.getGenome().getNocturnal()) {
            return true;
        }
        return isDayTime ? !this.getGenome().getPrimary().isNocturnal() : this.getGenome().getPrimary().isNocturnal();
    }

    @Override
    public float getSize() {
        return this.getGenome().getSize();
    }

    @Override
    public void mate(IIndividual individual) {
        if (!(individual instanceof IButterfly)) {
            return;
        }
        this.mate = ((IButterfly)individual).getGenome();
    }

    @Override
    public ItemStack[] getLootDrop(IEntityButterfly entity, boolean playerKill, int lootLevel) {
        ArrayList<ItemStack> drop = new ArrayList<ItemStack>();
        EntityCreature creature = entity.getEntity();
        float metabolism = (float)this.getGenome().getMetabolism() / 10.0f;
        for (Map.Entry entry : this.getGenome().getPrimary().getButterflyLoot().entrySet()) {
            if (!(creature.field_70170_p.field_73012_v.nextFloat() < ((Float)entry.getValue()).floatValue() * metabolism)) continue;
            drop.add(((ItemStack)entry.getKey()).func_77946_l());
        }
        return drop.toArray(StackUtils.EMPTY_STACK_ARRAY);
    }

    @Override
    public ItemStack[] getCaterpillarDrop(IButterflyNursery nursery, boolean playerKill, int lootLevel) {
        ArrayList<ItemStack> drop = new ArrayList<ItemStack>();
        float metabolism = (float)this.getGenome().getMetabolism() / 10.0f;
        for (Map.Entry entry : this.getGenome().getPrimary().getCaterpillarLoot().entrySet()) {
            if (!(nursery.getWorld().field_73012_v.nextFloat() < ((Float)entry.getValue()).floatValue() * metabolism)) continue;
            drop.add(((ItemStack)entry.getKey()).func_77946_l());
        }
        return drop.toArray(StackUtils.EMPTY_STACK_ARRAY);
    }
}

