/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail;

import cpw.mods.fml.common.network.Player;
import forestry.core.interfaces.IPacketHandler;
import forestry.core.network.PacketUpdate;
import forestry.core.proxy.Proxies;
import forestry.mail.POBox;
import forestry.mail.PostRegistry;
import forestry.mail.gui.ContainerCatalogue;
import forestry.mail.gui.ContainerLetter;
import forestry.mail.gui.ContainerTradeName;
import forestry.mail.network.PacketPOBoxInfo;
import forestry.mail.network.PacketTradeInfo;
import forestry.plugins.PluginMail;
import java.io.DataInputStream;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.network.INetworkManager;

public class PacketHandlerMail
implements IPacketHandler {
    @Override
    public void onPacketData(INetworkManager network, int packetID, DataInputStream data, Player player) {
        try {
            switch (packetID) {
                case 83: {
                    PacketTradeInfo packetT = new PacketTradeInfo();
                    packetT.readData(data);
                    this.onTradeInfo(packetT);
                    break;
                }
                case 85: {
                    PacketPOBoxInfo packetP = new PacketPOBoxInfo();
                    packetP.readData(data);
                    this.onPOBoxInfo(packetP);
                    break;
                }
                case 80: {
                    PacketUpdate packet = new PacketUpdate();
                    packet.readData(data);
                    this.onLetterRecipient((EntityPlayer)player, packet);
                    break;
                }
                case 81: {
                    PacketUpdate packet = new PacketUpdate();
                    packet.readData(data);
                    this.onLetterText((EntityPlayer)player, packet);
                    break;
                }
                case 82: {
                    PacketUpdate packet = new PacketUpdate();
                    packet.readData(data);
                    this.onMonikerSet((EntityPlayer)player, packet);
                    break;
                }
                case 86: {
                    this.onPOBoxInfoRequest((EntityPlayer)player);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void onTradeInfo(PacketTradeInfo packet) {
        Container container = Proxies.common.getClientInstance().field_71439_g.field_71070_bA;
        if (container instanceof ContainerLetter) {
            ((ContainerLetter)container).handleTradeInfoUpdate(packet);
        } else if (container instanceof ContainerCatalogue) {
            ((ContainerCatalogue)container).handleTradeInfoUpdate(packet);
        }
    }

    private void onPOBoxInfo(PacketPOBoxInfo packet) {
        PluginMail.proxy.setPOBoxInfo(Proxies.common.getRenderWorld(), Proxies.common.getClientInstance().field_71439_g.field_71092_bJ, packet.poboxInfo);
    }

    private void onMonikerSet(EntityPlayer player, PacketUpdate packet) {
        if (!(player.field_71070_bA instanceof ContainerTradeName)) {
            return;
        }
        ((ContainerTradeName)player.field_71070_bA).handleSetMoniker(packet);
    }

    private void onLetterText(EntityPlayer player, PacketUpdate packet) {
        if (!(player.field_71070_bA instanceof ContainerLetter)) {
            return;
        }
        ((ContainerLetter)player.field_71070_bA).handleSetText(packet);
    }

    private void onLetterRecipient(EntityPlayer player, PacketUpdate packet) {
        if (!(player.field_71070_bA instanceof ContainerLetter)) {
            return;
        }
        ((ContainerLetter)player.field_71070_bA).handleSetRecipient(player, packet);
    }

    private void onPOBoxInfoRequest(EntityPlayer player) {
        POBox pobox = PostRegistry.getPOBox(player.field_70170_p, player.field_71092_bJ);
        if (pobox == null) {
            return;
        }
        Proxies.net.sendToPlayer(new PacketPOBoxInfo(85, pobox.getPOBoxInfo()), player);
    }
}

