/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail.gui;

import forestry.api.mail.IPostalCarrier;
import forestry.api.mail.MailAddress;
import forestry.api.mail.PostManager;
import forestry.core.config.SessionVars;
import forestry.core.gui.ContainerForestry;
import forestry.core.gui.GuiForestry;
import forestry.core.gui.GuiTextBox;
import forestry.core.gui.Widget;
import forestry.core.proxy.Proxies;
import forestry.core.utils.StringUtil;
import forestry.mail.EnumAddressee;
import forestry.mail.gui.ContainerLetter;
import forestry.mail.items.ItemLetter;
import java.util.Locale;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class GuiLetter
extends GuiForestry {
    private boolean isProcessedLetter;
    private boolean checkedSessionVars;
    private GuiTextField address;
    private GuiTextBox text;
    boolean addressFocus;
    boolean textFocus;
    private ContainerLetter container;

    public GuiLetter(EntityPlayer player, ItemLetter.LetterInventory inventory) {
        super("textures/gui/letter.png", (ContainerForestry)new ContainerLetter(player, inventory), (Object)inventory);
        this.field_74194_b = 194;
        this.field_74195_c = 227;
        this.container = (ContainerLetter)this.field_74193_d;
        this.isProcessedLetter = this.container.getLetter().isProcessed();
        this.widgetManager.add(new AddresseeSlot(16, 12));
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        Keyboard.enableRepeatEvents((boolean)true);
        this.address = new GuiTextField(this.field_73886_k, this.field_74198_m + 46, this.field_74197_n + 13, 93, 13);
        if (this.container.getRecipient() != null) {
            this.address.func_73782_a(this.container.getRecipient().getIdentifier());
            this.setRecipient(this.container.getRecipient().getIdentifier(), this.container.getCarrierType());
        }
        this.text = new GuiTextBox(this.field_73886_k, this.field_74198_m + 17, this.field_74197_n + 31, 122, 57);
        this.text.func_73804_f(128);
        if (!this.container.getText().isEmpty()) {
            this.text.func_73782_a(this.container.getText());
        }
    }

    protected void func_73869_a(char eventCharacter, int eventKey) {
        if (this.address.func_73806_l()) {
            if (eventKey == 28) {
                this.address.func_73796_b(false);
            } else {
                this.address.func_73802_a(eventCharacter, eventKey);
            }
            return;
        }
        if (this.text.func_73806_l()) {
            if (eventKey == 28) {
                if (Proxies.common.isShiftDown()) {
                    this.text.func_73782_a(this.text.func_73781_b() + "\n");
                } else {
                    this.text.func_73796_b(false);
                }
            } else if (eventKey == 208) {
                this.text.advanceLine();
            } else if (eventKey == 200) {
                this.text.regressLine();
            } else if (this.text.moreLinesAllowed() || eventKey == 211 || eventKey == 14) {
                this.text.func_73802_a(eventCharacter, eventKey);
            }
            return;
        }
        super.func_73869_a(eventCharacter, eventKey);
    }

    @Override
    protected void func_73864_a(int par1, int par2, int mouseButton) {
        super.func_73864_a(par1, par2, mouseButton);
        this.address.func_73793_a(par1, par2, mouseButton);
        this.text.func_73793_a(par1, par2, mouseButton);
    }

    @Override
    protected void func_74185_a(float var1, int mouseX, int mouseY) {
        if (!this.isProcessedLetter && !this.checkedSessionVars) {
            this.checkedSessionVars = true;
            this.setFromSessionVars();
        }
        if (this.addressFocus != this.address.func_73806_l()) {
            this.setRecipient(this.address.func_73781_b(), this.container.getCarrierType());
        }
        this.addressFocus = this.address.func_73806_l();
        if (this.textFocus != this.text.func_73806_l()) {
            this.setText();
        }
        this.textFocus = this.text.func_73806_l();
        super.func_74185_a(var1, mouseX, mouseY);
        if (this.isProcessedLetter) {
            this.field_73886_k.func_78276_b(this.address.func_73781_b(), this.field_74198_m + 49, this.field_74197_n + 16, this.fontColor.get("gui.mail.lettertext"));
            this.field_73886_k.func_78279_b(this.text.func_73781_b(), this.field_74198_m + 20, this.field_74197_n + 34, 119, this.fontColor.get("gui.mail.lettertext"));
        } else {
            this.address.func_73795_f();
            if (this.container.getCarrierType().equals(EnumAddressee.TRADER.toString().toLowerCase(Locale.ENGLISH))) {
                this.drawTradePreview(this.field_74198_m + 18, this.field_74197_n + 32);
            } else {
                this.text.func_73795_f();
            }
        }
    }

    private void drawTradePreview(int x, int y) {
        String infoString = null;
        if (this.container.getTradeInfo() == null) {
            infoString = "gui.mail.notrader";
        } else if (this.container.getTradeInfo().tradegood == null) {
            infoString = "gui.mail.nothingtotrade";
        } else if (!this.container.getTradeInfo().state.isOk()) {
            infoString = "chat.mail." + this.container.getTradeInfo().state.getIdentifier();
        }
        if (infoString != null) {
            this.field_73886_k.func_78279_b(StringUtil.localize(infoString), x, y, 119, this.fontColor.get("gui.mail.lettertext"));
            return;
        }
        this.field_73886_k.func_78276_b(StringUtil.localize("gui.mail.pleasesend"), x, y, this.fontColor.get("gui.mail.lettertext"));
        field_74196_a.func_82406_b(this.field_73886_k, this.field_73882_e.field_71446_o, this.container.getTradeInfo().tradegood, x, y + 10);
        field_74196_a.func_77021_b(this.field_73886_k, this.field_73882_e.field_71446_o, this.container.getTradeInfo().tradegood, x, y + 10);
        GL11.glDisable((int)2896);
        this.field_73886_k.func_78276_b(StringUtil.localize("gui.mail.foreveryattached"), x, y + 28, this.fontColor.get("gui.mail.lettertext"));
        GL11.glEnable((int)2896);
        for (int i = 0; i < this.container.getTradeInfo().required.length; ++i) {
            GL11.glDisable((int)2896);
            field_74196_a.func_82406_b(this.field_73886_k, this.field_73882_e.field_71446_o, this.container.getTradeInfo().required[i], x + i * 18, y + 38);
            field_74196_a.func_77021_b(this.field_73886_k, this.field_73882_e.field_71446_o, this.container.getTradeInfo().required[i], x + i * 18, y + 38);
            GL11.glEnable((int)2896);
        }
    }

    public void func_73874_b() {
        this.setRecipient(this.address.func_73781_b(), this.container.getCarrierType());
        this.setText();
        Keyboard.enableRepeatEvents((boolean)false);
        super.func_73874_b();
    }

    private void setFromSessionVars() {
        if (SessionVars.getStringVar("mail.letter.recipient") == null) {
            return;
        }
        String recipient = SessionVars.getStringVar("mail.letter.recipient");
        String type = SessionVars.getStringVar("mail.letter.addressee");
        if (type != null) {
            this.address.func_73782_a(recipient);
            this.setRecipient(recipient, type);
        }
        SessionVars.clearStringVar("mail.letter.recipient");
        SessionVars.clearStringVar("mail.letter.addressee");
    }

    private void setRecipient(String identifier, String type) {
        if (this.isProcessedLetter) {
            return;
        }
        MailAddress recipient = new MailAddress(identifier, type);
        this.container.setRecipient(recipient);
        this.container.updateTradeInfo((World)this.field_73882_e.field_71441_e, recipient);
    }

    private void setText() {
        if (this.isProcessedLetter) {
            return;
        }
        this.container.setText(this.text.func_73781_b());
    }

    protected class AddresseeSlot
    extends Widget {
        public AddresseeSlot(int xPos, int yPos) {
            super(GuiLetter.this.widgetManager, xPos, yPos);
            this.width = 26;
            this.height = 15;
        }

        @Override
        public void draw(int startX, int startY) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            IPostalCarrier carrier = PostManager.postRegistry.getCarrier(GuiLetter.this.container.getCarrierType());
            if (carrier != null) {
                GuiLetter.this.func_94065_a(startX + this.xPos, startY + this.yPos - 5, carrier.getIcon(), 26, 26);
            }
        }

        @Override
        protected String getTooltip(EntityPlayer player) {
            return StringUtil.localize("gui.addressee." + GuiLetter.this.container.getCarrierType().toLowerCase(Locale.ENGLISH));
        }

        @Override
        public void handleMouseClick(int mouseX, int mouseY, int mouseButton) {
            if (!GuiLetter.this.isProcessedLetter) {
                GuiLetter.this.container.advanceCarrierType();
            }
        }
    }
}

