/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.modsShared;

import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.util.ChunkCoordinates;

public class BlockArray
implements Iterable<ChunkCoordinates> {
    private int m_uMin;
    private int m_vMin;
    private ChunkCoordinates[][] m_blocks;

    public BlockArray(int uMin, int vMin, int width, int height) {
        this.m_uMin = uMin;
        this.m_vMin = vMin;
        this.m_blocks = new ChunkCoordinates[height][width];
    }

    public int getWidth() {
        return this.m_blocks[0].length;
    }

    public int getHeight() {
        return this.m_blocks.length;
    }

    public int getUMin() {
        return this.m_uMin;
    }

    public int getUMax() {
        return this.m_uMin + this.getWidth() - 1;
    }

    public int getVMin() {
        return this.m_vMin;
    }

    public int getVMax() {
        return this.m_vMin + this.getHeight() - 1;
    }

    public ChunkCoordinates getBlock(int u, int v) {
        return this.m_blocks[this.toZeroBasedV(v)][this.toZeroBasedU(u)];
    }

    public void setBlock(int u, int v, ChunkCoordinates coords) {
        this.m_blocks[this.toZeroBasedV((int)v)][this.toZeroBasedU((int)u)] = coords;
    }

    public int toZeroBasedU(int u) {
        return u - this.m_uMin;
    }

    public int toZeroBasedV(int v) {
        return v - this.m_vMin;
    }

    public BlockArray newEmptyCopy() {
        return new BlockArray(this.m_uMin, this.m_vMin, this.getWidth(), this.getHeight());
    }

    @Override
    public Iterator<ChunkCoordinates> iterator() {
        ArrayList<ChunkCoordinates> blocks = new ArrayList<ChunkCoordinates>();
        int u = 0;
        while (u < this.getWidth()) {
            int v = 0;
            while (v < this.getHeight()) {
                if (this.m_blocks[v][u] != null) {
                    blocks.add(this.m_blocks[v][u]);
                }
                ++v;
            }
            ++u;
        }
        return blocks.iterator();
    }

    public static enum Rotation {
        None{

            @Override
            public BlockArray rotate(BlockArray blocks) {
                return blocks;
            }
        }
        ,
        Ccw90{

            @Override
            public BlockArray rotate(BlockArray blocks) {
                BlockArray out = new BlockArray(0, 0, blocks.getHeight(), blocks.getWidth());
                int u = 0;
                while (u < out.getWidth()) {
                    int v = 0;
                    while (v < out.getHeight()) {
                        ((BlockArray)out).m_blocks[v][u] = blocks.m_blocks[blocks.getHeight() - 1 - u][v];
                        ++v;
                    }
                    ++u;
                }
                return out;
            }
        };


        public abstract BlockArray rotate(BlockArray var1);
    }
}

