/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.modsShared;

import cuchaz.modsShared.BlockSide;
import cuchaz.modsShared.BoundingBoxInt;
import cuchaz.modsShared.Log;
import cuchaz.modsShared.RuntimeMapping;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;

public class BlockUtils {
    public static int getManhattanDistance(ChunkCoordinates a, ChunkCoordinates b) {
        return BlockUtils.getManhattanDistance(a.field_71574_a, a.field_71572_b, a.field_71573_c, b.field_71574_a, b.field_71572_b, b.field_71573_c);
    }

    public static int getManhattanDistance(int ax, int ay, int az, ChunkCoordinates b) {
        return BlockUtils.getManhattanDistance(ax, ay, az, b.field_71574_a, b.field_71572_b, b.field_71573_c);
    }

    public static int getManhattanDistance(ChunkCoordinates a, int bx, int by, int bz) {
        return BlockUtils.getManhattanDistance(a.field_71574_a, a.field_71572_b, a.field_71573_c, bx, by, bz);
    }

    public static int getManhattanDistance(int ax, int ay, int az, int bx, int by, int bz) {
        return Math.abs(ax - bx) + Math.abs(ay - by) + Math.abs(az - bz);
    }

    public static int getXZManhattanDistance(ChunkCoordinates a, ChunkCoordinates b) {
        return BlockUtils.getXZManhattanDistance(a.field_71574_a, a.field_71572_b, a.field_71573_c, b.field_71574_a, b.field_71572_b, b.field_71573_c);
    }

    public static int getXZManhattanDistance(int ax, int ay, int az, ChunkCoordinates b) {
        return BlockUtils.getXZManhattanDistance(ax, ay, az, b.field_71574_a, b.field_71572_b, b.field_71573_c);
    }

    public static int getXZManhattanDistance(ChunkCoordinates a, int bx, int by, int bz) {
        return BlockUtils.getXZManhattanDistance(a.field_71574_a, a.field_71572_b, a.field_71573_c, bx, by, bz);
    }

    public static int getXZManhattanDistance(int ax, int ay, int az, int bx, int by, int bz) {
        return Math.abs(ax - bx) + Math.abs(az - bz);
    }

    public static List<ChunkCoordinates> searchForBlocks(int x, int y, int z, int maxNumBlocks, BlockValidator validator, Neighbors neighbors) {
        return BlockUtils.searchForBlocks(new ChunkCoordinates(x, y, z), maxNumBlocks, validator, neighbors);
    }

    public static List<ChunkCoordinates> searchForBlocks(ChunkCoordinates sourceBlock, int maxNumBlocks, BlockValidator validator, Neighbors neighbors) {
        LinkedHashSet<ChunkCoordinates> queue = new LinkedHashSet<ChunkCoordinates>();
        queue.add(sourceBlock);
        TreeSet<ChunkCoordinates> visitedBlocks = new TreeSet<ChunkCoordinates>();
        ArrayList<ChunkCoordinates> foundBlocks = new ArrayList<ChunkCoordinates>();
        ChunkCoordinates neighborCoords = new ChunkCoordinates(0, 0, 0);
        while (!queue.isEmpty()) {
            ChunkCoordinates block = (ChunkCoordinates)queue.iterator().next();
            queue.remove(block);
            visitedBlocks.add(block);
            if (!block.equals((Object)sourceBlock)) {
                if (foundBlocks.size() >= maxNumBlocks) {
                    return null;
                }
                foundBlocks.add(block);
            }
            int i = 0;
            while (i < neighbors.getNumNeighbors()) {
                neighbors.getNeighbor(neighborCoords, block, i);
                if (BlockUtils.isValidNeighbor(neighborCoords, validator, queue, visitedBlocks)) {
                    queue.add(new ChunkCoordinates(neighborCoords));
                }
                ++i;
            }
        }
        return foundBlocks;
    }

    public static Boolean searchForCondition(int x, int y, int z, int maxNumBlocks, BlockConditionValidator validator, Neighbors neighbors) {
        return BlockUtils.searchForCondition(new ChunkCoordinates(x, y, z), maxNumBlocks, validator, neighbors);
    }

    public static Boolean searchForCondition(ChunkCoordinates sourceBlock, int maxNumBlocks, BlockConditionValidator validator, Neighbors neighbors) {
        LinkedHashSet<ChunkCoordinates> queue = new LinkedHashSet<ChunkCoordinates>();
        queue.add(sourceBlock);
        TreeSet<ChunkCoordinates> visitedBlocks = new TreeSet<ChunkCoordinates>();
        ChunkCoordinates neighborCoords = new ChunkCoordinates(0, 0, 0);
        while (!queue.isEmpty()) {
            ChunkCoordinates block = (ChunkCoordinates)queue.iterator().next();
            queue.remove(block);
            visitedBlocks.add(block);
            if (visitedBlocks.size() > maxNumBlocks) {
                return null;
            }
            if (validator.isConditionMet(block)) {
                return true;
            }
            int i = 0;
            while (i < neighbors.getNumNeighbors()) {
                neighbors.getNeighbor(neighborCoords, block, i);
                if (BlockUtils.isValidNeighbor(neighborCoords, validator, queue, visitedBlocks)) {
                    queue.add(new ChunkCoordinates(neighborCoords));
                }
                ++i;
            }
        }
        return false;
    }

    public static ChunkCoordinates searchForBlock(int x, int y, int z, int maxNumBlocks, BlockConditionValidator validator, Neighbors neighbors) {
        return BlockUtils.searchForBlock(new ChunkCoordinates(x, y, z), maxNumBlocks, validator, neighbors);
    }

    public static ChunkCoordinates searchForBlock(ChunkCoordinates sourceBlock, int maxNumBlocks, BlockConditionValidator validator, Neighbors neighbors) {
        LinkedHashSet<ChunkCoordinates> queue = new LinkedHashSet<ChunkCoordinates>();
        queue.add(sourceBlock);
        TreeSet<ChunkCoordinates> visitedBlocks = new TreeSet<ChunkCoordinates>();
        ChunkCoordinates neighborCoords = new ChunkCoordinates(0, 0, 0);
        while (!queue.isEmpty()) {
            ChunkCoordinates block = (ChunkCoordinates)queue.iterator().next();
            queue.remove(block);
            visitedBlocks.add(block);
            if (!block.equals((Object)sourceBlock) && validator.isConditionMet(block)) {
                return block;
            }
            int i = 0;
            while (i < neighbors.getNumNeighbors()) {
                neighbors.getNeighbor(neighborCoords, block, i);
                if (BlockUtils.isValidNeighbor(neighborCoords, validator, queue, visitedBlocks)) {
                    queue.add(new ChunkCoordinates(neighborCoords));
                }
                ++i;
            }
        }
        return null;
    }

    private static boolean isValidNeighbor(ChunkCoordinates coords, BlockValidator validator, Set<ChunkCoordinates> queue, Set<ChunkCoordinates> visitedBlocks) {
        return validator.isValid(coords) && !visitedBlocks.contains(coords) && !queue.contains(coords);
    }

    public static List<TreeSet<ChunkCoordinates>> getConnectedComponents(Set<ChunkCoordinates> blocks, Neighbors neighbors) {
        ArrayList<TreeSet<ChunkCoordinates>> components = new ArrayList<TreeSet<ChunkCoordinates>>();
        final TreeSet<ChunkCoordinates> remainingBlocks = new TreeSet<ChunkCoordinates>(blocks);
        while (!remainingBlocks.isEmpty()) {
            ChunkCoordinates coords = remainingBlocks.first();
            TreeSet<ChunkCoordinates> component = new TreeSet<ChunkCoordinates>(BlockUtils.searchForBlocks(coords, remainingBlocks.size(), new BlockValidator(){

                @Override
                public boolean isValid(ChunkCoordinates coords) {
                    return remainingBlocks.contains(coords);
                }
            }, neighbors));
            component.add(coords);
            remainingBlocks.removeAll(component);
            components.add(component);
        }
        return components;
    }

    public static TreeSet<ChunkCoordinates> getBlocksAtYAndBelow(Set<ChunkCoordinates> inBlocks, int y) {
        TreeSet<ChunkCoordinates> outBlocks = new TreeSet<ChunkCoordinates>();
        for (ChunkCoordinates coords : inBlocks) {
            if (coords.field_71572_b > y) continue;
            outBlocks.add(coords);
        }
        return outBlocks;
    }

    public static TreeSet<ChunkCoordinates> getHoleFromInnerBoundary(Set<ChunkCoordinates> innerBoundary, Set<ChunkCoordinates> blocks, Neighbors neighbors) {
        return BlockUtils.getHoleFromInnerBoundary(innerBoundary, blocks, neighbors, null);
    }

    public static TreeSet<ChunkCoordinates> getHoleFromInnerBoundary(Set<ChunkCoordinates> innerBoundary, final Set<ChunkCoordinates> blocks, Neighbors neighbors, final Integer yMax) {
        BoundingBoxInt box = new BoundingBoxInt(blocks);
        int volume = box.getVolume();
        ChunkCoordinates sourceBlock = innerBoundary.iterator().next();
        List<ChunkCoordinates> holeBlocks = BlockUtils.searchForBlocks(sourceBlock, volume, new BlockValidator(){

            @Override
            public boolean isValid(ChunkCoordinates coords) {
                return !blocks.contains(coords) && (yMax == null || coords.field_71572_b <= yMax);
            }
        }, neighbors);
        if (holeBlocks == null) {
            throw new Error("Found too many enclosed blocks!");
        }
        holeBlocks.add(sourceBlock);
        return new TreeSet<ChunkCoordinates>(holeBlocks);
    }

    public static boolean removeBlockWithoutNotifyingIt(World world, int x, int y, int z) {
        return BlockUtils.changeBlockWithoutNotifyingIt(world, x, y, z, 0, 0);
    }

    public static boolean changeBlockWithoutNotifyingIt(World world, int x, int y, int z, int targetBlockId, int targetBlockMeta) {
        int oldBlockMeta;
        int oldBlockId;
        Chunk chunk;
        int mz;
        int my;
        int mx;
        block17: {
            mx = x & 0xF;
            my = y & 0xF;
            mz = z & 0xF;
            chunk = world.func_72938_d(x, z);
            oldBlockId = chunk.func_76610_a(mx, y, mz);
            oldBlockMeta = chunk.func_76628_c(mx, y, mz);
            if (oldBlockId != targetBlockId) break block17;
            if (oldBlockMeta != targetBlockMeta) {
                Log.logger.warning(String.format("Ignoring block metadata change for block %d at (%d,%d,%d)", oldBlockId, x, y, z));
            }
            return false;
        }
        try {
            ExtendedBlockStorage extendedblockstorage;
            TileEntity tileEntity;
            Field chunkPrecipitationHeightMapField = Chunk.class.getDeclaredField(RuntimeMapping.getRuntimeName("precipitationHeightMap", "field_76638_b"));
            chunkPrecipitationHeightMapField.setAccessible(true);
            Field chunkHeightMapField = Chunk.class.getDeclaredField(RuntimeMapping.getRuntimeName("heightMap", "field_76634_f"));
            chunkHeightMapField.setAccessible(true);
            Field chunkStorageArraysField = Chunk.class.getDeclaredField(RuntimeMapping.getRuntimeName("storageArrays", "field_76652_q"));
            chunkStorageArraysField.setAccessible(true);
            ExtendedBlockStorage[] storageArrays = (ExtendedBlockStorage[])chunkStorageArraysField.get(chunk);
            Field chunkIsModifiedField = Chunk.class.getDeclaredField(RuntimeMapping.getRuntimeName("isModified", "field_76643_l"));
            chunkIsModifiedField.setAccessible(true);
            Method chunkRelightBlockMethod = Chunk.class.getDeclaredMethod(RuntimeMapping.getRuntimeName("relightBlock", "func_76615_h"), Integer.TYPE, Integer.TYPE, Integer.TYPE);
            chunkRelightBlockMethod.setAccessible(true);
            Method chunkPropagateSkylightOcclusionMethod = Chunk.class.getDeclaredMethod(RuntimeMapping.getRuntimeName("propagateSkylightOcclusion", "func_76595_e"), Integer.TYPE, Integer.TYPE);
            chunkPropagateSkylightOcclusionMethod.setAccessible(true);
            int[] precipitationHeightMap = (int[])chunkPrecipitationHeightMapField.get(chunk);
            int[] heightMap = (int[])chunkHeightMapField.get(chunk);
            int heightMapIndex = mz << 4 | mx;
            if (y >= precipitationHeightMap[heightMapIndex] - 1) {
                precipitationHeightMap[heightMapIndex] = -999;
            }
            int height = heightMap[heightMapIndex];
            if (oldBlockId != 0 && Block.field_71973_m[oldBlockId] != null && Block.field_71973_m[oldBlockId].hasTileEntity(oldBlockMeta) && (tileEntity = chunk.func_76597_e(mx, y, mz)) != null) {
                tileEntity.func_70313_j();
                chunk.func_76627_f(mx, y, mz);
            }
            if ((extendedblockstorage = storageArrays[y >> 4]) == null) {
                storageArrays[y >> 4] = extendedblockstorage = new ExtendedBlockStorage(y >> 4 << 4, !world.field_73011_w.field_76576_e);
            }
            extendedblockstorage.func_76655_a(mx, my, mz, targetBlockId);
            extendedblockstorage.func_76654_b(mx, my, mz, targetBlockMeta);
            if (chunk.func_76596_b(mx, y, mz) > 0) {
                if (y >= height) {
                    chunkRelightBlockMethod.invoke((Object)chunk, mx, y + 1, mz);
                }
            } else if (y == height - 1) {
                chunkRelightBlockMethod.invoke((Object)chunk, mx, y, mz);
            }
            chunkPropagateSkylightOcclusionMethod.invoke((Object)chunk, mx, mz);
            chunkIsModifiedField.setBoolean(chunk, true);
            world.func_72845_h(x, y, z);
            if (!world.field_72995_K) {
                world.func_72851_f(x, y, z, oldBlockId);
            }
            return true;
        }
        catch (NoSuchFieldException ex) {
            throw new Error("Unable to remove block! Chunk class has changed!", ex);
        }
        catch (NoSuchMethodException ex) {
            throw new Error("Unable to remove block! Chunk class has changed!", ex);
        }
        catch (IllegalAccessException ex) {
            throw new Error("Unable to remove block! Access to Chunk instance was denied!", ex);
        }
        catch (SecurityException ex) {
            throw new Error("Unable to remove block! Access to Chunk instance was denied!", ex);
        }
        catch (IllegalArgumentException ex) {
            throw new Error("Unable to remove block! Chunk method has changed!", ex);
        }
        catch (InvocationTargetException ex) {
            throw new Error("Unable to remove block! Chunk method call failed!", ex);
        }
    }

    public static interface BlockConditionValidator
    extends BlockValidator {
        public boolean isConditionMet(ChunkCoordinates var1);
    }

    public static interface BlockValidator {
        public boolean isValid(ChunkCoordinates var1);
    }

    public static enum Neighbors {
        Faces{

            @Override
            public int getNumNeighbors() {
                return BlockSide.values().length;
            }

            @Override
            public void getNeighbor(ChunkCoordinates out, ChunkCoordinates in, int i) {
                BlockSide side = BlockSide.values()[i];
                out.field_71574_a = in.field_71574_a + side.getDx();
                out.field_71572_b = in.field_71572_b + side.getDy();
                out.field_71573_c = in.field_71573_c + side.getDz();
            }
        }
        ,
        Edges{
            private int[] dx;
            private int[] dy;
            private int[] dz;
            {
                int[] nArray = new int[12];
                nArray[1] = -1;
                nArray[2] = 1;
                nArray[4] = -1;
                nArray[5] = 1;
                nArray[6] = -1;
                nArray[7] = 1;
                nArray[9] = -1;
                nArray[10] = 1;
                this.dx = nArray;
                int[] nArray2 = new int[12];
                nArray2[0] = -1;
                nArray2[3] = 1;
                nArray2[4] = -1;
                nArray2[5] = -1;
                nArray2[6] = 1;
                nArray2[7] = 1;
                nArray2[8] = -1;
                nArray2[11] = 1;
                this.dy = nArray2;
                int[] nArray3 = new int[12];
                nArray3[0] = -1;
                nArray3[1] = -1;
                nArray3[2] = -1;
                nArray3[3] = -1;
                nArray3[8] = 1;
                nArray3[9] = 1;
                nArray3[10] = 1;
                nArray3[11] = 1;
                this.dz = nArray3;
            }

            @Override
            public int getNumNeighbors() {
                return Faces.getNumNeighbors() + this.dx.length;
            }

            @Override
            public void getNeighbor(ChunkCoordinates out, ChunkCoordinates in, int i) {
                if (i < Faces.getNumNeighbors()) {
                    Faces.getNeighbor(out, in, i);
                } else {
                    out.field_71574_a = in.field_71574_a + this.dx[i -= Faces.getNumNeighbors()];
                    out.field_71572_b = in.field_71572_b + this.dy[i];
                    out.field_71573_c = in.field_71573_c + this.dz[i];
                }
            }
        }
        ,
        Vertices{
            private int[] dx = new int[]{-1, 1, -1, 1, -1, 1, -1, 1};
            private int[] dy = new int[]{-1, -1, 1, 1, -1, -1, 1, 1};
            private int[] dz = new int[]{-1, -1, -1, -1, 1, 1, 1, 1};

            @Override
            public int getNumNeighbors() {
                return Edges.getNumNeighbors() + this.dx.length;
            }

            @Override
            public void getNeighbor(ChunkCoordinates out, ChunkCoordinates in, int i) {
                if (i < Edges.getNumNeighbors()) {
                    Edges.getNeighbor(out, in, i);
                } else {
                    out.field_71574_a = in.field_71574_a + this.dx[i -= Edges.getNumNeighbors()];
                    out.field_71572_b = in.field_71572_b + this.dy[i];
                    out.field_71573_c = in.field_71573_c + this.dz[i];
                }
            }
        };


        public abstract int getNumNeighbors();

        public abstract void getNeighbor(ChunkCoordinates var1, ChunkCoordinates var2, int var3);
    }
}

