/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.modsShared;

import java.util.Set;
import net.minecraft.util.ChunkCoordinates;

public class BoundingBoxInt {
    public int minX = Integer.MAX_VALUE;
    public int maxX = Integer.MIN_VALUE;
    public int minY = Integer.MAX_VALUE;
    public int maxY = Integer.MIN_VALUE;
    public int minZ = Integer.MAX_VALUE;
    public int maxZ = Integer.MIN_VALUE;

    public BoundingBoxInt() {
    }

    public BoundingBoxInt(Set<ChunkCoordinates> blocks) {
        this();
        for (ChunkCoordinates coords : blocks) {
            this.expandBoxToInclude(coords.field_71574_a, coords.field_71572_b, coords.field_71573_c);
        }
    }

    public void expandBoxToInclude(int x, int y, int z) {
        this.minX = Math.min(this.minX, x);
        this.maxX = Math.max(this.maxX, x);
        this.minY = Math.min(this.minY, y);
        this.maxY = Math.max(this.maxY, y);
        this.minZ = Math.min(this.minZ, z);
        this.maxZ = Math.max(this.maxZ, z);
    }

    public int getDx() {
        return this.maxX - this.minX + 1;
    }

    public int getDy() {
        return this.maxY - this.minY + 1;
    }

    public int getDz() {
        return this.maxZ - this.minZ + 1;
    }

    public boolean containsPoint(ChunkCoordinates coords) {
        return this.containsPoint(coords.field_71574_a, coords.field_71572_b, coords.field_71573_c);
    }

    public boolean containsPoint(int x, int y, int z) {
        return x >= this.minX && x <= this.maxX && y >= this.minY && y <= this.maxY && z >= this.minZ && z <= this.maxZ;
    }

    public int getVolume() {
        return this.getDx() * this.getDy() * this.getDz();
    }
}

