/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.modsShared;

import cuchaz.modsShared.BlockArray;
import cuchaz.modsShared.BlockSide;
import cuchaz.modsShared.BoundingBoxInt;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.minecraft.util.ChunkCoordinates;

public class Envelopes {
    private Map<BlockSide, BlockArray> m_envelopes;
    private BoundingBoxInt m_boundingBox;

    public Envelopes(Set<ChunkCoordinates> blocks) {
        this.m_boundingBox = new BoundingBoxInt(blocks);
        this.m_envelopes = new TreeMap<BlockSide, BlockArray>();
        BlockSide[] blockSideArray = BlockSide.values();
        int n = blockSideArray.length;
        int n2 = 0;
        while (n2 < n) {
            BlockSide side = blockSideArray[n2];
            BlockArray surface = new BlockArray(side.getU(this.m_boundingBox.minX, this.m_boundingBox.minY, this.m_boundingBox.minZ), side.getV(this.m_boundingBox.minX, this.m_boundingBox.minY, this.m_boundingBox.minZ), side.getWidth(this.m_boundingBox.getDx(), this.m_boundingBox.getDy(), this.m_boundingBox.getDz()), side.getHeight(this.m_boundingBox.getDx(), this.m_boundingBox.getDy(), this.m_boundingBox.getDz()));
            int u = surface.getUMin();
            while (u <= surface.getUMax()) {
                int v = surface.getVMin();
                while (v <= surface.getVMax()) {
                    surface.setBlock(u, v, null);
                    ++v;
                }
                ++u;
            }
            this.m_envelopes.put(side, surface);
            ++n2;
        }
        for (ChunkCoordinates coords : blocks) {
            BlockSide[] blockSideArray2 = BlockSide.values();
            int n3 = blockSideArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                int v;
                int u;
                BlockSide side = blockSideArray2[n4];
                BlockArray surface = this.m_envelopes.get((Object)side);
                ChunkCoordinates extremalCoords = surface.getBlock(u = side.getU(coords.field_71574_a, coords.field_71572_b, coords.field_71573_c), v = side.getV(coords.field_71574_a, coords.field_71572_b, coords.field_71573_c));
                if (extremalCoords == null || side.isMoreExtremal(coords, extremalCoords)) {
                    surface.setBlock(u, v, coords);
                }
                ++n4;
            }
        }
    }

    public BoundingBoxInt getBoundingBox() {
        return this.m_boundingBox;
    }

    public BlockArray getEnvelope(BlockSide side) {
        return this.m_envelopes.get((Object)side);
    }
}

