/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.modsShared;

import cuchaz.modsShared.CompareReal;
import cuchaz.modsShared.Matrix3;
import cuchaz.modsShared.Vector3;

public class Quaternion {
    public static final int Dimension = 4;
    public double a;
    public double b;
    public double c;
    public double d;

    public Quaternion() {
        this.set(1.0, 0.0, 0.0, 0.0);
    }

    public Quaternion(double a, double b, double c, double d) {
        this.set(a, b, c, d);
    }

    public Quaternion(Vector3 v) {
        this.set(v);
    }

    public Quaternion(Quaternion other) {
        this.set(other);
    }

    public double get(int i) {
        switch (i) {
            case 0: {
                return this.a;
            }
            case 1: {
                return this.b;
            }
            case 2: {
                return this.c;
            }
            case 3: {
                return this.d;
            }
        }
        assert (false) : "Invalid index: " + i;
        return Double.NaN;
    }

    public void set(int i, double val) {
        switch (i) {
            case 0: {
                this.a = val;
                return;
            }
            case 1: {
                this.b = val;
                return;
            }
            case 2: {
                this.c = val;
                return;
            }
            case 3: {
                this.d = val;
                return;
            }
        }
        assert (false) : "Invalid index: " + i;
    }

    public void set(double a, double b, double c, double d) {
        this.a = a;
        this.b = b;
        this.c = c;
        this.d = d;
    }

    public void set(Quaternion other) {
        this.set(other.a, other.b, other.c, other.d);
    }

    public void set(Vector3 v) {
        this.set(0.0, v.x, v.y, v.z);
    }

    public static void getRotation(Quaternion q, Vector3 axis, double angle) {
        double halfAngle = angle / 2.0;
        double multiplier = Math.sin(halfAngle) / axis.getLength();
        q.set(Math.cos(halfAngle), multiplier * axis.x, multiplier * axis.y, multiplier * axis.z);
        q.normalize();
    }

    public static void getRotationByPi(Quaternion q, Vector3 axis) {
        q.set(axis);
        q.normalize();
    }

    public static void getRotation(Quaternion q, Vector3 from, Vector3 to) {
        Vector3 fromUnit = new Vector3(from);
        fromUnit.normalize();
        Vector3 toUnit = new Vector3(to);
        toUnit.normalize();
        Vector3 axis = new Vector3();
        fromUnit.getCross(axis, toUnit);
        axis.normalize();
        double dot = from.getDot(to);
        if (CompareReal.eq(dot, 1.0, 1.0E-10)) {
            Quaternion.getIdentity(q);
            return;
        }
        if (CompareReal.eq(dot, -1.0, 1.0E-10)) {
            from.getArbitraryOrthogonal(axis);
        }
        assert (axis.x != Double.NaN && axis.y != Double.NaN && axis.z != Double.NaN);
        double angle = Math.acos(Math.min(fromUnit.getDot(toUnit), 1.0));
        Quaternion.getRotation(q, axis, angle);
    }

    public static void getRotation(Quaternion q, Vector3 axis, Vector3 from, Vector3 to) {
        assert (CompareReal.eq(axis.getSquaredLength(), 1.0));
        assert (CompareReal.eq(axis.getDot(from), axis.getDot(to)));
        Matrix3 rot = new Matrix3();
        from = new Vector3(from);
        from.orthogonalProjection(axis);
        Matrix3.getRightBasisFromXZ(rot, from, axis);
        rot.transpose();
        to = new Vector3(to);
        rot.multiply(to);
        double angle = Math.atan2(to.y, to.x);
        Quaternion.getRotation(q, axis, angle);
    }

    public static void getRotation(Quaternion q, Matrix3 basis) {
        double[][] m = basis.data;
        double tr = m[0][0] + m[1][1] + m[2][2];
        if (tr > 0.0) {
            double S = Math.sqrt(tr + 1.0) * 2.0;
            q.a = 0.25 * S;
            q.b = (m[2][1] - m[1][2]) / S;
            q.c = (m[0][2] - m[2][0]) / S;
            q.d = (m[1][0] - m[0][1]) / S;
        } else if (m[0][0] > m[1][1] & m[0][0] > m[2][2]) {
            double S = Math.sqrt(1.0 + m[0][0] - m[1][1] - m[2][2]) * 2.0;
            q.a = (m[2][1] - m[1][2]) / S;
            q.b = 0.25 * S;
            q.c = (m[0][1] + m[1][0]) / S;
            q.d = (m[0][2] + m[2][0]) / S;
        } else if (m[1][1] > m[2][2]) {
            double S = Math.sqrt(1.0 + m[1][1] - m[0][0] - m[2][2]) * 2.0;
            q.a = (m[0][2] - m[2][0]) / S;
            q.b = (m[0][1] + m[1][0]) / S;
            q.c = 0.25 * S;
            q.d = (m[1][2] + m[2][1]) / S;
        } else {
            double S = Math.sqrt(1.0 + m[2][2] - m[0][0] - m[1][1]) * 2.0;
            q.a = (m[1][0] - m[0][1]) / S;
            q.b = (m[0][2] + m[2][0]) / S;
            q.c = (m[1][2] + m[2][1]) / S;
            q.d = 0.25 * S;
        }
        if (q.b < 0.0) {
            q.negate();
        }
    }

    public static Quaternion getIdentity() {
        return new Quaternion(1.0, 0.0, 0.0, 0.0);
    }

    public static void getIdentity(Quaternion q) {
        q.set(1.0, 0.0, 0.0, 0.0);
    }

    public double toAxisAngle(Vector3 axis) {
        double multiplier = Math.sqrt(1.0 - this.a * this.a);
        axis.set(this.b / multiplier, this.c / multiplier, this.d / multiplier);
        return Math.acos(this.a) * 2.0;
    }

    public void negate() {
        this.a = -this.a;
        this.b = -this.b;
        this.c = -this.c;
        this.d = -this.d;
    }

    public double getSquaredLength() {
        return this.a * this.a + this.b * this.b + this.c * this.c + this.d * this.d;
    }

    public double getLength() {
        return Math.sqrt(this.getSquaredLength());
    }

    public void normalize() {
        double length = this.getLength();
        this.a /= length;
        this.b /= length;
        this.c /= length;
        this.d /= length;
    }

    public void add(Quaternion other) {
        this.a += other.a;
        this.b += other.b;
        this.c += other.c;
        this.d += other.d;
    }

    public void subtract(Quaternion other) {
        this.a -= other.a;
        this.b -= other.b;
        this.c -= other.c;
        this.d -= other.d;
    }

    public void multiplyLeft(Quaternion other) {
        this.set(other.a * this.a - other.b * this.b - other.c * this.c - other.d * this.d, other.a * this.b + other.b * this.a + other.c * this.d - other.d * this.c, other.a * this.c - other.b * this.d + other.c * this.a + other.d * this.b, other.a * this.d + other.b * this.c - other.c * this.b + other.d * this.a);
    }

    public void conjugate() {
        this.b = -this.b;
        this.c = -this.c;
        this.d = -this.d;
    }

    public double getDot(Quaternion other) {
        return this.a * other.a + this.b * other.b + this.c * other.c + this.d * other.d;
    }

    public String toString() {
        return "( " + this.a + ", " + this.b + "i, " + this.c + "j, " + this.d + "k )";
    }

    public void rotate(Vector3 out) {
        double ia = out.x * this.b + out.y * this.c + out.z * this.d;
        double ib = out.x * this.a - out.y * this.d + out.z * this.c;
        double ic = out.x * this.d + out.y * this.a - out.z * this.b;
        double id = -out.x * this.c + out.y * this.b + out.z * this.a;
        out.set(this.a * ib + this.b * ia + this.c * id - this.d * ic, this.a * ic - this.b * id + this.c * ia + this.d * ib, this.a * id + this.b * ic - this.c * ib + this.d * ia);
    }

    public void rotate(Matrix3 basis) {
        int i = 0;
        while (i < 3) {
            Vector3 axis = new Vector3();
            basis.getAxis(axis, i);
            this.rotate(axis);
            basis.setAxis(axis, i);
            ++i;
        }
    }

    public double getDistance(Quaternion other) {
        double aCopy = Math.abs(this.getDot(other));
        if (aCopy > 1.0) {
            aCopy = 1.0;
        }
        return Math.acos(aCopy);
    }
}

