/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.modsShared;

import cuchaz.modsShared.BlockSide;
import cuchaz.modsShared.BoxCorner;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;

public class RotatedBB {
    private AxisAlignedBB m_box;
    private float m_yaw;
    private double m_centerX;
    private double m_centerZ;

    public RotatedBB(AxisAlignedBB box, float yaw) {
        this(box, yaw, (box.field_72336_d + box.field_72340_a) / 2.0, (box.field_72334_f + box.field_72339_c) / 2.0);
    }

    public RotatedBB(AxisAlignedBB box, float yaw, double centerX, double centerZ) {
        this.m_box = box;
        this.m_yaw = yaw;
        this.m_centerX = centerX;
        this.m_centerZ = centerZ;
    }

    public AxisAlignedBB getAABox() {
        return this.m_box;
    }

    public float getYaw() {
        return this.m_yaw;
    }

    public double getMinY() {
        return this.m_box.field_72338_b;
    }

    public double getMaxY() {
        return this.m_box.field_72337_e;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[RotatedBB]");
        buf.append(String.format(" y=[%.2f,%.2f]", this.m_box.field_72338_b, this.m_box.field_72337_e));
        Vec3 p = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
        BoxCorner[] boxCornerArray = BlockSide.Top.getCorners();
        int n = boxCornerArray.length;
        int n2 = 0;
        while (n2 < n) {
            BoxCorner corner = boxCornerArray[n2];
            this.getCorner(p, corner);
            buf.append(String.format(" (%.2f,%.2f)", p.field_72450_a, p.field_72449_c));
            ++n2;
        }
        return buf.toString();
    }

    public void getCorner(Vec3 out, BoxCorner corner) {
        corner.getPoint(out, this.m_box);
        out.field_72450_a -= this.m_centerX;
        out.field_72449_c -= this.m_centerZ;
        float yawRad = (float)Math.toRadians(this.m_yaw);
        float cos = MathHelper.func_76134_b((float)yawRad);
        float sin = MathHelper.func_76126_a((float)yawRad);
        double x = out.field_72450_a * (double)cos + out.field_72449_c * (double)sin;
        double z = -out.field_72450_a * (double)sin + out.field_72449_c * (double)cos;
        out.field_72450_a = x;
        out.field_72449_c = z;
        out.field_72450_a += this.m_centerX;
        out.field_72449_c += this.m_centerZ;
    }

    public boolean containsPoint(double x, double y, double z) {
        if (y < this.m_box.field_72338_b || y > this.m_box.field_72337_e) {
            return false;
        }
        float yawRad = (float)Math.toRadians(-this.m_yaw);
        float cos = MathHelper.func_76134_b((float)yawRad);
        float sin = MathHelper.func_76126_a((float)yawRad);
        double newx = (x -= this.m_centerX) * (double)cos + (z -= this.m_centerZ) * (double)sin;
        double newz = -x * (double)sin + z * (double)cos;
        x = newx;
        z = newz;
        return (x += this.m_centerX) >= this.m_box.field_72340_a && x <= this.m_box.field_72336_d && (z += this.m_centerZ) >= this.m_box.field_72339_c && z <= this.m_box.field_72334_f;
    }
}

