/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.modsShared;

import cuchaz.modsShared.CompareReal;
import cuchaz.modsShared.HashCalculator;
import cuchaz.modsShared.Matrix3;
import cuchaz.modsShared.Quaternion;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class Vector3
implements Serializable,
Comparable<Vector3> {
    private static final long serialVersionUID = -7088845310201551458L;
    public static final int Dimension = 3;
    private static final Vector3 Origin = new Vector3(0.0, 0.0, 0.0);
    private static final Vector3 UnitX = new Vector3(1.0, 0.0, 0.0);
    private static final Vector3 UnitY = new Vector3(0.0, 1.0, 0.0);
    private static final Vector3 UnitZ = new Vector3(0.0, 0.0, 1.0);
    public double x;
    public double y;
    public double z;

    public Vector3() {
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
    }

    public Vector3(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vector3(double[] vals) {
        this.set(vals);
    }

    public Vector3(Vector3 other) {
        this.set(other);
    }

    public double get(int i) {
        switch (i) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
            case 2: {
                return this.z;
            }
        }
        assert (false) : "Invalid index: " + i;
        return Double.NaN;
    }

    public void set(int i, double val) {
        switch (i) {
            case 0: {
                this.x = val;
                return;
            }
            case 1: {
                this.y = val;
                return;
            }
            case 2: {
                this.z = val;
                return;
            }
        }
        assert (false) : "Invalid index: " + i;
    }

    public void set(Vector3 other) {
        this.x = other.x;
        this.y = other.y;
        this.z = other.z;
    }

    public void set(double a, double b, double c) {
        this.x = a;
        this.y = b;
        this.z = c;
    }

    public void set(double[] vals) {
        assert (vals.length == 3);
        this.x = vals[0];
        this.y = vals[1];
        this.z = vals[2];
    }

    public boolean isValid() {
        return !Double.isNaN(this.x) && !Double.isInfinite(this.x) && !Double.isNaN(this.y) && !Double.isInfinite(this.y) && !Double.isNaN(this.z) && !Double.isInfinite(this.z);
    }

    public static void getUnitX(Vector3 v) {
        v.set(UnitX);
    }

    public static void getUnitY(Vector3 v) {
        v.set(UnitY);
    }

    public static void getUnitZ(Vector3 v) {
        v.set(UnitZ);
    }

    public static void getOrigin(Vector3 v) {
        v.set(Origin);
    }

    public static Vector3 getUnitX() {
        return new Vector3(UnitX);
    }

    public static Vector3 getUnitY() {
        return new Vector3(UnitY);
    }

    public static Vector3 getUnitZ() {
        return new Vector3(UnitZ);
    }

    public static Vector3 getOrigin() {
        return new Vector3(Origin);
    }

    public static void getNormal(Vector3 out, Vector3 a, Vector3 b, Vector3 c) {
        out.set(c);
        out.subtract(b);
        out.normalize();
        Vector3 v = new Vector3();
        v.set(a);
        v.subtract(b);
        v.normalize();
        out.getCross(out, v);
        out.normalize();
    }

    public static List<Vector3> copyList(List<Vector3> points) {
        ArrayList<Vector3> pointsCopy = new ArrayList<Vector3>(points.size());
        for (Vector3 p : points) {
            pointsCopy.add(new Vector3(p));
        }
        return pointsCopy;
    }

    public static List<List<Vector3>> copyListList(List<List<Vector3>> points) {
        ArrayList<List<Vector3>> pointsCopy = new ArrayList<List<Vector3>>(points.size());
        for (List<Vector3> list : points) {
            pointsCopy.add(Vector3.copyList(list));
        }
        return pointsCopy;
    }

    public double getSquaredLength() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public double getLength() {
        return Math.sqrt(this.getSquaredLength());
    }

    public void normalize() {
        double length = this.getLength();
        this.x /= length;
        this.y /= length;
        this.z /= length;
    }

    public double getSquaredDistance(Vector3 other) {
        double dx = other.x - this.x;
        double dy = other.y - this.y;
        double dz = other.z - this.z;
        return dx * dx + dy * dy + dz * dz;
    }

    public double getDistance(Vector3 other) {
        return Math.sqrt(this.getSquaredDistance(other));
    }

    public void add(Vector3 other) {
        this.x += other.x;
        this.y += other.y;
        this.z += other.z;
    }

    public void subtract(Vector3 other) {
        this.x -= other.x;
        this.y -= other.y;
        this.z -= other.z;
    }

    public void scale(double s) {
        this.x *= s;
        this.y *= s;
        this.z *= s;
    }

    public void negate() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
    }

    public double getDot(Vector3 other) {
        return this.x * other.x + this.y * other.y + this.z * other.z;
    }

    public void getCross(Vector3 out, Vector3 other) {
        out.set(this.y * other.z - this.z * other.y, this.z * other.x - this.x * other.z, this.x * other.y - this.y * other.x);
    }

    public double getCrossMagnitude(Vector3 other) {
        double dot = this.getDot(other);
        return Math.sqrt(1.0 - dot * dot);
    }

    public void getArbitraryOrthogonal(Vector3 out) {
        double xdot = Math.abs(this.x);
        double ydot = Math.abs(this.y);
        double zdot = Math.abs(this.z);
        if (xdot <= ydot && xdot <= zdot) {
            Vector3.getUnitX(out);
        } else if (ydot <= xdot && ydot <= zdot) {
            Vector3.getUnitY(out);
        } else {
            Vector3.getUnitZ(out);
        }
        Matrix3 projection = new Matrix3();
        Matrix3.getOrthogonalProjection(projection, this);
        projection.multiply(out);
        assert (CompareReal.eq(out.getDot(this), 0.0));
    }

    public void rotate(Quaternion q) {
        q.rotate(this);
    }

    public void transform(Matrix3 m) {
        m.multiply(this);
    }

    public String toString() {
        return "( " + this.x + ", " + this.y + ", " + this.z + " )";
    }

    public void toAngles(double[] angles) {
        angles[0] = Math.atan2(this.y, this.x);
        angles[1] = Math.atan2(this.z, Math.sqrt(this.x * this.x + this.y * this.y));
    }

    public void fromAngles(double[] angles) {
        this.x = Math.cos(angles[0]) * Math.cos(angles[1]);
        this.y = Math.sin(angles[0]) * Math.cos(angles[1]);
        this.z = Math.sin(angles[1]);
        assert (CompareReal.eq(this.x * this.x + this.y * this.y + this.z * this.z, 1.0));
    }

    public void orthogonalProjection(Vector3 normal) {
        double dot = this.getDot(normal);
        this.set(this.x - normal.x * dot, this.y - normal.y * dot, this.z - normal.z * dot);
        assert (CompareReal.eq(this.getDot(normal), 0.0));
    }

    public boolean equals(Object other) {
        if (other instanceof Vector3) {
            return this.equals((Vector3)other);
        }
        return false;
    }

    public boolean equals(Vector3 other) {
        return this.x == other.x && this.y == other.y && this.z == other.z;
    }

    public boolean approximatelyEquals(Vector3 other) {
        return this.approximatelyEquals(other, CompareReal.getEpsilon());
    }

    public boolean approximatelyEquals(Vector3 other, double epsilon) {
        return CompareReal.eq(this.getDistance(other), 0.0, epsilon);
    }

    public int hashCode() {
        return HashCalculator.combineHashes(Double.valueOf(this.x).hashCode(), Double.valueOf(this.y).hashCode(), Double.valueOf(this.z).hashCode());
    }

    @Override
    public int compareTo(Vector3 other) {
        int result = Double.compare(this.x, other.x);
        if (result != 0) {
            return result;
        }
        result = Double.compare(this.y, other.y);
        if (result != 0) {
            return result;
        }
        return Double.compare(this.z, other.z);
    }
}

