/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.ships;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import cuchaz.modsShared.BlockSide;
import cuchaz.ships.ShipType;
import cuchaz.ships.ShipWorld;
import cuchaz.ships.Ships;
import cuchaz.ships.gui.Gui;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.Icon;
import net.minecraft.world.World;

public class BlockShip
extends Block {
    protected BlockShip(int blockId) {
        super(blockId, Material.field_76243_f);
        this.func_71848_c(5.0f);
        this.func_71894_b(10.0f);
        this.func_71884_a(field_71977_i);
        this.func_71864_b("blockShip");
        this.func_71849_a(CreativeTabs.field_78029_e);
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_71858_a(int side, int meta) {
        switch (BlockSide.getById(side)) {
            case North: 
            case South: 
            case West: 
            case East: {
                return ShipType.getByMeta(meta).getIcon();
            }
        }
        return this.field_94336_cN;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister iconRegister) {
        this.field_94336_cN = iconRegister.func_94245_a("ships:shipTop");
        ShipType.registerIcons(iconRegister);
    }

    public boolean func_71903_a(World world, int x, int y, int z, EntityPlayer player, int side, float xOffset, float yOffset, float zOffset) {
        if (world instanceof ShipWorld) {
            boolean isPaddleEquipped = player.func_71045_bC() != null && player.func_71045_bC().func_77973_b().field_77779_bT == Ships.m_itemPaddle.field_77779_bT;
            ShipWorld shipWorld = (ShipWorld)world;
            if (isPaddleEquipped && shipWorld.getShipType().isPaddleable() && shipWorld.getShip().getCollider().isEntityAboard((Entity)player)) {
                Gui.PaddleShip.open(player, world, x, y, z);
            } else {
                Gui.UnbuildShip.open(player, world, x, y, z);
            }
        } else {
            Gui.BuildShip.open(player, world, x, y, z);
        }
        return true;
    }

    public ShipType getShipType(World world, int x, int y, int z) {
        return ShipType.getByMeta(world.func_72805_g(x, y, z));
    }

    public int func_71899_b(int metadata) {
        return metadata;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_71879_a(int itemId, CreativeTabs tabs, List subItems) {
        ShipType[] shipTypeArray = ShipType.values();
        int n = shipTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ShipType type = shipTypeArray[n2];
            subItems.add(type.newItemStack());
            ++n2;
        }
    }
}

