/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.ships;

import cpw.mods.fml.common.network.PacketDispatcher;
import cuchaz.modsShared.BlockSide;
import cuchaz.modsShared.CircleRange;
import cuchaz.modsShared.CompareReal;
import cuchaz.modsShared.RotatedBB;
import cuchaz.ships.PilotAction;
import cuchaz.ships.ShipCollider;
import cuchaz.ships.ShipLocator;
import cuchaz.ships.ShipPhysics;
import cuchaz.ships.ShipUnlauncher;
import cuchaz.ships.ShipWorld;
import cuchaz.ships.Ships;
import cuchaz.ships.packets.PacketPilotShip;
import cuchaz.ships.propulsion.Propulsion;
import java.util.List;
import java.util.TreeSet;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class EntityShip
extends Entity {
    public static final int LinearThrottleMax = 100;
    public static final int LinearThrottleMin = -25;
    public static final int LinearThrottleStep = 2;
    public static final int AngularThrottleMax = 1;
    public static final int AngularThrottleMin = -1;
    private static final int WatcherIdWaterHeight = 3;
    public float motionYaw;
    public int linearThrottle;
    public int angularThrottle;
    private ShipWorld m_blocks;
    private ShipPhysics m_physics;
    private Propulsion m_propulsion;
    private double m_shipBlockX;
    private double m_shipBlockY;
    private double m_shipBlockZ;
    private int m_pilotActions;
    private int m_oldPilotActions;
    private BlockSide m_sideShipForward;
    private boolean m_sendPilotChangesToServer;
    private boolean m_hasInfoFromServer;
    private double m_xFromServer;
    private double m_yFromServer;
    private double m_zFromServer;
    private float m_yawFromServer;
    private float m_pitchFromServer;
    private TreeSet<ChunkCoordinates> m_previouslyDisplacedWaterBlocks;
    private ShipCollider m_collider;

    public EntityShip(World world) {
        super(world);
        this.field_70129_M = 0.0f;
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.motionYaw = 0.0f;
        this.linearThrottle = 0;
        this.angularThrottle = 0;
        this.m_blocks = null;
        this.m_physics = null;
        this.m_propulsion = null;
        this.m_shipBlockX = 0.0;
        this.m_shipBlockY = 0.0;
        this.m_shipBlockZ = 0.0;
        this.m_pilotActions = 0;
        this.m_oldPilotActions = 0;
        this.m_sideShipForward = null;
        this.m_sendPilotChangesToServer = false;
        this.m_hasInfoFromServer = false;
        this.m_xFromServer = 0.0;
        this.m_yFromServer = 0.0;
        this.m_zFromServer = 0.0;
        this.m_yawFromServer = 0.0f;
        this.m_pitchFromServer = 0.0f;
        this.m_previouslyDisplacedWaterBlocks = null;
        this.m_collider = new ShipCollider(this);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_75682_a(3, (Object)-1);
    }

    public void setBlocks(ShipWorld blocks) {
        if (!blocks.isValid()) {
            this.func_70106_y();
            Ships.logger.warning("Ship world is invalid. Killed ship.");
            return;
        }
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.motionYaw = 0.0f;
        this.m_blocks = blocks;
        blocks.setShip(this);
        this.m_physics = new ShipPhysics(this.m_blocks);
        this.m_propulsion = new Propulsion(this.m_blocks);
        Vec3 centerOfMass = this.m_physics.getCenterOfMass();
        this.m_shipBlockX = -centerOfMass.field_72450_a;
        this.m_shipBlockY = -centerOfMass.field_72448_b;
        this.m_shipBlockZ = -centerOfMass.field_72449_c;
        this.m_collider.computeShipBoundingBox(this.field_70121_D, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z);
        Ships.logger.info(String.format("%s EntityShip %d initialized at (%.2f,%.2f,%.2f) + (%.4f,%.4f,%.4f)", this.field_70170_p.field_72995_K ? "CLIENT" : "SERVER", this.field_70157_k, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70159_w, this.field_70181_x, this.field_70179_y));
        ShipLocator.registerShip(this);
    }

    public void func_70106_y() {
        super.func_70106_y();
        if (this.m_previouslyDisplacedWaterBlocks != null) {
            for (ChunkCoordinates coords : this.m_previouslyDisplacedWaterBlocks) {
                if (this.field_70170_p.func_72798_a(coords.field_71574_a, coords.field_71572_b, coords.field_71573_c) != Ships.m_blockAirWall.field_71990_ca) continue;
                this.field_70170_p.func_94575_c(coords.field_71574_a, coords.field_71572_b, coords.field_71573_c, Block.field_71943_B.field_71990_ca);
            }
        }
        Ships.logger.info(String.format("%s EntityShip %d died!", this.field_70170_p.field_72995_K ? "CLIENT" : "SERVER", this.field_70157_k));
        ShipLocator.unregisterShip(this);
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        this.setWaterHeight(nbt.func_74762_e("waterHeight"));
        this.setBlocks(new ShipWorld(this.field_70170_p, nbt.func_74770_j("blocks")));
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        nbt.func_74768_a("waterHeight", this.getWaterHeight());
        nbt.func_74773_a("blocks", this.m_blocks.getData());
    }

    public ShipWorld getBlocks() {
        return this.m_blocks;
    }

    public Propulsion getPropulsion() {
        return this.m_propulsion;
    }

    public ShipCollider getCollider() {
        return this.m_collider;
    }

    public int getWaterHeight() {
        return this.field_70180_af.func_75679_c(3);
    }

    public void setWaterHeight(int val) {
        this.field_70180_af.func_75692_b(3, (Object)val);
    }

    public boolean func_70067_L() {
        return true;
    }

    public void func_70107_b(double x, double y, double z) {
        this.field_70165_t = x;
        this.field_70163_u = y;
        this.field_70161_v = z;
        if (this.m_collider != null) {
            this.m_collider.computeShipBoundingBox(this.field_70121_D, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z);
        }
    }

    public void func_70056_a(double x, double y, double z, float yaw, float pitch, int alwaysThree) {
        this.m_hasInfoFromServer = true;
        this.m_xFromServer = x;
        this.m_yFromServer = y;
        this.m_zFromServer = z;
        this.m_yawFromServer = yaw;
        this.m_pitchFromServer = pitch;
    }

    public void func_70071_h_() {
        if (this.field_70128_L) {
            return;
        }
        if (this.m_blocks == null) {
            return;
        }
        double waterHeightInBlockSpace = this.shipToBlocksY(this.worldToShipY(this.getWaterHeight()));
        this.adjustMotionDueToGravityAndBuoyancy(waterHeightInBlockSpace);
        this.adjustMotionDueToThrustAndDrag(waterHeightInBlockSpace);
        double dx = this.field_70159_w;
        double dy = this.field_70181_x;
        double dz = this.field_70179_y;
        float dYaw = this.motionYaw;
        if (this.m_hasInfoFromServer) {
            double yawRadServer;
            double yawDelta;
            dx += this.m_xFromServer - this.field_70165_t;
            dy += this.m_yFromServer - this.field_70163_u;
            dz += this.m_zFromServer - this.field_70161_v;
            double yawRadClient = CircleRange.mapMinusPiToPi(Math.toRadians(this.field_70177_z));
            if (!CompareReal.eq(CircleRange.mapMinusPiToPi(yawRadClient + (yawDelta = CircleRange.newByShortSegment(yawRadClient, yawRadServer = CircleRange.mapMinusPiToPi(Math.toRadians(this.m_yawFromServer))).getLength())), yawRadServer)) {
                yawDelta = -yawDelta;
            }
            yawDelta = Math.toDegrees(yawDelta);
            dYaw = (float)((double)dYaw + yawDelta);
            this.field_70125_A = this.m_pitchFromServer;
            this.m_hasInfoFromServer = false;
        }
        double Epsilon = 0.001;
        if (Math.abs(dx) >= 0.001 || Math.abs(dy) >= 0.001 || Math.abs(dz) >= 0.001 || (double)Math.abs(dYaw) >= 0.001) {
            List<Entity> riders = this.m_collider.getRiders();
            this.field_70169_q = this.field_70165_t;
            this.field_70167_r = this.field_70163_u;
            this.field_70166_s = this.field_70161_v;
            this.field_70126_B = this.field_70177_z;
            this.field_70127_C = this.field_70125_A;
            this.m_collider.moveShip(dx, dy, dz, dYaw);
            dx = this.field_70165_t - this.field_70169_q;
            dy = this.field_70163_u - this.field_70167_r;
            dz = this.field_70161_v - this.field_70166_s;
            dYaw = this.field_70177_z - this.field_70126_B;
            this.moveWater(waterHeightInBlockSpace);
            this.moveRiders(riders, dx, dy, dz, dYaw);
        }
        if (this.isSunk(waterHeightInBlockSpace)) {
            Ships.logger.info(String.format("%s Ship Sunk!", this.field_70170_p.field_72995_K ? "CLIENT" : "SERVER"));
            ShipUnlauncher unlauncher = new ShipUnlauncher(this);
            unlauncher.snapToNearestDirection();
            unlauncher.unlaunch();
            return;
        }
        this.m_blocks.func_72939_s();
    }

    public boolean func_130002_c(EntityPlayer player) {
        TreeSet<MovingObjectPosition> intersections = this.m_collider.getBlocksPlayerIsLookingAt(player);
        if (intersections.isEmpty()) {
            Ships.logger.fine(String.format("%s EntityShip.interact(): no hit", this.field_70170_p.field_72995_K ? "CLIENT" : "SERVER"));
            return false;
        }
        MovingObjectPosition intersection = intersections.first();
        Block block = Block.field_71973_m[this.m_blocks.func_72798_a(intersection.field_72311_b, intersection.field_72312_c, intersection.field_72309_d)];
        Ships.logger.fine(String.format("%s EntityShip.interact(): (%d,%d,%d) %s", this.field_70170_p.field_72995_K ? "CLIENT" : "SERVER", intersection.field_72311_b, intersection.field_72312_c, intersection.field_72309_d, block.func_71917_a()));
        return block.func_71903_a((World)this.m_blocks, intersection.field_72311_b, intersection.field_72312_c, intersection.field_72309_d, player, intersection.field_72310_e, (float)intersection.field_72307_f.field_72450_a, (float)intersection.field_72307_f.field_72448_b, (float)intersection.field_72307_f.field_72449_c);
    }

    private boolean isSunk(double waterHeight) {
        boolean isUnderwater;
        boolean bl = isUnderwater = waterHeight > (double)this.m_blocks.getBoundingBox().maxY + 1.5;
        return this.field_70181_x == 0.0 && isUnderwater;
    }

    public void worldToShip(Vec3 v) {
        double x = this.worldToShipX(v.field_72450_a, v.field_72449_c);
        double y = this.worldToShipY(v.field_72448_b);
        double z = this.worldToShipZ(v.field_72450_a, v.field_72449_c);
        v.field_72450_a = x;
        v.field_72448_b = y;
        v.field_72449_c = z;
    }

    public void worldToShipDirection(Vec3 v) {
        float yawRad = (float)Math.toRadians(this.field_70177_z);
        float cos = MathHelper.func_76134_b((float)yawRad);
        float sin = MathHelper.func_76126_a((float)yawRad);
        double x = v.field_72450_a * (double)cos - v.field_72449_c * (double)sin;
        double z = v.field_72450_a * (double)sin + v.field_72449_c * (double)cos;
        v.field_72450_a = x;
        v.field_72449_c = z;
    }

    public double worldToShipX(double x, double z) {
        float yawRad = (float)Math.toRadians(this.field_70177_z);
        double cos = MathHelper.func_76134_b((float)yawRad);
        double sin = MathHelper.func_76126_a((float)yawRad);
        return (x - this.field_70165_t) * cos - (z - this.field_70161_v) * sin;
    }

    public double worldToShipY(double y) {
        return y - this.field_70163_u;
    }

    public double worldToShipZ(double x, double z) {
        float yawRad = (float)Math.toRadians(this.field_70177_z);
        double cos = MathHelper.func_76134_b((float)yawRad);
        double sin = MathHelper.func_76126_a((float)yawRad);
        return (x - this.field_70165_t) * sin + (z - this.field_70161_v) * cos;
    }

    public void shipToWorld(Vec3 v) {
        double x = this.shipToWorldX(v.field_72450_a, v.field_72449_c);
        double y = this.shipToWorldY(v.field_72448_b);
        double z = this.shipToWorldZ(v.field_72450_a, v.field_72449_c);
        v.field_72450_a = x;
        v.field_72448_b = y;
        v.field_72449_c = z;
    }

    public void shipToWorldDirection(Vec3 v) {
        float yawRad = (float)Math.toRadians(this.field_70177_z);
        float cos = MathHelper.func_76134_b((float)yawRad);
        float sin = MathHelper.func_76126_a((float)yawRad);
        double x = v.field_72450_a * (double)cos + v.field_72449_c * (double)sin;
        double z = -v.field_72450_a * (double)sin + v.field_72449_c * (double)cos;
        v.field_72450_a = x;
        v.field_72449_c = z;
    }

    public double shipToWorldX(double x, double z) {
        float yawRad = (float)Math.toRadians(this.field_70177_z);
        double cos = MathHelper.func_76134_b((float)yawRad);
        double sin = MathHelper.func_76126_a((float)yawRad);
        return x * cos + z * sin + this.field_70165_t;
    }

    public double shipToWorldY(double y) {
        return y + this.field_70163_u;
    }

    public double shipToWorldZ(double x, double z) {
        float yawRad = (float)Math.toRadians(this.field_70177_z);
        double cos = MathHelper.func_76134_b((float)yawRad);
        double sin = MathHelper.func_76126_a((float)yawRad);
        return -x * sin + z * cos + this.field_70161_v;
    }

    public void shipToBlocks(Vec3 v) {
        v.field_72450_a = this.shipToBlocksX(v.field_72450_a);
        v.field_72448_b = this.shipToBlocksY(v.field_72448_b);
        v.field_72449_c = this.shipToBlocksZ(v.field_72449_c);
    }

    public double shipToBlocksX(double x) {
        return x - this.m_shipBlockX;
    }

    public double shipToBlocksY(double y) {
        return y - this.m_shipBlockY;
    }

    public double shipToBlocksZ(double z) {
        return z - this.m_shipBlockZ;
    }

    public void blocksToShip(Vec3 v) {
        v.field_72450_a = this.blocksToShipX(v.field_72450_a);
        v.field_72448_b = this.blocksToShipY(v.field_72448_b);
        v.field_72449_c = this.blocksToShipZ(v.field_72449_c);
    }

    public double blocksToShipX(double x) {
        return x + this.m_shipBlockX;
    }

    public double blocksToShipY(double y) {
        return y + this.m_shipBlockY;
    }

    public double blocksToShipZ(double z) {
        return z + this.m_shipBlockZ;
    }

    public RotatedBB worldToBlocks(AxisAlignedBB box) {
        Vec3 center = Vec3.func_72443_a((double)((box.field_72340_a + box.field_72336_d) / 2.0), (double)((box.field_72338_b + box.field_72337_e) / 2.0), (double)((box.field_72339_c + box.field_72334_f) / 2.0));
        this.worldToShip(center);
        this.shipToBlocks(center);
        double dxh = (box.field_72336_d - box.field_72340_a) / 2.0;
        double dyh = (box.field_72337_e - box.field_72338_b) / 2.0;
        double dzh = (box.field_72334_f - box.field_72339_c) / 2.0;
        box = AxisAlignedBB.func_72330_a((double)(center.field_72450_a - dxh), (double)(center.field_72448_b - dyh), (double)(center.field_72449_c - dzh), (double)(center.field_72450_a + dxh), (double)(center.field_72448_b + dyh), (double)(center.field_72449_c + dzh));
        return new RotatedBB(box, -this.field_70177_z);
    }

    public RotatedBB blocksToWorld(AxisAlignedBB box) {
        Vec3 center = Vec3.func_72443_a((double)((box.field_72340_a + box.field_72336_d) / 2.0), (double)((box.field_72338_b + box.field_72337_e) / 2.0), (double)((box.field_72339_c + box.field_72334_f) / 2.0));
        this.blocksToShip(center);
        this.shipToWorld(center);
        double dxh = (box.field_72336_d - box.field_72340_a) / 2.0;
        double dyh = (box.field_72337_e - box.field_72338_b) / 2.0;
        double dzh = (box.field_72334_f - box.field_72339_c) / 2.0;
        box = AxisAlignedBB.func_72330_a((double)(center.field_72450_a - dxh), (double)(center.field_72448_b - dyh), (double)(center.field_72449_c - dzh), (double)(center.field_72450_a + dxh), (double)(center.field_72448_b + dyh), (double)(center.field_72449_c + dzh));
        return new RotatedBB(box, this.field_70177_z);
    }

    private void adjustMotionDueToGravityAndBuoyancy(double waterHeightInBlockSpace) {
        Vec3 velocity = Vec3.func_72443_a((double)0.0, (double)this.field_70181_x, (double)0.0);
        double accelerationDueToBouyancy = this.m_physics.getNetUpAcceleration(waterHeightInBlockSpace);
        double accelerationDueToDrag = this.m_physics.getLinearAccelerationDueToDrag(velocity, waterHeightInBlockSpace, this.m_blocks.getGeometry().getEnvelopes());
        accelerationDueToDrag = Math.min(Math.abs(this.field_70181_x + accelerationDueToBouyancy), accelerationDueToDrag);
        if (Math.signum(accelerationDueToDrag) == Math.signum(this.field_70181_x)) {
            accelerationDueToDrag *= -1.0;
        }
        this.field_70181_x += accelerationDueToBouyancy + accelerationDueToDrag;
    }

    private void adjustMotionDueToThrustAndDrag(double waterHeightInBlockSpace) {
        double velocityDirZ;
        double velocityDirX;
        double speed;
        PilotAction.resetShip(this, this.m_pilotActions, this.m_oldPilotActions);
        PilotAction.applyToShip(this, this.m_pilotActions);
        this.m_oldPilotActions = this.m_pilotActions;
        if (this.linearThrottle < -25) {
            this.linearThrottle = -25;
        }
        if (this.linearThrottle > 100) {
            this.linearThrottle = 100;
        }
        if ((speed = Math.sqrt((velocityDirX = this.field_70159_w) * velocityDirX + (velocityDirZ = this.field_70179_y) * velocityDirZ)) > 0.0) {
            velocityDirX /= speed;
            velocityDirZ /= speed;
        }
        Vec3 velocityInBlockCoords = Vec3.func_72443_a((double)this.field_70159_w, (double)0.0, (double)this.field_70179_y);
        this.worldToShipDirection(velocityInBlockCoords);
        double linearAccelerationDueToDrag = this.m_physics.getLinearAccelerationDueToDrag(velocityInBlockCoords, waterHeightInBlockSpace, this.m_blocks.getGeometry().getEnvelopes());
        linearAccelerationDueToDrag = Math.min(speed, linearAccelerationDueToDrag);
        this.field_70159_w += -velocityDirX * linearAccelerationDueToDrag;
        this.field_70179_y += -velocityDirZ * linearAccelerationDueToDrag;
        if (this.m_sideShipForward != null) {
            if (this.m_sendPilotChangesToServer) {
                PacketPilotShip packet = new PacketPilotShip(this.field_70157_k, this.m_pilotActions, this.m_sideShipForward, this.linearThrottle, this.angularThrottle);
                PacketDispatcher.sendPacketToServer((Packet)packet.getCustomPacket());
                this.m_sendPilotChangesToServer = false;
            }
            float yawRad = (float)Math.toRadians(this.field_70177_z);
            float cos = MathHelper.func_76134_b((float)yawRad);
            float sin = MathHelper.func_76126_a((float)yawRad);
            double forwardX = (float)this.m_sideShipForward.getDx() * cos + (float)this.m_sideShipForward.getDz() * sin;
            double forwardZ = (float)(-this.m_sideShipForward.getDx()) * sin + (float)this.m_sideShipForward.getDz() * cos;
            double linearAccelerationDueToThrust = this.m_physics.getLinearAccelerationDueToThrust(this.m_propulsion) * (double)this.linearThrottle / 100.0;
            this.field_70159_w += forwardX * linearAccelerationDueToThrust;
            this.field_70179_y += forwardZ * linearAccelerationDueToThrust;
        }
        double angularAccelerationDueToThrust = this.m_physics.getAngularAccelerationDueToThrust(this.m_propulsion) * (float)this.angularThrottle / 1.0f;
        double angularAccelerationDueToDrag = this.m_physics.getAngularAccelerationDueToDrag(this.motionYaw);
        angularAccelerationDueToDrag = Math.min((double)Math.abs(this.motionYaw), angularAccelerationDueToDrag);
        if (Math.signum(angularAccelerationDueToDrag) == (double)Math.signum(this.motionYaw)) {
            angularAccelerationDueToDrag *= -1.0;
        }
        this.motionYaw = (float)((double)this.motionYaw + (angularAccelerationDueToThrust + angularAccelerationDueToDrag));
    }

    private void moveWater(double waterHeightBlocks) {
        int surfaceLevelBlocks = MathHelper.func_76128_c((double)waterHeightBlocks);
        TreeSet<ChunkCoordinates> trappedAirBlocks = this.m_blocks.getGeometry().getTrappedAir(surfaceLevelBlocks);
        if (trappedAirBlocks.isEmpty()) {
            return;
        }
        int surfaceLevelWorld = this.getWaterHeight();
        TreeSet<ChunkCoordinates> displacedWaterBlocks = new TreeSet<ChunkCoordinates>();
        AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
        Vec3 p = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
        for (ChunkCoordinates coords : trappedAirBlocks) {
            p.field_72450_a = (double)coords.field_71574_a + 0.5;
            p.field_72448_b = (double)coords.field_71572_b + 0.5;
            p.field_72449_c = (double)coords.field_71573_c + 0.5;
            this.blocksToShip(p);
            this.shipToWorld(p);
            this.m_collider.getBlockWorldBoundingBox(box, coords);
            double Delta = 0.1;
            box.func_72314_b(0.1, 0.1, 0.1);
            int minX = MathHelper.func_76128_c((double)box.field_72340_a);
            int maxX = MathHelper.func_76128_c((double)box.field_72336_d);
            int minY = MathHelper.func_76128_c((double)box.field_72338_b);
            int maxY = Math.min(MathHelper.func_76128_c((double)box.field_72337_e), surfaceLevelWorld - 1);
            int minZ = MathHelper.func_76128_c((double)box.field_72339_c);
            int maxZ = MathHelper.func_76128_c((double)box.field_72334_f);
            int x = minX;
            while (x <= maxX) {
                int z = minZ;
                while (z <= maxZ) {
                    int y = minY;
                    while (y <= maxY) {
                        Material material = this.field_70170_p.func_72803_f(x, y, z);
                        if (material == Material.field_76244_g || material == Material.field_76249_a || material == Ships.m_materialAirWall) {
                            displacedWaterBlocks.add(new ChunkCoordinates(x, y, z));
                        }
                        ++y;
                    }
                    ++z;
                }
                ++x;
            }
        }
        for (ChunkCoordinates coords : displacedWaterBlocks) {
            if (this.m_previouslyDisplacedWaterBlocks != null && this.m_previouslyDisplacedWaterBlocks.contains(coords)) continue;
            this.field_70170_p.func_94575_c(coords.field_71574_a, coords.field_71572_b, coords.field_71573_c, Ships.m_blockAirWall.field_71990_ca);
        }
        if (this.m_previouslyDisplacedWaterBlocks != null) {
            for (ChunkCoordinates coords : this.m_previouslyDisplacedWaterBlocks) {
                if (displacedWaterBlocks.contains(coords)) continue;
                this.field_70170_p.func_94575_c(coords.field_71574_a, coords.field_71572_b, coords.field_71573_c, Block.field_71943_B.field_71990_ca);
            }
        }
        this.m_previouslyDisplacedWaterBlocks = displacedWaterBlocks;
    }

    private void moveRiders(List<Entity> riders, double dx, double dy, double dz, float dYaw) {
        Vec3 p = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
        for (Entity rider : riders) {
            p.field_72450_a = rider.field_70165_t + dx;
            p.field_72449_c = rider.field_70161_v + dz;
            this.worldToShip(p);
            float yawRad = (float)Math.toRadians(dYaw);
            float cos = MathHelper.func_76134_b((float)yawRad);
            float sin = MathHelper.func_76126_a((float)yawRad);
            double x = p.field_72450_a * (double)cos + p.field_72449_c * (double)sin;
            double z = -p.field_72450_a * (double)sin + p.field_72449_c * (double)cos;
            p.field_72450_a = x;
            p.field_72449_c = z;
            this.shipToWorld(p);
            rider.field_70177_z -= dYaw;
            rider.func_70107_b(p.field_72450_a, rider.field_70163_u + dy, p.field_72449_c);
        }
    }

    public void setPilotActions(int actions, BlockSide sideShipForward, boolean sendPilotChangesToServer) {
        this.m_pilotActions = actions;
        this.m_sideShipForward = sideShipForward;
        this.m_sendPilotChangesToServer = sendPilotChangesToServer;
    }
}

