/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.ships;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import cuchaz.modsShared.BlockUtils;
import cuchaz.ships.MaterialProperties;
import cuchaz.ships.ShipGeometry;
import cuchaz.ships.ShipType;
import cuchaz.ships.Ships;
import cuchaz.ships.gui.GuiString;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.zip.GZIPOutputStream;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import org.apache.commons.codec.binary.Base64OutputStream;

public class ItemShipClipboard
extends Item {
    public ItemShipClipboard(int itemId) {
        super(itemId);
        this.field_77777_bU = 1;
        this.func_77637_a(CreativeTabs.field_78040_i);
        this.func_77655_b("shipClipboard");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a("ships:shipClipboard");
    }

    public boolean onItemUseFirst(ItemStack itemStack, EntityPlayer player, final World world, int blockX, int blockY, int blockZ, int side, float hitX, float hitY, float hitZ) {
        int blockId = world.func_72798_a(blockX, blockY, blockZ);
        if (blockId != Ships.m_blockShip.field_71990_ca) {
            return false;
        }
        ShipType shipType = Ships.m_blockShip.getShipType(world, blockX, blockY, blockZ);
        List<ChunkCoordinates> blocks = BlockUtils.searchForBlocks(blockX, blockY, blockZ, shipType.getMaxNumBlocks(), new BlockUtils.BlockValidator(){

            @Override
            public boolean isValid(ChunkCoordinates coords) {
                return !MaterialProperties.isSeparatorBlock(Block.field_71973_m[world.func_72798_a(coords.field_71574_a, coords.field_71572_b, coords.field_71573_c)]);
            }
        }, ShipGeometry.ShipBlockNeighbors);
        if (blocks == null) {
            this.message(player, GuiString.NoShipWasFoundHere);
            return false;
        }
        blocks.add(new ChunkCoordinates(blockX, blockY, blockZ));
        try {
            String encodedBlocks = this.encodeBlocks(world, blocks);
            StringSelection selection = new StringSelection(encodedBlocks);
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(selection, selection);
            this.message(player, GuiString.CopiedShip);
            return true;
        }
        catch (IOException ex) {
            Ships.logger.log(Level.WARNING, "Unable to copy ship!", ex);
            this.message(player, GuiString.ErrorCheckLogForDetails);
            return false;
        }
    }

    private String encodeBlocks(World world, List<ChunkCoordinates> blocks) throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(new GZIPOutputStream(new Base64OutputStream(buffer)));
        out.writeInt(blocks.size());
        for (ChunkCoordinates coords : blocks) {
            out.writeInt(coords.field_71574_a);
            out.writeInt(coords.field_71572_b);
            out.writeInt(coords.field_71573_c);
            out.writeInt(world.func_72798_a(coords.field_71574_a, coords.field_71572_b, coords.field_71573_c));
            out.writeInt(world.func_72805_g(coords.field_71574_a, coords.field_71572_b, coords.field_71573_c));
        }
        out.close();
        return new String(buffer.toByteArray(), "UTF-8");
    }

    private void message(EntityPlayer player, GuiString text) {
        if (player.field_70170_p.field_72995_K) {
            player.func_71035_c(text.getLocalizedText());
        }
    }
}

